/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.openapi.editor.Editor;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class DaemonTooltipUtil {
    private static final TooltipGroup DAEMON_INFO_GROUP = new TooltipGroup("DAEMON_INFO_GROUP", 0);

    public static void showInfoTooltip(HighlightInfo info, Editor editor, int defaultOffset) {
        DaemonTooltipUtil.showInfoTooltip(info, editor, defaultOffset, -1);
    }

    public static void cancelTooltips() {
        TooltipController.getInstance().cancelTooltip(DAEMON_INFO_GROUP);
    }

    public static void showInfoTooltip(@NotNull HighlightInfo info, Editor editor, int defaultOffset, int currentWidth) {
        if (info == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/DaemonTooltipUtil.showInfoTooltip must not be null");
        }
        if (info.toolTip == null) {
            return;
        }
        Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
        int endOffset = info.highlighter.getEndOffset();
        int startOffset = info.highlighter.getStartOffset();
        Point top = editor.logicalPositionToXY(editor.offsetToLogicalPosition(startOffset));
        Point bottom = editor.logicalPositionToXY(editor.offsetToLogicalPosition(endOffset));
        Point bestPoint = new Point(top.x, bottom.y + editor.getLineHeight());
        if (!visibleArea.contains(bestPoint)) {
            bestPoint = editor.logicalPositionToXY(editor.offsetToLogicalPosition(defaultOffset));
        }
        Point p = SwingUtilities.convertPoint(editor.getContentComponent(), bestPoint, editor.getComponent().getRootPane().getLayeredPane());
        TooltipController.getInstance().showTooltip(editor, p, info.toolTip, currentWidth, false, DAEMON_INFO_GROUP);
    }
}

