/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.impl.actions.AddImportAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PackageUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringActionHandlerFactory;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class MoveClassToModuleFix {
    private MoveClassToModuleFix() {
    }

    public static void registerFixes(QuickFixActionRegistrar registrar, PsiJavaCodeReferenceElement reference) {
        PsiClass[] classes;
        PsiElement psiElement = reference.getElement();
        String referenceName = reference.getRangeInElement().substring(psiElement.getText());
        Project project = psiElement.getProject();
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile == null) {
            return;
        }
        PsiDirectory dir = containingFile.getContainingDirectory();
        if (dir == null) {
            return;
        }
        VirtualFile classVFile = containingFile.getVirtualFile();
        if (classVFile == null) {
            return;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        final Module currentModule = fileIndex.getModuleForFile(classVFile);
        if (currentModule == null) {
            return;
        }
        VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)currentModule).getSourceRoots();
        if (sourceRoots.length == 0) {
            return;
        }
        PsiDirectory sourceDirectory = PsiManager.getInstance((Project)project).findDirectory(sourceRoots[0]);
        if (sourceDirectory == null) {
            return;
        }
        VirtualFile vsourceRoot = fileIndex.getSourceRootForFile(classVFile);
        if (vsourceRoot == null) {
            return;
        }
        final PsiDirectory sourceRoot = PsiManager.getInstance((Project)project).findDirectory(vsourceRoot);
        if (sourceRoot == null) {
            return;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        for (final PsiClass aClass : classes = facade.getShortNamesCache().getClassesByName(referenceName, GlobalSearchScope.allScope((Project)project))) {
            Module classModule;
            PsiFile psiFile;
            if (!facade.getResolveHelper().isAccessible((PsiMember)aClass, psiElement, aClass) || !((psiFile = aClass.getContainingFile()) instanceof PsiJavaFile)) continue;
            PsiJavaFile javaFile = (PsiJavaFile)psiFile;
            final String packageName = javaFile.getPackageName();
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (virtualFile == null || (classModule = fileIndex.getModuleForFile(virtualFile)) == null || classModule == currentModule || ModuleRootManager.getInstance((Module)currentModule).isDependsOn(classModule)) continue;
            IntentionAction action = new IntentionAction(){

                @NotNull
                public String getText() {
                    String string = "Move '" + aClass.getQualifiedName() + "' from module '" + classModule.getName() + "' to '" + currentModule.getName() + "'";
                    if (string == null) {
                        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/MoveClassToModuleFix$1.getText must not return null");
                    }
                    return string;
                }

                @NotNull
                public String getFamilyName() {
                    if ("move it" == null) {
                        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/MoveClassToModuleFix$1.getFamilyName must not return null");
                    }
                    return "move it";
                }

                public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
                    if (project == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/MoveClassToModuleFix$1.isAvailable must not be null");
                    }
                    return true;
                }

                public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
                    if (project == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/MoveClassToModuleFix$1.invoke must not be null");
                    }
                    RefactoringActionHandler moveHandler = RefactoringActionHandlerFactory.getInstance().createMoveHandler();
                    DataManager dataManager = DataManager.getInstance();
                    DataContext dataContext = dataManager.getDataContext();
                    PsiDirectory directory = PackageUtil.findOrCreateDirectoryForPackage(currentModule, packageName, sourceRoot, true);
                    DataContext context = SimpleDataContext.getSimpleContext(LangDataKeys.TARGET_PSI_ELEMENT.getName(), directory, dataContext);
                    String qualifiedName = aClass.getQualifiedName();
                    if (qualifiedName == null) {
                        return;
                    }
                    moveHandler.invoke(project, new PsiElement[]{aClass}, context);
                    PsiReference reference = file.findReferenceAt(editor.getCaretModel().getOffset());
                    PsiClass newClass = JavaPsiFacade.getInstance((Project)project).findClass(qualifiedName, GlobalSearchScope.moduleScope((Module)currentModule));
                    if (reference != null && newClass != null) {
                        AddImportAction action = new AddImportAction(project, reference, editor, newClass);
                        action.execute();
                    }
                }

                public boolean startInWriteAction() {
                    return false;
                }
            };
            registrar.register(action);
        }
    }
}

