/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class QuickFixAction {
    private QuickFixAction() {
    }

    public static void registerQuickFixAction(HighlightInfo info, IntentionAction action, HighlightDisplayKey key) {
        QuickFixAction.registerQuickFixAction(info, null, action, key);
    }

    public static void registerQuickFixAction(HighlightInfo info, IntentionAction action) {
        QuickFixAction.registerQuickFixAction(info, null, action, null);
    }

    @Deprecated
    public static void registerQuickFixAction(HighlightInfo info, IntentionAction action, List<IntentionAction> options, String displayName) {
        if (info == null || action == null) {
            return;
        }
        TextRange fixRange = new TextRange(info.startOffset, info.endOffset);
        if (info.quickFixActionRanges == null) {
            info.quickFixActionRanges = new ArrayList<Pair<HighlightInfo.IntentionActionDescriptor, TextRange>>();
        }
        info.quickFixActionRanges.add((Pair<HighlightInfo.IntentionActionDescriptor, TextRange>)Pair.create((Object)new HighlightInfo.IntentionActionDescriptor(action, options, displayName), (Object)fixRange));
        info.fixStartOffset = Math.min(info.fixStartOffset, fixRange.getStartOffset());
        info.fixEndOffset = Math.max(info.fixEndOffset, fixRange.getEndOffset());
    }

    public static void registerQuickFixAction(HighlightInfo info, TextRange fixRange, IntentionAction action, HighlightDisplayKey key) {
        if (info == null || action == null) {
            return;
        }
        if (fixRange == null) {
            fixRange = new TextRange(info.startOffset, info.endOffset);
        }
        if (info.quickFixActionRanges == null) {
            info.quickFixActionRanges = new ArrayList<Pair<HighlightInfo.IntentionActionDescriptor, TextRange>>();
        }
        info.quickFixActionRanges.add((Pair<HighlightInfo.IntentionActionDescriptor, TextRange>)Pair.create((Object)new HighlightInfo.IntentionActionDescriptor(action, key), (Object)fixRange));
        info.fixStartOffset = Math.min(info.fixStartOffset, fixRange.getStartOffset());
        info.fixEndOffset = Math.max(info.fixEndOffset, fixRange.getEndOffset());
        if (action instanceof HintAction) {
            info.setHint(true);
        }
    }

    public static void unregisterQuickFixAction(HighlightInfo info, Condition<IntentionAction> condition) {
        Iterator<Pair<HighlightInfo.IntentionActionDescriptor, TextRange>> it = info.quickFixActionRanges.iterator();
        while (it.hasNext()) {
            Pair<HighlightInfo.IntentionActionDescriptor, TextRange> pair = it.next();
            if (!condition.value((Object)((HighlightInfo.IntentionActionDescriptor)pair.first).getAction())) continue;
            it.remove();
        }
    }

    @NotNull
    public static List<HighlightInfo.IntentionActionDescriptor> getAvailableActions(@NotNull Editor editor, @NotNull PsiFile file, int passId) {
        int[] nArray;
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/QuickFixAction.getAvailableActions must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/QuickFixAction.getAvailableActions must not be null");
        }
        int offset = editor.getCaretModel().getOffset();
        Project project = file.getProject();
        ArrayList<HighlightInfo.IntentionActionDescriptor> result = new ArrayList<HighlightInfo.IntentionActionDescriptor>();
        List<HighlightInfo> infos = DaemonCodeAnalyzerImpl.getHighlightsAround(editor.getDocument(), project, offset);
        if (passId == -1) {
            nArray = null;
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = passId;
        }
        int[] groups = nArray;
        for (HighlightInfo info : infos) {
            QuickFixAction.addAvailableActionsForGroups(info, editor, file, result, groups, offset);
        }
        ArrayList<HighlightInfo.IntentionActionDescriptor> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/QuickFixAction.getAvailableActions must not return null");
        }
        return arrayList;
    }

    private static void addAvailableActionsForGroups(HighlightInfo info, Editor editor, PsiFile file, List<HighlightInfo.IntentionActionDescriptor> outList, int[] groups, int offset) {
        if (info == null || info.quickFixActionMarkers == null) {
            return;
        }
        if (groups != null && Arrays.binarySearch(groups, info.group) < 0) {
            return;
        }
        for (Pair<HighlightInfo.IntentionActionDescriptor, RangeMarker> pair : info.quickFixActionMarkers) {
            HighlightInfo.IntentionActionDescriptor actionInGroup = (HighlightInfo.IntentionActionDescriptor)pair.first;
            RangeMarker range = (RangeMarker)pair.second;
            if (!range.isValid()) continue;
            int start = range.getStartOffset();
            int end = range.getEndOffset();
            Project project = file.getProject();
            if (start > offset || offset > end || !actionInGroup.getAction().isAvailable(project, editor, file)) continue;
            outList.add(actionInGroup);
        }
    }
}

