/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import org.jetbrains.annotations.Nullable;

public abstract class TailTypeDecorator<T extends LookupElement>
extends LookupElementDecorator<T> {
    public TailTypeDecorator(T delegate) {
        super(delegate);
    }

    public static <T extends LookupElement> TailTypeDecorator<T> withTail(T element, final TailType type) {
        return new TailTypeDecorator<T>(element){

            @Override
            protected TailType computeTailType(InsertionContext context) {
                return type;
            }
        };
    }

    @Nullable
    protected abstract TailType computeTailType(InsertionContext var1);

    public void handleInsert(InsertionContext context) {
        LookupElement delegate = this.getDelegate();
        TailType tailType = this.computeTailType(context);
        LookupItem lookupItem = (LookupItem)delegate.as(LookupItem.class);
        if (lookupItem != null && tailType != null) {
            lookupItem.setTailType(TailType.NONE);
        }
        delegate.handleInsert(context);
        if (tailType != null && tailType.isApplicable(context)) {
            PostprocessReformattingAspect.getInstance(context.getProject()).doPostponedFormatting();
            tailType.processTail(context.getEditor(), context.getTailOffset());
        }
    }
}

