/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.navigation.MethodNavigationOffsetProvider;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class MethodUpDownUtil {
    private MethodUpDownUtil() {
    }

    public static int[] getNavigationOffsets(PsiFile file, int caretOffset) {
        for (MethodNavigationOffsetProvider provider : (MethodNavigationOffsetProvider[])Extensions.getExtensions((ExtensionPointName)MethodNavigationOffsetProvider.EP_NAME)) {
            int[] offsets = provider.getMethodNavigationOffsets(file, caretOffset);
            if (offsets == null || offsets.length <= 0) continue;
            return offsets;
        }
        THashSet array = new THashSet();
        MethodUpDownUtil.addNavigationElements((Collection<PsiElement>)array, file);
        return MethodUpDownUtil.offsetsFromElements((Collection<PsiElement>)array);
    }

    public static int[] offsetsFromElements(Collection<PsiElement> array) {
        TIntArrayList offsets = new TIntArrayList(array.size());
        for (PsiElement element : array) {
            offsets.add(element.getTextOffset());
        }
        offsets.sort();
        return offsets.toNativeArray();
    }

    private static void addNavigationElements(Collection<PsiElement> array, PsiFile element) {
        StructureViewBuilder structureViewBuilder = LanguageStructureViewBuilder.INSTANCE.getStructureViewBuilder(element);
        if (structureViewBuilder instanceof TreeBasedStructureViewBuilder) {
            TreeBasedStructureViewBuilder builder = (TreeBasedStructureViewBuilder)structureViewBuilder;
            StructureViewModel model = builder.createStructureViewModel();
            MethodUpDownUtil.addStructureViewElements((TreeElement)model.getRoot(), array, element);
        }
    }

    private static void addStructureViewElements(TreeElement parent, Collection<PsiElement> array, @NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/navigation/MethodUpDownUtil.addStructureViewElements must not be null");
        }
        for (TreeElement treeElement : parent.getChildren()) {
            Object value = ((StructureViewTreeElement)treeElement).getValue();
            if (value instanceof PsiElement) {
                PsiElement element = (PsiElement)value;
                if (array.contains(element) || !file.equals(element.getContainingFile())) {
                    return;
                }
                array.add(element);
            }
            MethodUpDownUtil.addStructureViewElements(treeElement, array, file);
        }
    }
}

