/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.unwrap;

import com.intellij.codeInsight.unwrap.JavaAnonymousUnwrapper;
import com.intellij.codeInsight.unwrap.JavaBracesUnwrapper;
import com.intellij.codeInsight.unwrap.JavaCatchRemover;
import com.intellij.codeInsight.unwrap.JavaElseRemover;
import com.intellij.codeInsight.unwrap.JavaElseUnwrapper;
import com.intellij.codeInsight.unwrap.JavaForUnwrapper;
import com.intellij.codeInsight.unwrap.JavaIfUnwrapper;
import com.intellij.codeInsight.unwrap.JavaMethodParameterUnwrapper;
import com.intellij.codeInsight.unwrap.JavaSynchronizedUnwrapper;
import com.intellij.codeInsight.unwrap.JavaTryUnwrapper;
import com.intellij.codeInsight.unwrap.JavaWhileUnwrapper;
import com.intellij.codeInsight.unwrap.UnwrapDescriptor;
import com.intellij.codeInsight.unwrap.Unwrapper;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class JavaUnwrapDescriptor
implements UnwrapDescriptor {
    private static final Unwrapper[] UNWRAPPERS = new Unwrapper[]{new JavaMethodParameterUnwrapper(), new JavaElseUnwrapper(), new JavaElseRemover(), new JavaIfUnwrapper(), new JavaWhileUnwrapper(), new JavaForUnwrapper(), new JavaBracesUnwrapper(), new JavaTryUnwrapper(), new JavaCatchRemover(), new JavaSynchronizedUnwrapper(), new JavaAnonymousUnwrapper()};

    @Override
    public List<Pair<PsiElement, Unwrapper>> collectUnwrappers(Project project, Editor editor, PsiFile file) {
        ArrayList<Pair<PsiElement, Unwrapper>> result = new ArrayList<Pair<PsiElement, Unwrapper>>();
        HashSet<PsiElement> ignored = new HashSet<PsiElement>();
        for (PsiElement e = this.findTargetElement(editor, file); e != null; e = e.getParent()) {
            for (Unwrapper u : UNWRAPPERS) {
                if (!u.isApplicableTo(e) || ignored.contains(e)) continue;
                result.add((Pair<PsiElement, Unwrapper>)new Pair((Object)e, (Object)u));
                u.collectElementsToIgnore(e, ignored);
            }
        }
        return result;
    }

    public PsiElement findTargetElement(Editor editor, PsiFile file) {
        int offset = editor.getCaretModel().getOffset();
        return file.findElementAt(offset);
    }

    @Override
    public boolean showOptionsDialog() {
        return true;
    }

    @Override
    public boolean shouldTryToRestoreCaretPosition() {
        return true;
    }
}

