/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.duplicateThrows;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.DeleteThrowsFix;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.BaseLocalInspectionTool;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;

public class DuplicateThrowsInspection
extends BaseLocalInspectionTool {
    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inspection.duplicate.throws.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/duplicateThrows/DuplicateThrowsInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.DECLARATION_REDUNDANCY;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/duplicateThrows/DuplicateThrowsInspection.getGroupDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("DuplicateThrows" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/duplicateThrows/DuplicateThrowsInspection.getShortName must not return null");
        }
        return "DuplicateThrows";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/duplicateThrows/DuplicateThrowsInspection.buildVisitor must not be null");
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
            }

            public void visitMethod(PsiMethod method) {
                PsiReferenceList throwsList = method.getThrowsList();
                PsiJavaCodeReferenceElement[] refs = throwsList.getReferenceElements();
                PsiClassType[] types = throwsList.getReferencedTypes();
                for (int i = 0; i < types.length; ++i) {
                    PsiClassType type = types[i];
                    for (int j = i + 1; j < types.length; ++j) {
                        PsiClassType otherType = types[j];
                        String problem = null;
                        PsiJavaCodeReferenceElement ref = refs[i];
                        if (type.equals((Object)otherType)) {
                            problem = InspectionsBundle.message((String)"inspection.duplicate.throws.problem", (Object[])new Object[0]);
                        } else if (otherType.isAssignableFrom((PsiType)type)) {
                            problem = InspectionsBundle.message((String)"inspection.duplicate.throws.more.general.problem", (Object[])new Object[]{otherType.getCanonicalText()});
                        } else if (type.isAssignableFrom((PsiType)otherType)) {
                            problem = InspectionsBundle.message((String)"inspection.duplicate.throws.more.general.problem", (Object[])new Object[]{type.getCanonicalText()});
                            ref = refs[j];
                            type = otherType;
                        }
                        if (problem == null) continue;
                        holder.registerProblem((PsiElement)ref, problem, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new DeleteThrowsFix(method, type)});
                    }
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/duplicateThrows/DuplicateThrowsInspection.buildVisitor must not return null");
        }
        return javaElementVisitor;
    }
}

