/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant.artifacts;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.Comment;
import com.intellij.compiler.ant.GenerationOptions;
import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.artifacts.ArtifactAntGenerationContextImpl;
import com.intellij.compiler.ant.artifacts.CleanArtifactTarget;
import com.intellij.compiler.ant.artifacts.DirectoryAntCopyInstructionCreator;
import com.intellij.compiler.ant.taskdefs.Copy;
import com.intellij.compiler.ant.taskdefs.Delete;
import com.intellij.compiler.ant.taskdefs.FileSet;
import com.intellij.compiler.ant.taskdefs.Mkdir;
import com.intellij.compiler.ant.taskdefs.Property;
import com.intellij.compiler.ant.taskdefs.Target;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.elements.AntCopyInstructionCreator;
import com.intellij.packaging.elements.ArtifactAntGenerationContext;
import com.intellij.packaging.elements.ComplexPackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import com.intellij.packaging.impl.elements.ModuleOutputPackagingElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ArtifactsGenerator {
    @NonNls
    public static final String BUILD_ALL_ARTIFACTS_TARGET = "build.all.artifacts";
    @NonNls
    private static final String INIT_ARTIFACTS_TARGET = "init.artifacts";
    private final PackagingElementResolvingContext myResolvingContext;
    private ArtifactAntGenerationContextImpl myContext;
    private List<Artifact> myAllArtifacts;

    public ArtifactsGenerator(Project project, GenerationOptions genOptions) {
        this.myResolvingContext = ArtifactManager.getInstance((Project)project).getResolvingContext();
        this.myAllArtifacts = new ArrayList<Artifact>(Arrays.asList(ArtifactManager.getInstance((Project)project).getSortedArtifacts()));
        this.myContext = new ArtifactAntGenerationContextImpl(project, genOptions, this.myAllArtifacts);
    }

    public boolean hasArtifacts() {
        return !this.myAllArtifacts.isEmpty();
    }

    public List<Generator> generate() {
        ArrayList<Generator> generators = new ArrayList<Generator>();
        Target initTarget = new Target(INIT_ARTIFACTS_TARGET, null, null, null);
        generators.add((Generator)initTarget);
        initTarget.add((Generator)new Property("artifacts.temp.dir", BuildProperties.propertyRelativePath((String)BuildProperties.getProjectBaseDirProperty(), (String)"__artifacts_temp")));
        for (Artifact artifact : this.myAllArtifacts) {
            String outputPath;
            if (!this.myContext.shouldBuildIntoTempDirectory(artifact)) {
                generators.add((Generator)new CleanArtifactTarget(artifact, this.myContext));
            }
            if (StringUtil.isEmpty((String)(outputPath = artifact.getOutputPath()))) continue;
            initTarget.add((Generator)new Property(this.myContext.getConfiguredArtifactOutputProperty(artifact), this.myContext.getSubstitutedPath(outputPath)));
        }
        initTarget.add((Generator)new Mkdir(BuildProperties.propertyRef((String)"artifacts.temp.dir")));
        StringBuilder depends = new StringBuilder();
        for (Artifact artifact : this.myAllArtifacts) {
            Target target = this.createArtifactTarget(artifact);
            generators.add((Generator)target);
            if (StringUtil.isEmpty((String)artifact.getOutputPath())) continue;
            if (depends.length() > 0) {
                depends.append(", ");
            }
            depends.append(this.myContext.getTargetName(artifact));
        }
        for (Generator generator : this.myContext.getBeforeBuildGenerators()) {
            initTarget.add(generator);
        }
        Target buildAllArtifacts = new Target(BUILD_ALL_ARTIFACTS_TARGET, depends.toString(), "Build all artifacts", null);
        for (Artifact artifact : this.myAllArtifacts) {
            String artifactOutputPath = artifact.getOutputPath();
            if (StringUtil.isEmpty((String)artifactOutputPath) || !this.myContext.shouldBuildIntoTempDirectory(artifact)) continue;
            String outputPath = BuildProperties.propertyRef((String)this.myContext.getConfiguredArtifactOutputProperty(artifact));
            buildAllArtifacts.add((Generator)new Mkdir(outputPath));
            Copy copy = new Copy(outputPath);
            copy.add((Generator)new FileSet(BuildProperties.propertyRef((String)this.myContext.getArtifactOutputProperty(artifact))));
            buildAllArtifacts.add((Generator)copy);
        }
        buildAllArtifacts.add((Generator)new Comment("Delete temporary files"), 1);
        for (Generator generator : this.myContext.getAfterBuildGenerators()) {
            buildAllArtifacts.add(generator);
        }
        buildAllArtifacts.add((Generator)new Delete(BuildProperties.propertyRef((String)"artifacts.temp.dir")));
        generators.add((Generator)buildAllArtifacts);
        return generators;
    }

    private Target createArtifactTarget(Artifact artifact) {
        final StringBuilder depends = new StringBuilder(INIT_ARTIFACTS_TARGET);
        ArtifactUtil.processPackagingElements(artifact, null, new PackagingElementProcessor<PackagingElement<?>>(){

            @Override
            public boolean shouldProcessSubstitution(ComplexPackagingElement<?> element) {
                return !(element instanceof ArtifactPackagingElement);
            }

            @Override
            public boolean process(@NotNull PackagingElement<?> packagingElement, @NotNull PackagingElementPath path) {
                Module module;
                if (packagingElement == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/ant/artifacts/ArtifactsGenerator$1.process must not be null");
                }
                if (path == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/compiler/ant/artifacts/ArtifactsGenerator$1.process must not be null");
                }
                if (packagingElement instanceof ArtifactPackagingElement) {
                    Artifact included = ((ArtifactPackagingElement)packagingElement).findArtifact(ArtifactsGenerator.this.myResolvingContext);
                    if (included != null) {
                        if (depends.length() > 0) {
                            depends.append(", ");
                        }
                        depends.append(ArtifactsGenerator.this.myContext.getTargetName(included));
                    }
                } else if (packagingElement instanceof ModuleOutputPackagingElement && (module = ((ModuleOutputPackagingElement)packagingElement).findModule(ArtifactsGenerator.this.myResolvingContext)) != null) {
                    if (depends.length() > 0) {
                        depends.append(", ");
                    }
                    depends.append(BuildProperties.getCompileTargetName((String)module.getName()));
                }
                return true;
            }
        }, this.myResolvingContext, true);
        Target artifactTarget = new Target(this.myContext.getTargetName(artifact), depends.toString(), "Build '" + artifact.getName() + "' artifact", null);
        if (this.myContext.shouldBuildIntoTempDirectory(artifact)) {
            String outputDirectory = BuildProperties.propertyRelativePath((String)"artifacts.temp.dir", (String)FileUtil.sanitizeFileName((String)artifact.getName()));
            artifactTarget.add((Generator)new Property(this.myContext.getArtifactOutputProperty(artifact), outputDirectory));
        }
        String outputPath = BuildProperties.propertyRef((String)this.myContext.getArtifactOutputProperty(artifact));
        artifactTarget.add((Generator)new Mkdir(outputPath));
        DirectoryAntCopyInstructionCreator creator = new DirectoryAntCopyInstructionCreator(outputPath);
        ArrayList copyInstructions = new ArrayList();
        copyInstructions.addAll(artifact.getRootElement().computeAntInstructions(this.myResolvingContext, (AntCopyInstructionCreator)creator, (ArtifactAntGenerationContext)this.myContext, artifact.getArtifactType()));
        for (Generator generator : this.myContext.getAndClearBeforeCurrentArtifact()) {
            artifactTarget.add(generator);
        }
        for (Generator tag : copyInstructions) {
            artifactTarget.add(tag);
        }
        return artifactTarget;
    }

    public List<String> getCleanTargetNames() {
        ArrayList<String> targets = new ArrayList<String>();
        for (Artifact artifact : this.myAllArtifacts) {
            if (this.myContext.shouldBuildIntoTempDirectory(artifact)) continue;
            targets.add(this.myContext.getCleanTargetName(artifact));
        }
        return targets;
    }
}

