/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointCategory;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.text.CharArrayUtil;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class MethodBreakpoint
extends BreakpointWithHighlighter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.breakpoints.MethodBreakpoint");
    public boolean WATCH_ENTRY = true;
    public boolean WATCH_EXIT = true;
    private String myMethodName;
    private JVMName mySignature;
    private boolean myIsStatic;
    public static Icon ICON = IconLoader.getIcon((String)"/debugger/db_method_breakpoint.png");
    public static Icon MUTED_ICON = IconLoader.getIcon((String)"/debugger/db_muted_method_breakpoint.png");
    public static Icon DISABLED_ICON = IconLoader.getIcon((String)"/debugger/db_disabled_method_breakpoint.png");
    public static Icon DISABLED_DEP_ICON = IconLoader.getIcon((String)"/debugger/db_dep_method_breakpoint.png");
    public static Icon MUTED_DISABLED_ICON = IconLoader.getIcon((String)"/debugger/db_muted_disabled_method_breakpoint.png");
    public static Icon MUTED_DISABLED_DEP_ICON = IconLoader.getIcon((String)"/debugger/db_muted_dep_method_breakpoint.png");
    private static final Icon ourInvalidIcon = IconLoader.getIcon((String)"/debugger/db_invalid_method_breakpoint.png");
    private static final Icon ourMutedInvalidIcon = IconLoader.getIcon((String)"/debugger/db_muted_invalid_method_breakpoint.png");
    private static final Icon ourVerifiedIcon = IconLoader.getIcon((String)"/debugger/db_verified_method_breakpoint.png");
    private static final Icon ourMutedVerifiedIcon = IconLoader.getIcon((String)"/debugger/db_muted_verified_method_breakpoint.png");
    private static final Icon ourVerifiedWarningIcon = IconLoader.getIcon((String)"/debugger/db_method_warning_breakpoint.png");
    private static final Icon ourMutedVerifiedWarningIcon = IconLoader.getIcon((String)"/debugger/db_muted_method_warning_breakpoint.png");
    @NonNls
    public static final Key<MethodBreakpoint> CATEGORY = BreakpointCategory.lookup("method_breakpoints");

    protected MethodBreakpoint(Project project) {
        super(project);
    }

    private MethodBreakpoint(Project project, RangeHighlighter highlighter) {
        super(project, highlighter);
    }

    public boolean isStatic() {
        return this.myIsStatic;
    }

    public Key<MethodBreakpoint> getCategory() {
        return CATEGORY;
    }

    public PsiMethod getPsiMethod() {
        Document document = this.getDocument();
        if (document == null) {
            return null;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        if (psiFile instanceof PsiJavaFile) {
            int line = this.getLineIndex();
            int offset = CharArrayUtil.shiftForward((CharSequence)document.getCharsSequence(), (int)document.getLineStartOffset(line), (String)" \t");
            return DebuggerUtilsEx.findPsiMethod(psiFile, offset);
        }
        return null;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.myMethodName != null;
    }

    @Override
    protected void reload(PsiFile psiFile) {
        this.myMethodName = null;
        this.mySignature = null;
        MethodDescriptor descriptor = MethodBreakpoint.getMethodDescriptor(this.myProject, psiFile, this.getSourcePosition());
        if (descriptor != null) {
            this.myMethodName = descriptor.methodName;
            this.mySignature = descriptor.methodSignature;
            this.myIsStatic = descriptor.isStatic;
        }
        if (this.myIsStatic) {
            this.INSTANCE_FILTERS_ENABLED = false;
        }
    }

    @Override
    protected void createRequestForPreparedClass(DebugProcessImpl debugProcess, ReferenceType classType) {
        try {
            boolean hasMethod = false;
            for (Method method : classType.allMethods()) {
                String signature = method.signature();
                String name = method.name();
                if (!this.myMethodName.equals(name) || !this.mySignature.getName(debugProcess).equals(signature)) continue;
                hasMethod = true;
                break;
            }
            if (!hasMethod) {
                debugProcess.getRequestsManager().setInvalid(this, DebuggerBundle.message((String)"error.invalid.breakpoint.method.not.found", (Object[])new Object[]{classType.name()}));
                return;
            }
            RequestManagerImpl requestManager = debugProcess.getRequestsManager();
            if (this.WATCH_ENTRY) {
                MethodEntryRequest entryRequest = (MethodEntryRequest)this.findRequest(debugProcess, MethodEntryRequest.class);
                if (entryRequest == null) {
                    entryRequest = requestManager.createMethodEntryRequest(this);
                } else {
                    entryRequest.disable();
                }
                entryRequest.addClassFilter(classType);
                debugProcess.getRequestsManager().enableRequest(entryRequest);
            }
            if (this.WATCH_EXIT) {
                MethodExitRequest exitRequest = (MethodExitRequest)this.findRequest(debugProcess, MethodExitRequest.class);
                if (exitRequest == null) {
                    exitRequest = requestManager.createMethodExitRequest(this);
                } else {
                    exitRequest.disable();
                }
                exitRequest.addClassFilter(classType);
                debugProcess.getRequestsManager().enableRequest(exitRequest);
            }
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
        }
    }

    @Override
    public String getEventMessage(LocatableEvent event) {
        Location location = event.location();
        String locationQName = location.declaringType().name() + "." + location.method().name();
        String locationFileName = "";
        try {
            locationFileName = location.sourceName();
        }
        catch (AbsentInformationException e) {
            locationFileName = this.getSourcePosition().getFile().getName();
        }
        int locationLine = location.lineNumber();
        if (event instanceof MethodEntryEvent) {
            MethodEntryEvent entryEvent = (MethodEntryEvent)event;
            Method method = entryEvent.method();
            return DebuggerBundle.message((String)"status.method.entry.breakpoint.reached", (Object[])new Object[]{method.declaringType().name() + "." + method.name() + "()", locationQName, locationFileName, locationLine});
        }
        if (event instanceof MethodExitEvent) {
            MethodExitEvent exitEvent = (MethodExitEvent)event;
            Method method = exitEvent.method();
            return DebuggerBundle.message((String)"status.method.exit.breakpoint.reached", (Object[])new Object[]{method.declaringType().name() + "." + method.name() + "()", locationQName, locationFileName, locationLine});
        }
        return "";
    }

    @Override
    public PsiElement getEvaluationElement() {
        return this.getPsiClass();
    }

    @Override
    protected Icon getDisabledIcon(boolean isMuted) {
        Breakpoint master = DebuggerManagerEx.getInstanceEx(this.myProject).getBreakpointManager().findMasterBreakpoint(this);
        if (isMuted) {
            return master == null ? MUTED_DISABLED_ICON : MUTED_DISABLED_DEP_ICON;
        }
        return master == null ? DISABLED_ICON : DISABLED_DEP_ICON;
    }

    @Override
    protected Icon getSetIcon(boolean isMuted) {
        return isMuted ? MUTED_ICON : ICON;
    }

    @Override
    protected Icon getInvalidIcon(boolean isMuted) {
        return isMuted ? ourMutedInvalidIcon : ourInvalidIcon;
    }

    @Override
    protected Icon getVerifiedIcon(boolean isMuted) {
        return isMuted ? ourMutedVerifiedIcon : ourVerifiedIcon;
    }

    @Override
    protected Icon getVerifiedWarningsIcon(boolean isMuted) {
        return isMuted ? ourMutedVerifiedWarningIcon : ourVerifiedWarningIcon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDisplayName() {
        StringBuilder buffer = StringBuilderSpinAllocator.alloc();
        try {
            if (this.isValid()) {
                boolean classNameExists;
                String className = this.getClassName();
                boolean bl = classNameExists = className != null && className.length() > 0;
                if (classNameExists) {
                    buffer.append(className);
                }
                if (this.myMethodName != null) {
                    if (classNameExists) {
                        buffer.append(".");
                    }
                    buffer.append(this.myMethodName);
                }
            } else {
                buffer.append(DebuggerBundle.message((String)"status.breakpoint.invalid", (Object[])new Object[0]));
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)buffer);
        }
    }

    @Override
    public boolean evaluateCondition(EvaluationContextImpl context, LocatableEvent event) throws EvaluateException {
        if (!this.matchesEvent(event, context.getDebugProcess())) {
            return false;
        }
        return super.evaluateCondition(context, event);
    }

    public boolean matchesEvent(LocatableEvent event, DebugProcessImpl process) throws EvaluateException {
        if (this.myMethodName == null || this.mySignature == null) {
            return false;
        }
        Method method = event.location().method();
        return method != null && method.name().equals(this.myMethodName) && method.signature().equals(this.mySignature.getName(process));
    }

    public static MethodBreakpoint create(Project project, Document document, int lineIndex) {
        MethodBreakpoint breakpoint = new MethodBreakpoint(project, MethodBreakpoint.createHighlighter(project, document, lineIndex));
        return (MethodBreakpoint)breakpoint.init();
    }

    @Override
    public boolean canMoveTo(SourcePosition position) {
        return super.canMoveTo(position) && PositionUtil.getPsiElementAt(this.getProject(), PsiMethod.class, position) != null;
    }

    @Nullable
    private static MethodDescriptor getMethodDescriptor(final Project project, PsiFile psiJavaFile, final SourcePosition sourcePosition) {
        PsiDocumentManager docManager = PsiDocumentManager.getInstance((Project)project);
        final Document document = docManager.getDocument(psiJavaFile);
        if (document == null) {
            return null;
        }
        MethodDescriptor descriptor = (MethodDescriptor)docManager.commitAndRunReadAction((Computable)new Computable<MethodDescriptor>(){

            public MethodDescriptor compute() {
                PsiMethod method = PositionUtil.getPsiElementAt(project, PsiMethod.class, sourcePosition);
                if (method == null) {
                    return null;
                }
                int methodOffset = method.getTextOffset();
                if (methodOffset < 0) {
                    return null;
                }
                if (document.getLineNumber(methodOffset) < sourcePosition.getLine()) {
                    return null;
                }
                PsiIdentifier identifier = method.getNameIdentifier();
                int methodNameOffset = identifier != null ? identifier.getTextOffset() : methodOffset;
                MethodDescriptor descriptor = new MethodDescriptor();
                descriptor.methodName = method.isConstructor() ? "<init>" : method.getName();
                descriptor.methodSignature = JVMNameUtil.getJVMSignature(method);
                descriptor.isStatic = method.hasModifierProperty("static");
                descriptor.methodLine = document.getLineNumber(methodNameOffset);
                return descriptor;
            }
        });
        if (descriptor == null || descriptor.methodName == null || descriptor.methodSignature == null) {
            return null;
        }
        return descriptor;
    }

    private EventRequest findRequest(DebugProcessImpl debugProcess, Class requestClass) {
        Set<EventRequest> reqSet = debugProcess.getRequestsManager().findRequests(this);
        for (EventRequest eventRequest : reqSet) {
            if (!eventRequest.getClass().equals(requestClass)) continue;
            return eventRequest;
        }
        return null;
    }

    public String toString() {
        return this.getDescription();
    }

    public boolean isBodyAt(Document document, int offset) {
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        if (psiFile instanceof PsiJavaFile) {
            PsiMethod method = DebuggerUtilsEx.findPsiMethod(psiFile, offset);
            return method == this.getPsiMethod();
        }
        return false;
    }

    private static final class MethodDescriptor {
        String methodName;
        JVMName methodSignature;
        boolean isStatic;
        int methodLine;

        private MethodDescriptor() {
        }
    }
}

