/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.Nullable;

public class RunToCursorBreakpoint
extends LineBreakpoint {
    private final boolean myRestoreBreakpoints;

    private RunToCursorBreakpoint(Project project, RangeHighlighter highlighter, boolean restoreBreakpoints) {
        super(project, highlighter);
        this.setVisible(false);
        this.myRestoreBreakpoints = restoreBreakpoints;
    }

    public boolean isRestoreBreakpoints() {
        return this.myRestoreBreakpoints;
    }

    @Override
    public boolean isVisible() {
        return false;
    }

    @Override
    protected boolean isMuted(DebugProcessImpl debugProcess) {
        return false;
    }

    @Nullable
    protected static RunToCursorBreakpoint create(Project project, Document document, int lineIndex, boolean restoreBreakpoints) {
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null) {
            return null;
        }
        RunToCursorBreakpoint breakpoint = new RunToCursorBreakpoint(project, RunToCursorBreakpoint.createHighlighter(project, document, lineIndex), restoreBreakpoints);
        document.getMarkupModel(project).removeHighlighter(breakpoint.getHighlighter());
        return (RunToCursorBreakpoint)breakpoint.init();
    }
}

