/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.FieldDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.StaticDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadGroupDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.ValueMarkup;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Icons;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.ui.DebuggerIcons;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.JTree;
import org.jetbrains.annotations.Nullable;

public class DebuggerTreeRenderer
extends ColoredTreeCellRenderer {
    private static final Icon myThreadGroupIcon = IconLoader.getIcon((String)"/debugger/threadGroup.png");
    private static final Icon myCurrentThreadGroupIcon = IconLoader.getIcon((String)"/debugger/threadGroupCurrent.png");
    private static final Icon myStaticFieldIcon = Icons.FIELD_ICON;
    private static final Icon myStaticIcon = IconLoader.getIcon((String)"/nodes/static.png");
    private static final SimpleTextAttributes DEFAULT_ATTRIBUTES = new SimpleTextAttributes(0, null);
    private static final SimpleTextAttributes SPECIAL_NODE_ATTRIBUTES = new SimpleTextAttributes(0, Color.lightGray);
    private static final SimpleTextAttributes OBJECT_ID_HIGHLIGHT_ATTRIBUTES = new SimpleTextAttributes(0, Color.lightGray);

    public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DebuggerTreeNodeImpl node = (DebuggerTreeNodeImpl)value;
        if (node.getText() != null) {
            node.getText().appendToComponent((SimpleColoredComponent)this);
        }
        this.setIcon(node.getIcon());
    }

    @Nullable
    public static Icon getDescriptorIcon(NodeDescriptorImpl descriptor) {
        Icon nodeIcon = null;
        if (descriptor instanceof ThreadGroupDescriptorImpl) {
            nodeIcon = ((ThreadGroupDescriptorImpl)descriptor).isCurrent() ? myCurrentThreadGroupIcon : myThreadGroupIcon;
        } else if (descriptor instanceof ThreadDescriptorImpl) {
            ThreadDescriptorImpl threadDescriptor = (ThreadDescriptorImpl)descriptor;
            nodeIcon = threadDescriptor.getIcon();
        } else if (descriptor instanceof StackFrameDescriptorImpl) {
            StackFrameDescriptorImpl stackDescriptor = (StackFrameDescriptorImpl)descriptor;
            nodeIcon = stackDescriptor.getIcon();
        } else if (descriptor instanceof ValueDescriptorImpl) {
            ValueDescriptorImpl valueDescriptor = (ValueDescriptorImpl)descriptor;
            nodeIcon = valueDescriptor instanceof FieldDescriptorImpl && ((FieldDescriptorImpl)valueDescriptor).isStatic() ? myStaticFieldIcon : (valueDescriptor.isArray() ? DebuggerIcons.ARRAY_VALUE_ICON : (valueDescriptor.isPrimitive() ? DebuggerIcons.PRIMITIVE_VALUE_ICON : (valueDescriptor instanceof WatchItemDescriptor ? DebuggerIcons.WATCHED_VALUE_ICON : DebuggerIcons.VALUE_ICON)));
        } else if (descriptor instanceof MessageDescriptor) {
            MessageDescriptor messageDescriptor = (MessageDescriptor)descriptor;
            if (messageDescriptor.getKind() == 0) {
                nodeIcon = XDebuggerUIConstants.ERROR_MESSAGE_ICON;
            } else if (messageDescriptor.getKind() == 2) {
                nodeIcon = XDebuggerUIConstants.INFORMATION_MESSAGE_ICON;
            } else if (messageDescriptor.getKind() == 3) {
                nodeIcon = null;
            }
        } else if (descriptor instanceof StaticDescriptorImpl) {
            nodeIcon = myStaticIcon;
        }
        return nodeIcon;
    }

    public static SimpleColoredText getDescriptorText(DebuggerContextImpl debuggerContext, NodeDescriptorImpl descriptor, boolean multiline) {
        return DebuggerTreeRenderer.getDescriptorText(debuggerContext, descriptor, multiline, true);
    }

    public static SimpleColoredText getDescriptorTitle(DebuggerContextImpl debuggerContext, NodeDescriptorImpl descriptor) {
        return DebuggerTreeRenderer.getDescriptorText(debuggerContext, descriptor, false, false);
    }

    private static SimpleColoredText getDescriptorText(DebuggerContextImpl debuggerContext, NodeDescriptorImpl descriptor, boolean multiline, boolean appendValue) {
        String[] strings;
        ValueMarkup markup;
        String nodeName;
        String text;
        SimpleColoredText descriptorText = new SimpleColoredText();
        if (descriptor == null) {
            text = "";
            nodeName = null;
        } else {
            text = descriptor.getLabel();
            nodeName = descriptor.getName();
        }
        if (text.equals(XDebuggerUIConstants.COLLECTING_DATA_MESSAGE)) {
            descriptorText.append(XDebuggerUIConstants.COLLECTING_DATA_MESSAGE, XDebuggerUIConstants.COLLECTING_DATA_HIGHLIGHT_ATTRIBUTES);
            return descriptorText;
        }
        if (descriptor instanceof ValueDescriptor && (markup = ((ValueDescriptor)((Object)descriptor)).getMarkup(debuggerContext.getDebugProcess())) != null) {
            descriptorText.append("[" + markup.getText() + "] ", new SimpleTextAttributes(1, markup.getColor()));
        }
        if ((strings = DebuggerTreeRenderer.breakString(text, nodeName))[0] != null) {
            if (descriptor instanceof MessageDescriptor && ((MessageDescriptor)descriptor).getKind() == 3) {
                descriptorText.append(strings[0], SPECIAL_NODE_ATTRIBUTES);
            } else {
                descriptorText.append(strings[0], DEFAULT_ATTRIBUTES);
            }
        }
        if (strings[1] != null) {
            descriptorText.append(strings[1], XDebuggerUIConstants.VALUE_NAME_ATTRIBUTES);
        }
        if (strings[2] != null) {
            if (descriptor instanceof ValueDescriptorImpl) {
                ValueDescriptorImpl valueDescriptor;
                String valueLabel;
                if (multiline && strings[2].indexOf(10) >= 0 && (strings = DebuggerTreeRenderer.breakString(strings[2], "="))[2] != null) {
                    strings[2] = strings[0] + strings[1] + "\n" + strings[2];
                }
                if ((strings = DebuggerTreeRenderer.breakString(strings[2], valueLabel = (valueDescriptor = (ValueDescriptorImpl)descriptor).getValueLabel()))[0] != null) {
                    descriptorText.append(strings[0], DEFAULT_ATTRIBUTES);
                }
                if (appendValue && strings[1] != null) {
                    if (valueLabel != null && StringUtil.startsWithChar((CharSequence)valueLabel, (char)'{') && valueLabel.indexOf(125) > 0 && !StringUtil.endsWithChar((CharSequence)valueLabel, (char)'}')) {
                        int idx = valueLabel.indexOf(125);
                        String objectId = valueLabel.substring(0, idx + 1);
                        valueLabel = valueLabel.substring(idx + 1);
                        descriptorText.append(objectId, OBJECT_ID_HIGHLIGHT_ATTRIBUTES);
                    }
                    valueLabel = DebuggerUtilsEx.truncateString(valueLabel);
                    EvaluateException exception = descriptor.getEvaluateException();
                    if (exception != null) {
                        String errorMessage = exception.getMessage();
                        if (valueLabel.endsWith(errorMessage)) {
                            descriptorText.append(valueLabel.substring(0, valueLabel.length() - errorMessage.length()), DEFAULT_ATTRIBUTES);
                            descriptorText.append(errorMessage, XDebuggerUIConstants.EXCEPTION_ATTRIBUTES);
                        } else {
                            descriptorText.append(valueLabel, valueDescriptor.isDirty() ? XDebuggerUIConstants.CHANGED_VALUE_ATTRIBUTES : DEFAULT_ATTRIBUTES);
                            descriptorText.append(errorMessage, XDebuggerUIConstants.EXCEPTION_ATTRIBUTES);
                        }
                    } else if (valueLabel.equals(XDebuggerUIConstants.COLLECTING_DATA_MESSAGE)) {
                        descriptorText.append(XDebuggerUIConstants.COLLECTING_DATA_MESSAGE, XDebuggerUIConstants.COLLECTING_DATA_HIGHLIGHT_ATTRIBUTES);
                    } else {
                        descriptorText.append(valueLabel, valueDescriptor.isDirty() ? XDebuggerUIConstants.CHANGED_VALUE_ATTRIBUTES : DEFAULT_ATTRIBUTES);
                    }
                }
            } else {
                descriptorText.append(strings[2], DEFAULT_ATTRIBUTES);
            }
        }
        return descriptorText;
    }

    private static String[] breakString(String source, String substr) {
        if (substr != null && substr.length() > 0) {
            int index = Math.max(source.indexOf(substr), 0);
            String prefix = index > 0 ? source.substring(0, index) : null;
            String suffix = (index += substr.length()) < source.length() - 1 ? source.substring(index) : null;
            return new String[]{prefix, substr, suffix};
        }
        return new String[]{source, null, null};
    }
}

