/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.LocatableConfigurationType;
import com.intellij.execution.Location;
import com.intellij.execution.RunManager;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.junit.RuntimeConfigurationProducer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PreferedProducerFind {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.actions.PreferedProducerFind");

    private PreferedProducerFind() {
    }

    @Nullable
    public static RunnerAndConfigurationSettingsImpl createConfiguration(@NotNull Location location, ConfigurationContext context) {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/actions/PreferedProducerFind.createConfiguration must not be null");
        }
        RuntimeConfigurationProducer preferredProducer = PreferedProducerFind.findPreferredProducer(location, context);
        return preferredProducer != null ? preferredProducer.getConfiguration() : null;
    }

    @Nullable
    public static List<RuntimeConfigurationProducer> findPreferredProducers(Location location, ConfigurationContext context, boolean strict) {
        if (location == null) {
            return null;
        }
        RuntimeConfigurationProducer[] configurationProducers = (RuntimeConfigurationProducer[])ApplicationManager.getApplication().getExtensions(RuntimeConfigurationProducer.RUNTIME_CONFIGURATION_PRODUCER);
        ArrayList<RuntimeConfigurationProducer> producers = new ArrayList<RuntimeConfigurationProducer>();
        for (RuntimeConfigurationProducer prototype : configurationProducers) {
            RuntimeConfigurationProducer producer = prototype.createProducer(location, context);
            if (producer.getConfiguration() == null) continue;
            LOG.assertTrue(producer.getSourceElement() != null, (Object)producer);
            producers.add(producer);
        }
        if (producers.isEmpty()) {
            ConfigurationType[] factories;
            for (ConfigurationType type : factories = RunManager.getInstance((Project)location.getProject()).getConfigurationFactories()) {
                DefaultRuntimeConfigurationProducer prototype;
                RuntimeConfigurationProducer producer;
                if (!(type instanceof LocatableConfigurationType) || (producer = (prototype = new DefaultRuntimeConfigurationProducer((LocatableConfigurationType)type)).createProducer(location, context)).getConfiguration() == null) continue;
                producers.add(producer);
            }
        }
        if (producers.isEmpty()) {
            return null;
        }
        Collections.sort(producers, RuntimeConfigurationProducer.COMPARATOR);
        if (strict) {
            RuntimeConfigurationProducer first = producers.get(0);
            Iterator<RuntimeConfigurationProducer> it = producers.iterator();
            while (it.hasNext()) {
                RuntimeConfigurationProducer producer = it.next();
                if (producer == first || RuntimeConfigurationProducer.COMPARATOR.compare(producer, first) < 0) continue;
                it.remove();
            }
        }
        return producers;
    }

    @Nullable
    private static RuntimeConfigurationProducer findPreferredProducer(Location location, ConfigurationContext context) {
        List<RuntimeConfigurationProducer> producers = PreferedProducerFind.findPreferredProducers(location, context, true);
        if (producers != null) {
            return producers.get(0);
        }
        return null;
    }

    private static class DefaultRuntimeConfigurationProducer
    extends RuntimeConfigurationProducer
    implements Cloneable {
        private PsiElement myPsiElement;

        public DefaultRuntimeConfigurationProducer(LocatableConfigurationType configurationType) {
            super((ConfigurationType)configurationType);
        }

        @Override
        public PsiElement getSourceElement() {
            return this.myPsiElement;
        }

        @Override
        @Nullable
        protected RunnerAndConfigurationSettingsImpl createConfigurationByElement(Location location, ConfigurationContext context) {
            this.myPsiElement = location.getPsiElement();
            return (RunnerAndConfigurationSettingsImpl)((LocatableConfigurationType)this.getConfigurationType()).createConfigurationByLocation(location);
        }

        public int compareTo(Object o) {
            return -1;
        }
    }
}

