/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.configuration;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.configuration.BrowseModuleValueActionListener;
import com.intellij.execution.configurations.ConfigurationUtil;
import com.intellij.execution.junit2.configuration.ConfigurationModuleSelector;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiMethodUtil;
import org.jetbrains.annotations.Nullable;

public abstract class ClassBrowser
extends BrowseModuleValueActionListener {
    private final String myTitle;

    public ClassBrowser(Project project, String title) {
        super(project);
        this.myTitle = title;
    }

    @Override
    @Nullable
    protected String showDialog() {
        TreeClassChooser.ClassFilterWithScope classFilter;
        try {
            classFilter = this.getFilter();
        }
        catch (NoFilterException e) {
            MessagesEx.MessageInfo info = e.getMessageInfo();
            info.showNow();
            return null;
        }
        TreeClassChooser dialog = this.createClassChooser(classFilter);
        this.configureDialog(dialog);
        dialog.showDialog();
        PsiClass psiClass = dialog.getSelectedClass();
        if (psiClass == null) {
            return null;
        }
        this.onClassChoosen(psiClass);
        return JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)psiClass);
    }

    protected TreeClassChooser createClassChooser(TreeClassChooser.ClassFilterWithScope classFilter) {
        return TreeClassChooserFactory.getInstance((Project)this.getProject()).createWithInnerClassesScopeChooser(this.myTitle, classFilter.getScope(), (TreeClassChooser.ClassFilter)classFilter, null);
    }

    protected abstract TreeClassChooser.ClassFilterWithScope getFilter() throws NoFilterException;

    protected void onClassChoosen(PsiClass psiClass) {
    }

    private void configureDialog(TreeClassChooser dialog) {
        String className = this.getText();
        PsiClass psiClass = this.findClass(className);
        if (psiClass == null) {
            return;
        }
        PsiDirectory directory = psiClass.getContainingFile().getContainingDirectory();
        if (directory != null) {
            dialog.selectDirectory(directory);
        }
        dialog.selectClass(psiClass);
    }

    protected abstract PsiClass findClass(String var1);

    public static ClassBrowser createApplicationClassBrowser(Project project, ConfigurationModuleSelector moduleSelector) {
        final TreeClassChooser.ClassFilter applicationClass = new TreeClassChooser.ClassFilter(){

            public boolean isAccepted(PsiClass aClass) {
                return ConfigurationUtil.MAIN_CLASS.value((Object)aClass) && PsiMethodUtil.findMainMethod((PsiClass)aClass) != null;
            }
        };
        return new MainClassBrowser(project, moduleSelector, ExecutionBundle.message((String)"choose.main.class.dialog.title", (Object[])new Object[0])){

            @Override
            protected TreeClassChooser.ClassFilter createFilter(Module module) {
                return applicationClass;
            }
        };
    }

    public static ClassBrowser createAppletClassBrowser(final Project project, final ConfigurationModuleSelector moduleSelector) {
        final String title = ExecutionBundle.message((String)"choose.applet.class.dialog.title", (Object[])new Object[0]);
        return new MainClassBrowser(project, moduleSelector, title){

            @Override
            protected TreeClassChooser createClassChooser(TreeClassChooser.ClassFilterWithScope classFilter) {
                Module module = moduleSelector.getModule();
                GlobalSearchScope scope = module == null ? GlobalSearchScope.allScope((Project)this.myProject) : GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
                PsiClass appletClass = JavaPsiFacade.getInstance((Project)project).findClass("java.applet.Applet", scope);
                return TreeClassChooserFactory.getInstance((Project)this.getProject()).createInheritanceClassChooser(title, classFilter.getScope(), appletClass, false, false, ConfigurationUtil.PUBLIC_INSTANTIATABLE_CLASS);
            }
        };
    }

    public static class NoFilterException
    extends Exception {
        private final MessagesEx.MessageInfo myMessageInfo;

        public NoFilterException(MessagesEx.MessageInfo messageInfo) {
            super(messageInfo.getMessage());
            this.myMessageInfo = messageInfo;
        }

        public MessagesEx.MessageInfo getMessageInfo() {
            return this.myMessageInfo;
        }

        public static NoFilterException noJUnitInModule(Module module) {
            return new NoFilterException(new MessagesEx.MessageInfo(module.getProject(), ExecutionBundle.message((String)"junit.not.found.in.module.error.message", (Object[])new Object[]{module.getName()}), ExecutionBundle.message((String)"cannot.browse.test.inheritors.dialog.title", (Object[])new Object[0])));
        }

        public static NoFilterException moduleDoesntExist(ConfigurationModuleSelector moduleSelector) {
            Project project = moduleSelector.getProject();
            return new NoFilterException(new MessagesEx.MessageInfo(project, ExecutionBundle.message((String)"module.does.not.exists", (Object[])new Object[]{moduleSelector.getModuleName(), project.getName()}), ExecutionBundle.message((String)"cannot.browse.test.inheritors.dialog.title", (Object[])new Object[0])));
        }
    }

    private static abstract class MainClassBrowser
    extends ClassBrowser {
        protected final Project myProject;
        private final ConfigurationModuleSelector myModuleSelector;

        public MainClassBrowser(Project project, ConfigurationModuleSelector moduleSelector, String title) {
            super(project, title);
            this.myProject = project;
            this.myModuleSelector = moduleSelector;
        }

        @Override
        protected PsiClass findClass(String className) {
            return this.myModuleSelector.findClass(className);
        }

        @Override
        protected TreeClassChooser.ClassFilterWithScope getFilter() throws NoFilterException {
            Module module = this.myModuleSelector.getModule();
            final GlobalSearchScope scope = module == null ? GlobalSearchScope.allScope((Project)this.myProject) : GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
            final TreeClassChooser.ClassFilter filter = this.createFilter(module);
            return new TreeClassChooser.ClassFilterWithScope(){

                public GlobalSearchScope getScope() {
                    return scope;
                }

                public boolean isAccepted(PsiClass aClass) {
                    return filter == null || filter.isAccepted(aClass);
                }
            };
        }

        protected TreeClassChooser.ClassFilter createFilter(Module module) {
            return null;
        }
    }
}

