/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Location;
import com.intellij.execution.configurations.RuntimeConfiguration;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.util.config.AbstractProperty;
import java.awt.Color;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestsUIUtil {
    @NonNls
    private static final String ICONS_ROOT = "/runConfigurations/";
    public static final Color PASSED_COLOR = new Color(0, 128, 0);
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.testframework.TestsUIUtil");

    private TestsUIUtil() {
    }

    @Nullable
    public static Object getData(AbstractTestProxy testProxy, String dataId, TestFrameworkRunningModel model) {
        Project project = model.getProperties().getProject();
        if (testProxy == null) {
            return null;
        }
        if (AbstractTestProxy.DATA_KEY.is(dataId)) {
            return testProxy;
        }
        if (PlatformDataKeys.NAVIGATABLE.is(dataId)) {
            return TestsUIUtil.getOpenFileDescriptor(testProxy, model);
        }
        if (PlatformDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            Navigatable[] navigatableArray;
            Navigatable openFileDescriptor = TestsUIUtil.getOpenFileDescriptor(testProxy, model);
            if (openFileDescriptor != null) {
                Navigatable[] navigatableArray2 = new Navigatable[1];
                navigatableArray = navigatableArray2;
                navigatableArray2[0] = openFileDescriptor;
            } else {
                navigatableArray = null;
            }
            return navigatableArray;
        }
        if (LangDataKeys.PSI_ELEMENT.is(dataId)) {
            Location location = testProxy.getLocation(project);
            if (location != null) {
                PsiElement element = location.getPsiElement();
                return element.isValid() ? element : null;
            }
            return null;
        }
        if (Location.DATA_KEY.is(dataId)) {
            return testProxy.getLocation(project);
        }
        if (RuntimeConfiguration.DATA_KEY.is(dataId)) {
            return model.getProperties().getConfiguration();
        }
        return null;
    }

    public static Navigatable getOpenFileDescriptor(AbstractTestProxy testProxy, TestFrameworkRunningModel model) {
        return TestsUIUtil.getOpenFileDescriptor(testProxy, model.getProperties().getProject(), TestConsoleProperties.OPEN_FAILURE_LINE.value((AbstractProperty.AbstractPropertyContainer)model.getProperties()));
    }

    private static Navigatable getOpenFileDescriptor(AbstractTestProxy proxy, Project project, boolean openFailureLine) {
        if (proxy != null) {
            OpenFileDescriptor openFileDescriptor;
            Location location = proxy.getLocation(project);
            if (openFailureLine) {
                return proxy.getDescriptor(location);
            }
            OpenFileDescriptor openFileDescriptor2 = openFileDescriptor = location == null ? null : location.getOpenFileDescriptor();
            if (openFileDescriptor != null && openFileDescriptor.getFile().isValid()) {
                return openFileDescriptor;
            }
        }
        return null;
    }

    public static Icon loadIcon(@NonNls String iconName) {
        Application application = ApplicationManager.getApplication();
        if (application == null || application.isUnitTestMode()) {
            return new ImageIcon(new BufferedImage(1, 1, 5));
        }
        String fullIconName = ICONS_ROOT + iconName + ".png";
        return IconLoader.getIcon((String)fullIconName);
    }

    public static void notifyByBalloon(@NotNull Project project, AbstractTestProxy root, TestConsoleProperties properties, @NotNull Filter filter) {
        int failed;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/TestsUIUtil.notifyByBalloon must not be null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/execution/testframework/TestsUIUtil.notifyByBalloon must not be null");
        }
        if (project.isDisposed()) {
            return;
        }
        int n = failed = root != null ? filter.select(root.getAllTests()).size() : -1;
        if (properties == null) {
            return;
        }
        String testRunDebugId = properties.isDebug() ? ToolWindowId.DEBUG : ToolWindowId.RUN;
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
        if (!Comparing.strEqual((String)toolWindowManager.getActiveToolWindowId(), (String)testRunDebugId)) {
            toolWindowManager.notifyByBalloon(testRunDebugId, failed == -1 ? MessageType.WARNING : (failed > 0 ? MessageType.ERROR : MessageType.INFO), failed == -1 ? ExecutionBundle.message((String)"test.not.started.progress.text", (Object[])new Object[0]) : (failed > 0 ? failed + " " + ExecutionBundle.message((String)"junit.runing.info.tests.failed.label", (Object[])new Object[0]) : ExecutionBundle.message((String)"junit.runing.info.tests.passed.label", (Object[])new Object[0])), null, null);
        }
    }
}

