/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManagerImpl;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.facet.impl.FacetModelBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacetModelImpl
extends FacetModelBase
implements ModifiableFacetModel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.facet.impl.FacetModelImpl");
    private final List<Facet> myFacets = new ArrayList<Facet>();
    private final Map<Facet, String> myFacet2NewName = new HashMap<Facet, String>();
    private final FacetManagerImpl myManager;
    private final Set<ModifiableFacetModel.Listener> myListeners = new HashSet<ModifiableFacetModel.Listener>();

    public FacetModelImpl(FacetManagerImpl manager) {
        this.myManager = manager;
    }

    public void addFacetsFromManager() {
        for (Facet facet : this.myManager.getAllFacets()) {
            this.addFacet(facet);
        }
    }

    public void addFacet(Facet facet) {
        if (this.myFacets.contains(facet)) {
            LOG.error("Facet " + facet + " [" + facet.getTypeId() + "] is already added");
        }
        this.myFacets.add(facet);
        this.facetsChanged();
    }

    public void removeFacet(Facet facet) {
        if (!this.myFacets.remove(facet)) {
            LOG.error("Facet " + facet + " [" + facet.getTypeId() + "] not found");
        }
        this.myFacet2NewName.remove(facet);
        this.facetsChanged();
    }

    public void rename(Facet facet, String newName) {
        if (!newName.equals(facet.getName())) {
            this.myFacet2NewName.put(facet, newName);
        } else {
            this.myFacet2NewName.remove(facet);
        }
        this.facetsChanged();
    }

    @Nullable
    public String getNewName(Facet facet) {
        return this.myFacet2NewName.get(facet);
    }

    public void commit() {
        this.myManager.commit(this);
    }

    public boolean isModified() {
        return !new HashSet<Facet>(this.myFacets).equals(new HashSet<Facet>(Arrays.asList(this.myManager.getAllFacets()))) || !this.myFacet2NewName.isEmpty();
    }

    public boolean isNewFacet(Facet facet) {
        return this.myFacets.contains(facet) && ArrayUtil.find((Object[])this.myManager.getAllFacets(), (Object)facet) == -1;
    }

    @NotNull
    public Facet[] getAllFacets() {
        Facet[] facetArray = this.myFacets.toArray(new Facet[this.myFacets.size()]);
        if (facetArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/impl/FacetModelImpl.getAllFacets must not return null");
        }
        return facetArray;
    }

    @Override
    @NotNull
    public String getFacetName(@NotNull Facet facet) {
        if (facet == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/FacetModelImpl.getFacetName must not be null");
        }
        String string = this.myFacet2NewName.containsKey(facet) ? this.myFacet2NewName.get(facet) : facet.getName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/impl/FacetModelImpl.getFacetName must not return null");
        }
        return string;
    }

    public void addListener(final @NotNull ModifiableFacetModel.Listener listener, @Nullable Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/FacetModelImpl.addListener must not be null");
        }
        this.myListeners.add(listener);
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

                public void dispose() {
                    FacetModelImpl.this.myListeners.remove(listener);
                }
            });
        }
    }

    @Override
    protected void facetsChanged() {
        ModifiableFacetModel.Listener[] all;
        super.facetsChanged();
        for (ModifiableFacetModel.Listener each : all = this.myListeners.toArray(new ModifiableFacetModel.Listener[this.myListeners.size()])) {
            each.onChanged();
        }
    }
}

