/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.revisions;

import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.ChangeList;
import com.intellij.history.core.changes.ChangeSet;
import com.intellij.history.core.revisions.Revision;
import com.intellij.history.core.tree.Entry;

public class RevisionBeforeChange
extends Revision {
    protected Entry myEntry;
    protected Entry myRoot;
    protected ChangeList myChangeList;
    protected Change myChange;

    public RevisionBeforeChange(Entry e, Entry r, ChangeList cl, Change c) {
        this.myEntry = e;
        this.myRoot = r;
        this.myChangeList = cl;
        this.myChange = c;
    }

    @Override
    public long getTimestamp() {
        return this.myChange.getTimestamp();
    }

    @Override
    public Entry getEntry() {
        Entry rootCopy = this.myRoot.copy();
        this.myChangeList.revertUpTo(rootCopy, this.myChange, this.includeMyChange());
        return rootCopy.getEntry(this.myEntry.getId());
    }

    @Override
    public boolean isBefore(ChangeSet c) {
        return this.myChangeList.isBefore(this.myChange, c, this.includeMyChange());
    }

    protected boolean includeMyChange() {
        return true;
    }
}

