/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.xml;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.XmlLexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.parsing.xml.XmlParser;
import com.intellij.psi.impl.source.xml.XmlFileImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NotNull;

public class XMLParserDefinition
implements ParserDefinition {
    @NotNull
    public Lexer createLexer(Project project) {
        XmlLexer xmlLexer = new XmlLexer();
        if (xmlLexer == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/xml/XMLParserDefinition.createLexer must not return null");
        }
        return xmlLexer;
    }

    public IFileElementType getFileNodeType() {
        return XmlElementType.XML_FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = XmlTokenType.WHITESPACES;
        if (tokenSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/xml/XMLParserDefinition.getWhitespaceTokens must not return null");
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = XmlTokenType.COMMENTS;
        if (tokenSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/xml/XMLParserDefinition.getCommentTokens must not return null");
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenSet.EMPTY;
        if (tokenSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/xml/XMLParserDefinition.getStringLiteralElements must not return null");
        }
        return tokenSet;
    }

    @NotNull
    public PsiParser createParser(Project project) {
        XmlParser xmlParser = new XmlParser();
        if (xmlParser == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/xml/XMLParserDefinition.createParser must not return null");
        }
        return xmlParser;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        PsiElement psiElement = PsiUtilBase.NULL_PSI_ELEMENT;
        if (psiElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/xml/XMLParserDefinition.createElement must not return null");
        }
        return psiElement;
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new XmlFileImpl(viewProvider, (IElementType)XmlElementType.XML_FILE);
    }

    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        Lexer lexer = this.createLexer(left.getPsi().getProject());
        return XmlUtil.canStickTokensTogetherByLexerInXml(left, right, lexer, 0);
    }
}

