/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;

public class EditorWithProviderComposite
extends EditorComposite {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite");
    private final FileEditorProvider[] myProviders;

    EditorWithProviderComposite(VirtualFile file, FileEditor[] editors, FileEditorProvider[] providers, FileEditorManagerEx fileEditorManager) {
        super(file, editors, fileEditorManager);
        this.myProviders = providers;
    }

    public FileEditorProvider[] getProviders() {
        return this.myProviders;
    }

    @Override
    public boolean isModified() {
        FileEditor[] editors;
        for (FileEditor editor : editors = this.getEditors()) {
            if (!editor.isModified()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Pair<FileEditor, FileEditorProvider> getSelectedEditorWithProvider() {
        LOG.assertTrue(this.myEditors.length > 0, (Object)this.myEditors.length);
        if (this.myEditors.length == 1) {
            LOG.assertTrue(this.myTabbedPaneWrapper == null);
            return Pair.create((Object)this.myEditors[0], (Object)this.myProviders[0]);
        }
        LOG.assertTrue(this.myTabbedPaneWrapper != null);
        int index = this.myTabbedPaneWrapper.getSelectedIndex();
        if (index == -1) {
            LOG.error("No selected editors for " + this.getFile());
        }
        LOG.assertTrue(index >= 0, (Object)index);
        LOG.assertTrue(index < this.myEditors.length, (Object)index);
        return Pair.create((Object)this.myEditors[index], (Object)this.myProviders[index]);
    }
}

