/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.HistoryEntry;
import com.intellij.openapi.fileEditor.impl.text.FileDropHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.FocusWatcher;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ArrayListSet;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditorsSplitters
extends JPanel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileEditor.impl.EditorsSplitters");
    private EditorWindow myCurrentWindow;
    private VirtualFile myCurrentFile;
    private final FileEditorManagerImpl myManager;
    private Element mySplittersElement;
    private int myInsideChange = 0;
    private final MyFocusWatcher myFocusWatcher;
    private EditorWithProviderComposite myCurrentSelectedEditor;
    private final Alarm myIconUpdaterAlarm = new Alarm();
    private final Set<VirtualFile> myFilesToUpdateIconsFor = new HashSet<VirtualFile>();
    final Set<EditorWindow> myWindows = new ArrayListSet();

    public EditorsSplitters(FileEditorManagerImpl manager) {
        super(new BorderLayout());
        this.setOpaque(true);
        this.setBackground(Color.GRAY);
        this.myManager = manager;
        this.myFocusWatcher = new MyFocusWatcher();
        this.setFocusTraversalPolicy(new MyFocusTraversalPolicy());
        this.setTransferHandler(new MyTransferHandler());
        this.clear();
    }

    public FileEditorManagerImpl getManager() {
        return this.myManager;
    }

    public void clear() {
        this.removeAll();
        this.myWindows.clear();
        this.setCurrentWindow(null);
        this.myCurrentFile = null;
        this.repaint();
    }

    public void startListeningFocus() {
        this.myFocusWatcher.install(this);
    }

    private void stopListeningFocus() {
        this.myFocusWatcher.deinstall(this);
    }

    public void dispose() {
        this.myIconUpdaterAlarm.cancelAllRequests();
        this.stopListeningFocus();
    }

    @Nullable
    public VirtualFile getCurrentFile() {
        if (this.myCurrentWindow != null) {
            return this.myCurrentWindow.getSelectedFile();
        }
        return null;
    }

    public void writeExternal(Element element) {
        if (this.getComponentCount() != 0) {
            Component comp = this.getComponent(0);
            LOG.assertTrue(comp instanceof JPanel);
            JPanel panel = (JPanel)comp;
            if (panel.getComponentCount() != 0) {
                Element res = this.writePanel(panel);
                element.addContent(res);
            }
        }
    }

    private Element writePanel(JPanel panel) {
        Component comp = panel.getComponent(0);
        if (comp instanceof Splitter) {
            Splitter splitter = (Splitter)comp;
            Element res = new Element("splitter");
            res.setAttribute("split-orientation", splitter.getOrientation() ? "vertical" : "horizontal");
            res.setAttribute("split-proportion", Float.toString(splitter.getProportion()));
            Element first = new Element("split-first");
            first.addContent(this.writePanel((JPanel)splitter.getFirstComponent()));
            Element second = new Element("split-second");
            second.addContent(this.writePanel((JPanel)splitter.getSecondComponent()));
            res.addContent(first);
            res.addContent(second);
            return res;
        }
        if (comp instanceof JBTabs) {
            Element res = new Element("leaf");
            EditorWindow window = this.findWindowWith(comp);
            this.writeWindow(res, window);
            return res;
        }
        if (comp instanceof EditorWindow.TCompForTablessMode) {
            EditorWithProviderComposite composite = ((EditorWindow.TCompForTablessMode)comp).myEditor;
            Element res = new Element("leaf");
            this.writeComposite(res, composite.getFile(), composite, false, composite);
            return res;
        }
        LOG.error(comp != null ? comp.getClass().getName() : null);
        return null;
    }

    private void writeWindow(Element res, EditorWindow window) {
        if (window != null) {
            EditorWithProviderComposite[] composites = window.getEditors();
            for (int i = 0; i < composites.length; ++i) {
                VirtualFile file = window.getFileAt(i);
                boolean isPinned = window.isFilePinned(file);
                EditorWithProviderComposite composite = composites[i];
                EditorWithProviderComposite selectedEditor = window.getSelectedEditor();
                this.writeComposite(res, file, composite, isPinned, selectedEditor);
            }
        }
    }

    private void writeComposite(Element res, VirtualFile file, EditorWithProviderComposite composite, boolean pinned, EditorWithProviderComposite selectedEditor) {
        Object[] editors = composite.getEditors();
        Element fileElement = new Element("file");
        fileElement.setAttribute("leaf-file-name", file.getName());
        FileEditorState[] states = new FileEditorState[editors.length];
        for (int j = 0; j < states.length; ++j) {
            states[j] = editors[j].getState(FileEditorStateLevel.FULL);
            LOG.assertTrue(states[j] != null);
        }
        int selectedProviderIndex = ArrayUtil.find((Object[])editors, (Object)composite.getSelectedEditor());
        LOG.assertTrue(selectedProviderIndex != -1);
        FileEditorProvider[] providers = composite.getProviders();
        HistoryEntry entry = new HistoryEntry(file, providers, states, providers[selectedProviderIndex]);
        entry.writeExternal(fileElement, this.getManager().getProject());
        fileElement.setAttribute("pinned", Boolean.toString(pinned));
        fileElement.setAttribute("current", Boolean.toString(composite.equals(this.getManager().getLastSelected())));
        fileElement.setAttribute("current-in-tab", Boolean.toString(composite.equals(selectedEditor)));
        res.addContent(fileElement);
    }

    public void openFiles() {
        JPanel comp;
        if (this.mySplittersElement != null && (comp = this.readExternalPanel(this.mySplittersElement, this.getTopPanel())) != null) {
            this.removeAll();
            this.add((Component)comp, "Center");
            EditorComposite lastSelected = this.getManager().getLastSelected();
            if (lastSelected != null) {
                this.getManager().openFileImpl3(this.myCurrentWindow, lastSelected.getFile(), true, null, true);
            }
            this.mySplittersElement = null;
        }
    }

    public void readExternal(Element element) {
        this.mySplittersElement = element;
    }

    public JPanel readExternalPanel(Element element, @Nullable JPanel panel) {
        Element splitterElement = element.getChild("splitter");
        if (splitterElement != null) {
            LOG.info("splitter");
            boolean orientation = "vertical".equals(splitterElement.getAttributeValue("split-orientation"));
            float proportion = Float.valueOf(splitterElement.getAttributeValue("split-proportion")).floatValue();
            Element first = splitterElement.getChild("split-first");
            Element second = splitterElement.getChild("split-second");
            if (panel == null) {
                panel = new JPanel(new BorderLayout());
                Splitter splitter = new Splitter(orientation, proportion, 0.1f, 0.9f);
                panel.add((Component)splitter, "Center");
                splitter.setFirstComponent((JComponent)this.readExternalPanel(first, null));
                splitter.setSecondComponent((JComponent)this.readExternalPanel(second, null));
            } else if (panel.getComponent(0) instanceof Splitter) {
                Splitter splitter = (Splitter)panel.getComponent(0);
                this.readExternalPanel(first, (JPanel)splitter.getFirstComponent());
                this.readExternalPanel(second, (JPanel)splitter.getSecondComponent());
            } else {
                this.readExternalPanel(first, panel);
                this.readExternalPanel(second, panel);
            }
            return panel;
        }
        Element leaf = element.getChild("leaf");
        if (leaf != null) {
            EditorWindow window = panel == null ? new EditorWindow(this) : this.findWindowWith(panel);
            try {
                EditorWithProviderComposite editor;
                List children = leaf.getChildren("file");
                VirtualFile currentFile = null;
                for (Element file : children) {
                    HistoryEntry entry = new HistoryEntry(this.getManager().getProject(), file.getChild("entry"));
                    boolean isCurrent = Boolean.valueOf(file.getAttributeValue("current"));
                    this.getManager().openFileImpl3(window, entry.myFile, false, entry, isCurrent);
                    if (!this.getManager().isFileOpen(entry.myFile)) continue;
                    window.setFilePinned(entry.myFile, Boolean.valueOf(file.getAttributeValue("pinned")));
                    if (Boolean.valueOf(file.getAttributeValue("current-in-tab")).booleanValue()) {
                        currentFile = entry.myFile;
                    }
                    if (!isCurrent) continue;
                    this.setCurrentWindow(window, false);
                }
                if (currentFile != null && (editor = window.findFileComposite(currentFile)) != null) {
                    window.setSelectedEditor(editor, true);
                }
            }
            catch (InvalidDataException e) {
                // empty catch block
            }
            return window.myPanel;
        }
        return null;
    }

    @NotNull
    public VirtualFile[] getOpenFiles() {
        ArrayListSet files = new ArrayListSet();
        for (EditorWindow myWindow : this.myWindows) {
            EditorWithProviderComposite[] editors;
            for (EditorWithProviderComposite editor : editors = myWindow.getEditors()) {
                files.add((Object)editor.getFile());
            }
        }
        VirtualFile[] virtualFileArray = VfsUtil.toVirtualFileArray((Collection)files);
        if (virtualFileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/EditorsSplitters.getOpenFiles must not return null");
        }
        return virtualFileArray;
    }

    @NotNull
    public VirtualFile[] getSelectedFiles() {
        ArrayListSet files = new ArrayListSet();
        for (EditorWindow window : this.myWindows) {
            VirtualFile file = window.getSelectedFile();
            if (file == null) continue;
            files.add((Object)file);
        }
        VirtualFile[] virtualFiles = VfsUtil.toVirtualFileArray((Collection)files);
        VirtualFile currentFile = this.getCurrentFile();
        if (currentFile != null) {
            for (int i = 0; i != virtualFiles.length; ++i) {
                if (virtualFiles[i] != currentFile) continue;
                virtualFiles[i] = virtualFiles[0];
                virtualFiles[0] = currentFile;
                break;
            }
        }
        if (virtualFiles == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/EditorsSplitters.getSelectedFiles must not return null");
        }
        return virtualFiles;
    }

    @NotNull
    public FileEditor[] getSelectedEditors() {
        EditorWithProviderComposite composite;
        ArrayList<FileEditor> editors = new ArrayList<FileEditor>();
        EditorWindow currentWindow = this.getCurrentWindow();
        if (currentWindow != null && (composite = currentWindow.getSelectedEditor()) != null) {
            editors.add(composite.getSelectedEditor());
        }
        for (EditorWindow window : this.myWindows) {
            EditorWithProviderComposite composite2;
            if (window.equals(currentWindow) || (composite2 = window.getSelectedEditor()) == null) continue;
            editors.add(composite2.getSelectedEditor());
        }
        FileEditor[] fileEditorArray = editors.toArray(new FileEditor[editors.size()]);
        if (fileEditorArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/EditorsSplitters.getSelectedEditors must not return null");
        }
        return fileEditorArray;
    }

    void updateFileIcon(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/EditorsSplitters.updateFileIcon must not be null");
        }
        this.updateFileIconLater(file);
    }

    private void updateFileIconImmediately(VirtualFile file) {
        List<EditorWindow> windows = this.findWindows(file);
        for (EditorWindow window : windows) {
            window.updateFileIcon(file);
        }
    }

    private void updateFileIconLater(VirtualFile file) {
        this.myFilesToUpdateIconsFor.add(file);
        this.myIconUpdaterAlarm.cancelAllRequests();
        this.myIconUpdaterAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                if (EditorsSplitters.this.myManager.getProject().isDisposed()) {
                    return;
                }
                for (VirtualFile file : EditorsSplitters.this.myFilesToUpdateIconsFor) {
                    EditorsSplitters.this.updateFileIconImmediately(file);
                }
                EditorsSplitters.this.myFilesToUpdateIconsFor.clear();
            }
        }, 200, ModalityState.stateForComponent((Component)this));
    }

    public void updateFileColor(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/EditorsSplitters.updateFileColor must not be null");
        }
        List<EditorWindow> windows = this.findWindows(file);
        for (EditorWindow window : windows) {
            int index = window.findEditorIndex(window.findFileComposite(file));
            LOG.assertTrue(index != -1);
            window.setForegroundAt(index, this.getManager().getFileColor(file));
            window.setWaveColor(index, this.getManager().isProblem(file) ? Color.red : null);
        }
    }

    public void trimToSize(int editor_tab_limit) {
        for (EditorWindow window : this.myWindows) {
            window.trimToSize(editor_tab_limit, null, true);
        }
    }

    public void setTabsPlacement(int tabPlacement) {
        EditorWindow[] windows = this.getWindows();
        for (int i = 0; i != windows.length; ++i) {
            windows[i].setTabsPlacement(tabPlacement);
        }
    }

    public void setTabLayoutPolicy(int scrollTabLayout) {
        EditorWindow[] windows = this.getWindows();
        for (int i = 0; i != windows.length; ++i) {
            windows[i].setTabLayoutPolicy(scrollTabLayout);
        }
    }

    public void updateFileName(VirtualFile file) {
        EditorWindow[] windows = this.getWindows();
        for (int i = 0; i != windows.length; ++i) {
            windows[i].updateFileName(file);
        }
    }

    public boolean isInsideChange() {
        return this.myInsideChange > 0;
    }

    private void setCurrentWindow(EditorWindow currentWindow) {
        this.myCurrentWindow = currentWindow;
    }

    public void updateFileBackgroundColor(VirtualFile file) {
        EditorWindow[] windows = this.getWindows();
        for (int i = 0; i != windows.length; ++i) {
            windows[i].updateFileBackgroundColor(file);
        }
    }

    @Nullable
    public JPanel getTopPanel() {
        return this.getComponentCount() > 0 ? (JPanel)this.getComponent(0) : null;
    }

    public EditorWindow getCurrentWindow() {
        return this.myCurrentWindow;
    }

    public EditorWindow getOrCreateCurrentWindow(VirtualFile file) {
        List<EditorWindow> windows = this.findWindows(file);
        if (this.getCurrentWindow() == null) {
            Iterator<EditorWindow> iterator = this.myWindows.iterator();
            if (!windows.isEmpty()) {
                this.setCurrentWindow(windows.get(0), false);
            } else if (iterator.hasNext()) {
                this.setCurrentWindow(iterator.next(), false);
            } else {
                this.createCurrentWindow();
            }
        } else if (!windows.isEmpty() && !windows.contains(this.getCurrentWindow())) {
            this.setCurrentWindow(windows.get(0), false);
        }
        return this.getCurrentWindow();
    }

    private void createCurrentWindow() {
        LOG.assertTrue(this.myCurrentWindow == null);
        this.setCurrentWindow(new EditorWindow(this));
        this.add((Component)this.myCurrentWindow.myPanel, "Center");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentWindow(EditorWindow window, boolean requestFocus) {
        EditorWithProviderComposite selectedEditor;
        EditorWithProviderComposite oldEditor = this.myCurrentSelectedEditor;
        EditorWithProviderComposite newEditor = window != null ? window.getSelectedEditor() : null;
        try {
            this.getManager().fireSelectionChanged(oldEditor, newEditor);
        }
        finally {
            this.setCurrentWindow(window);
            this.myCurrentSelectedEditor = newEditor;
        }
        this.getManager().updateFileName(window == null ? null : window.getSelectedFile());
        if (window != null && (selectedEditor = this.myCurrentWindow.getSelectedEditor()) != null) {
            boolean alreadyFocused = false;
            JComponent comp = selectedEditor.getComponent();
            Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (owner != null && comp != null) {
                boolean bl = alreadyFocused = owner == comp || SwingUtilities.isDescendingFrom(owner, comp);
            }
            if (requestFocus && !alreadyFocused) {
                IdeFocusManager.getInstance((Project)this.myManager.getProject()).requestFocus((Component)comp, requestFocus);
            }
        }
    }

    public EditorWithProviderComposite[] getEditorsComposites() {
        ArrayList<EditorWithProviderComposite> res = new ArrayList<EditorWithProviderComposite>();
        for (EditorWindow myWindow : this.myWindows) {
            EditorWithProviderComposite[] editors = myWindow.getEditors();
            res.addAll(Arrays.asList(editors));
        }
        return res.toArray(new EditorWithProviderComposite[res.size()]);
    }

    @NotNull
    public List<EditorWithProviderComposite> findEditorComposites(VirtualFile file) {
        ArrayList<EditorWithProviderComposite> res = new ArrayList<EditorWithProviderComposite>();
        for (EditorWindow window : this.myWindows) {
            EditorWithProviderComposite fileComposite = window.findFileComposite(file);
            if (fileComposite == null) continue;
            res.add(fileComposite);
        }
        ArrayList<EditorWithProviderComposite> arrayList = res;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/EditorsSplitters.findEditorComposites must not return null");
        }
        return arrayList;
    }

    @NotNull
    public List<EditorWindow> findWindows(VirtualFile file) {
        ArrayList<EditorWindow> res = new ArrayList<EditorWindow>();
        for (EditorWindow window : this.myWindows) {
            if (window.findFileComposite(file) == null) continue;
            res.add(window);
        }
        ArrayList<EditorWindow> arrayList = res;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/EditorsSplitters.findWindows must not return null");
        }
        return arrayList;
    }

    @NotNull
    public EditorWindow[] getWindows() {
        EditorWindow[] editorWindowArray = this.myWindows.toArray(new EditorWindow[this.myWindows.size()]);
        if (editorWindowArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/EditorsSplitters.getWindows must not return null");
        }
        return editorWindowArray;
    }

    @NotNull
    public EditorWindow[] getOrderedWindows() {
        final ArrayList res = new ArrayList();
        if (this.getComponentCount() != 0) {
            Component comp = this.getComponent(0);
            LOG.assertTrue(comp instanceof JPanel);
            JPanel panel = (JPanel)comp;
            if (panel.getComponentCount() != 0) {
                class Inner {
                    Inner() {
                    }

                    final void collect(JPanel panel) {
                        EditorWindow window;
                        Component comp = panel.getComponent(0);
                        if (comp instanceof Splitter) {
                            Splitter splitter = (Splitter)comp;
                            this.collect((JPanel)splitter.getFirstComponent());
                            this.collect((JPanel)splitter.getSecondComponent());
                        } else if ((comp instanceof JPanel || comp instanceof JBTabs) && (window = EditorsSplitters.this.findWindowWith(comp)) != null) {
                            res.add(window);
                        }
                    }
                }
                new Inner().collect(panel);
            }
        }
        LOG.assertTrue(res.size() == this.myWindows.size());
        EditorWindow[] editorWindowArray = res.toArray(new EditorWindow[res.size()]);
        if (editorWindowArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/EditorsSplitters.getOrderedWindows must not return null");
        }
        return editorWindowArray;
    }

    private EditorWindow findWindowWith(Component component) {
        if (component != null) {
            for (EditorWindow window : this.myWindows) {
                if (!SwingUtilities.isDescendingFrom(component, window.myPanel)) continue;
                return window;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runChange(Runnable change) {
        ++this.myInsideChange;
        try {
            change.run();
        }
        finally {
            --this.myInsideChange;
        }
    }

    private final class MyTransferHandler
    extends TransferHandler {
        private final FileDropHandler myFileDropHandler = new FileDropHandler();

        private MyTransferHandler() {
        }

        @Override
        public boolean importData(JComponent comp, Transferable t) {
            if (this.myFileDropHandler.canHandleDrop(t.getTransferDataFlavors())) {
                this.myFileDropHandler.handleDrop(t, EditorsSplitters.this.myManager.getProject());
                return true;
            }
            return false;
        }

        @Override
        public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
            return this.myFileDropHandler.canHandleDrop(transferFlavors);
        }
    }

    private final class MyFocusWatcher
    extends FocusWatcher {
        private MyFocusWatcher() {
        }

        protected void focusedComponentChanged(Component component, AWTEvent cause) {
            EditorWindow newWindow = null;
            VirtualFile newFile = null;
            if (component != null && (newWindow = EditorsSplitters.this.findWindowWith(component)) != null) {
                newFile = newWindow.getSelectedFile();
            }
            boolean changed = !Comparing.equal((Object)newWindow, (Object)EditorsSplitters.this.myCurrentWindow) || !Comparing.equal((Object)newFile, (Object)EditorsSplitters.this.myCurrentFile);
            EditorsSplitters.this.myCurrentFile = newFile;
            EditorsSplitters.this.setCurrentWindow(newWindow);
            if (changed) {
                EditorsSplitters.this.setCurrentWindow(newWindow, false);
            }
        }
    }

    private final class MyFocusTraversalPolicy
    extends IdeFocusTraversalPolicy {
        private MyFocusTraversalPolicy() {
        }

        @Override
        public final Component getDefaultComponentImpl(Container focusCycleRoot) {
            EditorWithProviderComposite selectedEditor;
            if (EditorsSplitters.this.myCurrentWindow != null && (selectedEditor = EditorsSplitters.this.myCurrentWindow.getSelectedEditor()) != null) {
                return IdeFocusTraversalPolicy.getPreferredFocusedComponent(selectedEditor.getComponent(), this);
            }
            return IdeFocusTraversalPolicy.getPreferredFocusedComponent(EditorsSplitters.this, this);
        }
    }
}

