/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.IssueNavigationConfiguration;
import com.intellij.openapi.vcs.IssueNavigationLink;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.configurable.IssueLinkConfigurationDialog;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.Nls;

public class IssueNavigationConfigurationPanel
extends JPanel
implements SearchableConfigurable {
    private JPanel myPanel;
    private JTable myLinkTable;
    private JButton myAddButton;
    private JButton myEditButton;
    private JButton myDeleteButton;
    private JButton myAddJiraPatternButton;
    private JButton myAddYouTrackPatternButton;
    private JLabel myDescriptionLabel;
    private final Project myProject;
    private List<IssueNavigationLink> myLinks;
    private ListTableModel<IssueNavigationLink> myModel;
    private final ColumnInfo<IssueNavigationLink, String> ISSUE_COLUMN;
    private final ColumnInfo<IssueNavigationLink, String> LINK_COLUMN;

    public IssueNavigationConfigurationPanel(Project project) {
        super(new BorderLayout());
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.ISSUE_COLUMN = new ColumnInfo<IssueNavigationLink, String>(VcsBundle.message((String)"issue.link.issue.column", (Object[])objectArray)){

            public String valueOf(IssueNavigationLink issueNavigationLink) {
                return issueNavigationLink.getIssueRegexp();
            }
        };
        this.LINK_COLUMN = new ColumnInfo<IssueNavigationLink, String>(VcsBundle.message((String)"issue.link.link.column", (Object[])new Object[0])){

            public String valueOf(IssueNavigationLink issueNavigationLink) {
                return issueNavigationLink.getLinkRegexp();
            }
        };
        this.myProject = project;
        this.add((Component)this.myPanel, "Center");
        this.myDescriptionLabel.setText(ApplicationNamesInfo.getInstance().getFullProductName() + " will search for the specified patterns in " + "checkin comments and link them to issues in your issue tracker:");
        this.reset();
        this.myAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IssueLinkConfigurationDialog dlg = new IssueLinkConfigurationDialog(IssueNavigationConfigurationPanel.this.myProject);
                dlg.setTitle(VcsBundle.message((String)"issue.link.add.title", (Object[])new Object[0]));
                dlg.show();
                if (dlg.isOK()) {
                    IssueNavigationConfigurationPanel.this.myLinks.add(dlg.getLink());
                    IssueNavigationConfigurationPanel.this.myModel.fireTableDataChanged();
                }
            }
        });
        this.myAddJiraPatternButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = Messages.showInputDialog((Component)IssueNavigationConfigurationPanel.this, (String)"Enter JIRA installation URL:", (String)"Add JIRA Issue Navigation Pattern", (Icon)Messages.getQuestionIcon());
                if (s == null) {
                    return;
                }
                if (!s.endsWith("/")) {
                    s = s + "/";
                }
                IssueNavigationConfigurationPanel.this.myLinks.add(new IssueNavigationLink("[A-Z]+\\-\\d+", s + "browse/$0"));
                IssueNavigationConfigurationPanel.this.myModel.fireTableDataChanged();
            }
        });
        this.myAddYouTrackPatternButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = Messages.showInputDialog((Component)IssueNavigationConfigurationPanel.this, (String)"Enter YouTrack installation URL:", (String)"Add YouTrack Issue Navigation Pattern", (Icon)Messages.getQuestionIcon());
                if (s == null) {
                    return;
                }
                if (!s.endsWith("/")) {
                    s = s + "/";
                }
                IssueNavigationConfigurationPanel.this.myLinks.add(new IssueNavigationLink("[A-Z]+\\-\\d+", s + "issue/$0"));
                IssueNavigationConfigurationPanel.this.myModel.fireTableDataChanged();
            }
        });
        this.myEditButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IssueNavigationLink link = (IssueNavigationLink)IssueNavigationConfigurationPanel.this.myModel.getItem(IssueNavigationConfigurationPanel.this.myLinkTable.getSelectedRow());
                IssueLinkConfigurationDialog dlg = new IssueLinkConfigurationDialog(IssueNavigationConfigurationPanel.this.myProject);
                dlg.setTitle(VcsBundle.message((String)"issue.link.edit.title", (Object[])new Object[0]));
                dlg.setLink(link);
                dlg.show();
                if (dlg.isOK()) {
                    IssueNavigationLink editedLink = dlg.getLink();
                    link.setIssueRegexp(editedLink.getIssueRegexp());
                    link.setLinkRegexp(editedLink.getLinkRegexp());
                    IssueNavigationConfigurationPanel.this.myModel.fireTableDataChanged();
                }
            }
        });
        this.myDeleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Messages.showOkCancelDialog((Project)IssueNavigationConfigurationPanel.this.myProject, (String)VcsBundle.message((String)"issue.link.delete.prompt", (Object[])new Object[0]), (String)VcsBundle.message((String)"issue.link.delete.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0) {
                    int selRow = IssueNavigationConfigurationPanel.this.myLinkTable.getSelectedRow();
                    IssueNavigationConfigurationPanel.this.myLinks.remove(selRow);
                    IssueNavigationConfigurationPanel.this.myModel.fireTableDataChanged();
                    if (IssueNavigationConfigurationPanel.this.myLinkTable.getRowCount() > 0) {
                        if (selRow >= IssueNavigationConfigurationPanel.this.myLinkTable.getRowCount()) {
                            --selRow;
                        }
                        IssueNavigationConfigurationPanel.this.myLinkTable.getSelectionModel().setSelectionInterval(selRow, selRow);
                    }
                }
            }
        });
        this.myLinkTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                IssueNavigationConfigurationPanel.this.updateButtons();
            }
        });
        this.updateButtons();
    }

    private void updateButtons() {
        this.myEditButton.setEnabled(this.myLinkTable.getSelectedRow() >= 0);
        this.myDeleteButton.setEnabled(this.myEditButton.isEnabled());
    }

    public void apply() {
        IssueNavigationConfiguration configuration = IssueNavigationConfiguration.getInstance((Project)this.myProject);
        configuration.setLinks(this.myLinks);
    }

    public boolean isModified() {
        IssueNavigationConfiguration configuration = IssueNavigationConfiguration.getInstance((Project)this.myProject);
        return !((Object)this.myLinks).equals(configuration.getLinks());
    }

    public void reset() {
        IssueNavigationConfiguration configuration = IssueNavigationConfiguration.getInstance((Project)this.myProject);
        this.myLinks = new ArrayList<IssueNavigationLink>();
        for (IssueNavigationLink link : configuration.getLinks()) {
            this.myLinks.add(new IssueNavigationLink(link.getIssueRegexp(), link.getLinkRegexp()));
        }
        this.myModel = new ListTableModel(new ColumnInfo[]{this.ISSUE_COLUMN, this.LINK_COLUMN}, this.myLinks, 0);
        this.myLinkTable.setModel((TableModel)this.myModel);
    }

    @Nls
    public String getDisplayName() {
        return "Issue Navigation";
    }

    public Icon getIcon() {
        return null;
    }

    public String getHelpTopic() {
        return "project.propVCSSupport.Issue.Navigation";
    }

    public String getId() {
        return this.getHelpTopic();
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    public JComponent createComponent() {
        return this;
    }

    public void disposeUIResources() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JLabel jLabel;
        JButton jButton2;
        JButton jButton3;
        JButton jButton4;
        JButton jButton5;
        JTable jTable;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, new GridConstraints(1, 0, 6, 1, 0, 3, 7, 7, null, null, null));
        this.myLinkTable = jTable = new JTable();
        jScrollPane.setViewportView(jTable);
        this.myAddButton = jButton5 = new JButton();
        jButton5.setText("Add...");
        jPanel.add((Component)jButton5, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myEditButton = jButton4 = new JButton();
        jButton4.setText("Edit...");
        jPanel.add((Component)jButton4, new GridConstraints(4, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myDeleteButton = jButton3 = new JButton();
        jButton3.setText("Delete");
        jPanel.add((Component)jButton3, new GridConstraints(5, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myAddJiraPatternButton = jButton2 = new JButton();
        jButton2.setText("Add JIRA Pattern...");
        jPanel.add((Component)jButton2, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 2, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myDescriptionLabel = jLabel = new JLabel();
        jLabel.setText("<description>");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAddYouTrackPatternButton = jButton = new JButton();
        jButton.setText("Add YouTrack Pattern...");
        jPanel.add((Component)jButton, new GridConstraints(3, 1, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

