/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.run;

import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.ConfigurationSettingsEditorWrapper;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.Compiler;
import com.intellij.openapi.compiler.CompilerFilter;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactAdapter;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.impl.compiler.ArtifactAwareCompiler;
import com.intellij.packaging.impl.compiler.ArtifactCompileScope;
import com.intellij.packaging.impl.compiler.IncrementalArtifactsCompiler;
import com.intellij.packaging.impl.run.ArtifactChooser;
import com.intellij.packaging.impl.run.BuildArtifactsBeforeRunTask;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class BuildArtifactsBeforeRunTaskProvider
extends BeforeRunTaskProvider<BuildArtifactsBeforeRunTask> {
    @NonNls
    public static final String BUILD_ARTIFACTS_ID = "BuildArtifacts";
    public static final Key<BuildArtifactsBeforeRunTask> ID = Key.create((String)"BuildArtifacts");
    private Project myProject;

    public BuildArtifactsBeforeRunTaskProvider(Project project) {
        this.myProject = project;
        project.getMessageBus().connect().subscribe(ArtifactManager.TOPIC, (Object)new ArtifactAdapter(){

            public void artifactRemoved(@NotNull Artifact artifact) {
                if (artifact == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/run/BuildArtifactsBeforeRunTaskProvider$1.artifactRemoved must not be null");
                }
                RunManagerEx runManager = RunManagerEx.getInstanceEx(BuildArtifactsBeforeRunTaskProvider.this.myProject);
                for (RunConfiguration configuration : runManager.getAllConfigurations()) {
                    ArtifactPointer[] pointers;
                    BuildArtifactsBeforeRunTask task = runManager.getBeforeRunTask(configuration, ID);
                    if (task == null) continue;
                    String artifactName = artifact.getName();
                    List<ArtifactPointer> pointersList = task.getArtifactPointers();
                    for (ArtifactPointer pointer : pointers = pointersList.toArray(new ArtifactPointer[pointersList.size()])) {
                        if (!pointer.getArtifactName().equals(artifactName) || ArtifactManager.getInstance((Project)BuildArtifactsBeforeRunTaskProvider.this.myProject).findArtifact(artifactName) != null) continue;
                        task.removeArtifact(pointer);
                    }
                }
            }
        });
    }

    public Key<BuildArtifactsBeforeRunTask> getId() {
        return ID;
    }

    public String getDescription(RunConfiguration runConfiguration, BuildArtifactsBeforeRunTask task) {
        List<ArtifactPointer> pointers = task.getArtifactPointers();
        if (!task.isEnabled() || pointers.isEmpty()) {
            return "Build Artifacts";
        }
        if (pointers.size() == 1) {
            return "Build '" + pointers.get(0).getArtifactName() + "' artifact";
        }
        return "Build " + pointers.size() + " artifacts";
    }

    public boolean hasConfigurationButton() {
        return true;
    }

    public BuildArtifactsBeforeRunTask createTask(RunConfiguration runConfiguration) {
        return new BuildArtifactsBeforeRunTask(this.myProject);
    }

    public boolean configureTask(RunConfiguration runConfiguration, BuildArtifactsBeforeRunTask task) {
        Artifact[] artifacts = ArtifactManager.getInstance((Project)this.myProject).getArtifacts();
        THashSet pointers = new THashSet();
        for (Artifact artifact : artifacts) {
            pointers.add(ArtifactPointerManager.getInstance((Project)this.myProject).createPointer(artifact));
        }
        pointers.addAll(task.getArtifactPointers());
        ArtifactChooser chooser = new ArtifactChooser(new ArrayList<ArtifactPointer>((Collection<ArtifactPointer>)pointers));
        chooser.markElements(task.getArtifactPointers());
        chooser.setPreferredSize(new Dimension(400, 300));
        DialogBuilder builder = new DialogBuilder(this.myProject);
        builder.setTitle("Select Artifacts");
        builder.setDimensionServiceKey("#BuildArtifactsBeforeRunChooser");
        builder.addOkAction();
        builder.addCancelAction();
        builder.setCenterPanel((JComponent)chooser);
        builder.setPreferedFocusComponent((JComponent)chooser);
        if (builder.show() == 0) {
            task.setArtifactPointers(chooser.getMarkedElements());
            return true;
        }
        return false;
    }

    public boolean executeTask(DataContext context, RunConfiguration configuration, final BuildArtifactsBeforeRunTask task) {
        final Ref result = Ref.create((Object)false);
        final Semaphore finished = new Semaphore();
        final ArrayList artifacts = new ArrayList();
        new ReadAction(){

            protected void run(Result result) {
                for (ArtifactPointer pointer : task.getArtifactPointers()) {
                    ContainerUtil.addIfNotNull((Object)pointer.getArtifact(), (Collection)artifacts);
                }
            }
        }.execute();
        final CompileStatusNotification callback = new CompileStatusNotification(){

            public void finished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
                result.set((Object)(!aborted && errors == 0 ? 1 : 0));
                finished.up();
            }
        };
        final CompilerFilter compilerFilter = new CompilerFilter(){

            public boolean acceptCompiler(Compiler compiler) {
                return compiler instanceof IncrementalArtifactsCompiler || compiler instanceof ArtifactAwareCompiler && ((ArtifactAwareCompiler)compiler).shouldRun(artifacts);
            }
        };
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                CompilerManager manager = CompilerManager.getInstance((Project)BuildArtifactsBeforeRunTaskProvider.this.myProject);
                finished.down();
                manager.make(ArtifactCompileScope.createArtifactsScope(BuildArtifactsBeforeRunTaskProvider.this.myProject, artifacts), compilerFilter, callback);
            }
        }, ModalityState.NON_MODAL);
        finished.waitFor();
        return (Boolean)result.get();
    }

    public static void setBuildArtifactBeforeRunOption(@NotNull JComponent runConfigurationEditorComponent, @NotNull Artifact artifact, boolean enable) {
        if (runConfigurationEditorComponent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/run/BuildArtifactsBeforeRunTaskProvider.setBuildArtifactBeforeRunOption must not be null");
        }
        if (artifact == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/run/BuildArtifactsBeforeRunTaskProvider.setBuildArtifactBeforeRunOption must not be null");
        }
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)runConfigurationEditorComponent);
        ConfigurationSettingsEditorWrapper editor = (ConfigurationSettingsEditorWrapper)((Object)ConfigurationSettingsEditorWrapper.CONFIGURATION_EDITOR_KEY.getData(dataContext));
        if (editor != null) {
            BuildArtifactsBeforeRunTask task = (BuildArtifactsBeforeRunTask)editor.getStepsBeforeLaunch().get(ID);
            if (enable) {
                task.addArtifact(artifact);
                task.setEnabled(true);
            } else {
                task.removeArtifact(artifact);
                if (task.getArtifactPointers().isEmpty()) {
                    task.setEnabled(false);
                }
            }
            editor.updateBeforeRunTaskPanel(ID);
        }
    }

    public static void setBuildArtifactBeforeRun(@NotNull Project project, @NotNull RunConfiguration configuration, @NotNull Artifact artifact) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/run/BuildArtifactsBeforeRunTaskProvider.setBuildArtifactBeforeRun must not be null");
        }
        if (configuration == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/run/BuildArtifactsBeforeRunTaskProvider.setBuildArtifactBeforeRun must not be null");
        }
        if (artifact == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/packaging/impl/run/BuildArtifactsBeforeRunTaskProvider.setBuildArtifactBeforeRun must not be null");
        }
        RunManagerEx runManager = RunManagerEx.getInstanceEx(project);
        BuildArtifactsBeforeRunTask buildArtifactsTask = runManager.getBeforeRunTask(configuration, ID);
        if (buildArtifactsTask != null) {
            buildArtifactsTask.setEnabled(true);
            buildArtifactsTask.addArtifact(artifact);
        }
    }
}

