/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FilenameIndex
extends ScalarIndexExtension<String> {
    @NonNls
    public static final ID<String, Void> NAME = ID.create((String)"FilenameIndex");
    private final MyDataIndexer myDataIndexer = new MyDataIndexer();
    private final MyInputFilter myInputFilter = new MyInputFilter();
    private final EnumeratorStringDescriptor myKeyDescriptor = new EnumeratorStringDescriptor();

    @Override
    public ID<String, Void> getName() {
        return NAME;
    }

    @Override
    public DataIndexer<String, Void, FileContent> getIndexer() {
        return this.myDataIndexer;
    }

    @Override
    public KeyDescriptor<String> getKeyDescriptor() {
        return this.myKeyDescriptor;
    }

    @Override
    public FileBasedIndex.InputFilter getInputFilter() {
        return this.myInputFilter;
    }

    @Override
    public boolean dependsOnFileContent() {
        return false;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    public static String[] getAllFilenames(Project project) {
        Collection<String> allKeys = FileBasedIndex.getInstance().getAllKeys(NAME, project);
        return ArrayUtil.toStringArray(allKeys);
    }

    public static Collection<VirtualFile> getVirtualFilesByName(Project project, String name, GlobalSearchScope scope) {
        return FileBasedIndex.getInstance().getContainingFiles(NAME, name, scope);
    }

    public static PsiFile[] getFilesByName(Project project, String name, GlobalSearchScope scope) {
        Collection<VirtualFile> files = FileBasedIndex.getInstance().getContainingFiles(NAME, name, scope);
        if (files.isEmpty()) {
            return PsiFile.EMPTY_ARRAY;
        }
        ArrayList<PsiFile> result = new ArrayList<PsiFile>();
        for (VirtualFile file : files) {
            PsiFile psiFile;
            if (!file.isValid() || (psiFile = PsiManager.getInstance((Project)project).findFile(file)) == null) continue;
            result.add(psiFile);
        }
        return result.toArray(new PsiFile[result.size()]);
    }

    private static class MyInputFilter
    implements FileBasedIndex.InputFilter {
        private MyInputFilter() {
        }

        @Override
        public boolean acceptInput(VirtualFile file) {
            if (((ApplicationEx)ApplicationManager.getApplication()).isInternal()) {
                return true;
            }
            return !ProjectUtil.isProjectOrWorkspaceFile(file);
        }
    }

    private static class MyDataIndexer
    implements DataIndexer<String, Void, FileContent> {
        private MyDataIndexer() {
        }

        @Override
        @NotNull
        public Map<String, Void> map(FileContent inputData) {
            Map<String, Object> map = Collections.singletonMap(inputData.getFileName(), null);
            if (map == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/search/FilenameIndex$MyDataIndexer.map must not return null");
            }
            return map;
        }
    }
}

