/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceParameter;

import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduceParameter.IntroduceParameterProcessor;
import com.intellij.refactoring.introduceParameter.Util;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.refactoring.ui.NameSuggestionsGenerator;
import com.intellij.refactoring.ui.NameSuggestionsManager;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.ui.TypeSelector;
import com.intellij.refactoring.ui.TypeSelectorManager;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.StateRestoringCheckBox;
import com.intellij.usageView.UsageInfo;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntProcedure;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;

public class IntroduceParameterDialog
extends RefactoringDialog {
    private TypeSelector myTypeSelector;
    private NameSuggestionsManager myNameSuggestionsManager;
    private final Project myProject;
    private final List<UsageInfo> myClassMembersList;
    private final int myOccurenceNumber;
    private final boolean myIsInvokedOnDeclaration;
    private final PsiMethod myMethodToSearchFor;
    private final PsiMethod myMethodToReplaceIn;
    private final boolean myMustBeFinal;
    private final PsiParameter[] myParametersToRemove;
    private final boolean[] myParametersToRemoveChecked;
    private final PsiExpression myExpression;
    private final PsiLocalVariable myLocalVar;
    private final boolean myIsLocalVariable;
    private final boolean myHasInitializer;
    private NameSuggestionsField myParameterNameField;
    private JCheckBox myCbReplaceAllOccurences;
    private JCheckBox myCbDeclareFinal;
    private JCheckBox myCbGenerateDelegate;
    private StateRestoringCheckBox myCbDeleteLocalVariable;
    private StateRestoringCheckBox myCbUseInitializer;
    private JRadioButton myReplaceFieldsWithGettersNoneRadio;
    private JRadioButton myReplaceFieldsWithGettersInaccessibleRadio;
    private JRadioButton myReplaceFieldsWithGettersAllRadio;
    private final ButtonGroup myReplaceFieldsWithGettersButtonGroup;
    private final NameSuggestionsGenerator myNameSuggestionsGenerator;
    private final TypeSelectorManager myTypeSelectorManager;
    private static final String REFACTORING_NAME = RefactoringBundle.message((String)"introduce.parameter.title");
    private NameSuggestionsField.DataChanged myParameterNameChangedListener;

    IntroduceParameterDialog(@NotNull Project project, @NotNull List<UsageInfo> classMembersList, int occurenceNumber, PsiLocalVariable onLocalVariable, PsiExpression onExpression, @NotNull NameSuggestionsGenerator generator, @NotNull TypeSelectorManager typeSelectorManager, @NotNull PsiMethod methodToSearchFor, @NotNull PsiMethod methodToReplaceIn, @NotNull TIntArrayList parametersToRemove, boolean mustBeFinal) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/introduceParameter/IntroduceParameterDialog.<init> must not be null");
        }
        if (classMembersList == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/introduceParameter/IntroduceParameterDialog.<init> must not be null");
        }
        if (generator == null) {
            throw new IllegalArgumentException("Argument 5 for @NotNull parameter of com/intellij/refactoring/introduceParameter/IntroduceParameterDialog.<init> must not be null");
        }
        if (typeSelectorManager == null) {
            throw new IllegalArgumentException("Argument 6 for @NotNull parameter of com/intellij/refactoring/introduceParameter/IntroduceParameterDialog.<init> must not be null");
        }
        if (methodToSearchFor == null) {
            throw new IllegalArgumentException("Argument 7 for @NotNull parameter of com/intellij/refactoring/introduceParameter/IntroduceParameterDialog.<init> must not be null");
        }
        if (methodToReplaceIn == null) {
            throw new IllegalArgumentException("Argument 8 for @NotNull parameter of com/intellij/refactoring/introduceParameter/IntroduceParameterDialog.<init> must not be null");
        }
        if (parametersToRemove == null) {
            throw new IllegalArgumentException("Argument 9 for @NotNull parameter of com/intellij/refactoring/introduceParameter/IntroduceParameterDialog.<init> must not be null");
        }
        super(project, true);
        this.myCbReplaceAllOccurences = null;
        this.myCbDeclareFinal = null;
        this.myCbGenerateDelegate = null;
        this.myCbDeleteLocalVariable = null;
        this.myCbUseInitializer = null;
        this.myReplaceFieldsWithGettersNoneRadio = null;
        this.myReplaceFieldsWithGettersInaccessibleRadio = null;
        this.myReplaceFieldsWithGettersAllRadio = null;
        this.myReplaceFieldsWithGettersButtonGroup = new ButtonGroup();
        this.myProject = project;
        this.myClassMembersList = classMembersList;
        this.myOccurenceNumber = occurenceNumber;
        this.myExpression = onExpression;
        this.myLocalVar = onLocalVariable;
        this.myMethodToReplaceIn = methodToReplaceIn;
        this.myMustBeFinal = mustBeFinal;
        this.myIsInvokedOnDeclaration = onExpression == null;
        this.myMethodToSearchFor = methodToSearchFor;
        this.myIsLocalVariable = onLocalVariable != null;
        this.myHasInitializer = onLocalVariable != null && onLocalVariable.getInitializer() != null;
        this.myNameSuggestionsGenerator = generator;
        this.myTypeSelectorManager = typeSelectorManager;
        final PsiParameter[] parameters = methodToReplaceIn.getParameterList().getParameters();
        this.myParametersToRemove = new PsiParameter[parameters.length];
        this.myParametersToRemoveChecked = new boolean[parameters.length];
        parametersToRemove.forEach(new TIntProcedure(){

            public boolean execute(int paramNum) {
                ((IntroduceParameterDialog)IntroduceParameterDialog.this).myParametersToRemove[paramNum] = parameters[paramNum];
                return true;
            }
        });
        this.setTitle(REFACTORING_NAME);
        this.init();
    }

    protected void dispose() {
        this.myParameterNameField.removeDataChangedListener(this.myParameterNameChangedListener);
        super.dispose();
    }

    private boolean isDeclareFinal() {
        return this.myCbDeclareFinal != null && this.myCbDeclareFinal.isSelected();
    }

    private boolean isReplaceAllOccurences() {
        return this.myIsInvokedOnDeclaration || this.myCbReplaceAllOccurences != null && this.myCbReplaceAllOccurences.isSelected();
    }

    private boolean isDeleteLocalVariable() {
        return this.myIsInvokedOnDeclaration || this.myCbDeleteLocalVariable != null && this.myCbDeleteLocalVariable.isSelected();
    }

    private boolean isUseInitializer() {
        if (this.myIsInvokedOnDeclaration) {
            return this.myHasInitializer;
        }
        return this.myCbUseInitializer != null && this.myCbUseInitializer.isSelected();
    }

    private boolean isGenerateDelegate() {
        return this.myCbGenerateDelegate != null && this.myCbGenerateDelegate.isSelected();
    }

    private String getParameterName() {
        return this.myParameterNameField.getEnteredName();
    }

    private int getReplaceFieldsWithGetters() {
        if (this.myReplaceFieldsWithGettersAllRadio != null && this.myReplaceFieldsWithGettersAllRadio.isSelected()) {
            return 2;
        }
        if (this.myReplaceFieldsWithGettersInaccessibleRadio != null && this.myReplaceFieldsWithGettersInaccessibleRadio.isSelected()) {
            return 1;
        }
        if (this.myReplaceFieldsWithGettersNoneRadio != null && this.myReplaceFieldsWithGettersNoneRadio.isSelected()) {
            return 0;
        }
        return 1;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myParameterNameField.getFocusableComponent();
    }

    private PsiType getSelectedType() {
        return this.myTypeSelector.getSelectedType();
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("refactoring.introduceParameter");
    }

    protected JComponent createNorthPanel() {
        GridBagConstraints gbConstraints = new GridBagConstraints();
        JPanel panel = new JPanel(new GridBagLayout());
        gbConstraints.anchor = 17;
        gbConstraints.fill = 0;
        gbConstraints.gridx = 0;
        gbConstraints.insets = new Insets(4, 4, 4, 0);
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.weighty = 0.0;
        gbConstraints.gridy = 0;
        JLabel type = new JLabel(RefactoringBundle.message((String)"parameter.of.type"));
        panel.add((Component)type, gbConstraints);
        gbConstraints.insets = new Insets(4, 4, 4, 8);
        ++gbConstraints.gridx;
        gbConstraints.weightx = 1.0;
        gbConstraints.fill = 1;
        this.myTypeSelector = this.myTypeSelectorManager.getTypeSelector();
        panel.add((Component)this.myTypeSelector.getComponent(), gbConstraints);
        gbConstraints.insets = new Insets(4, 4, 4, 8);
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 1;
        gbConstraints.fill = 0;
        this.myParameterNameField = new NameSuggestionsField(this.myProject);
        JLabel nameLabel = new JLabel(RefactoringBundle.message((String)"name.prompt"));
        nameLabel.setLabelFor(this.myParameterNameField.getComponent());
        panel.add((Component)nameLabel, gbConstraints);
        ++gbConstraints.gridx;
        gbConstraints.insets = new Insets(4, 4, 4, 8);
        gbConstraints.weightx = 1.0;
        gbConstraints.fill = 1;
        panel.add((Component)this.myParameterNameField.getComponent(), gbConstraints);
        this.myParameterNameChangedListener = new NameSuggestionsField.DataChanged(){

            @Override
            public void dataChanged() {
                IntroduceParameterDialog.this.validateButtons();
            }
        };
        this.myParameterNameField.addDataChangedListener(this.myParameterNameChangedListener);
        this.myNameSuggestionsManager = new NameSuggestionsManager(this.myTypeSelector, this.myParameterNameField, this.myNameSuggestionsGenerator);
        this.myNameSuggestionsManager.setLabelsFor(type, nameLabel);
        gbConstraints.gridx = 0;
        gbConstraints.insets = new Insets(4, 0, 4, 8);
        gbConstraints.gridwidth = 2;
        if (this.myOccurenceNumber > 1 && !this.myIsInvokedOnDeclaration) {
            ++gbConstraints.gridy;
            this.myCbReplaceAllOccurences = new NonFocusableCheckBox();
            this.myCbReplaceAllOccurences.setText(RefactoringBundle.message((String)"replace.all.occurences", (Object[])new Object[]{this.myOccurenceNumber}));
            panel.add((Component)this.myCbReplaceAllOccurences, gbConstraints);
            this.myCbReplaceAllOccurences.setSelected(false);
        }
        JavaRefactoringSettings settings = JavaRefactoringSettings.getInstance();
        ++gbConstraints.gridy;
        this.myCbDeclareFinal = new NonFocusableCheckBox(RefactoringBundle.message((String)"declare.final"));
        Boolean settingsFinals = settings.INTRODUCE_PARAMETER_CREATE_FINALS;
        this.myCbDeclareFinal.setSelected(settingsFinals == null ? CodeStyleSettingsManager.getSettings((Project)this.myProject).GENERATE_FINAL_PARAMETERS : settingsFinals);
        panel.add((Component)this.myCbDeclareFinal, gbConstraints);
        if (this.myMustBeFinal) {
            this.myCbDeclareFinal.setSelected(true);
            this.myCbDeclareFinal.setEnabled(false);
        }
        if (this.myIsLocalVariable && !this.myIsInvokedOnDeclaration) {
            this.myCbDeleteLocalVariable = new StateRestoringCheckBox();
            this.myCbDeleteLocalVariable.setText(RefactoringBundle.message((String)"delete.variable.definition"));
            if (this.myCbReplaceAllOccurences != null) {
                gbConstraints.insets = new Insets(0, 16, 4, 8);
            }
            ++gbConstraints.gridy;
            panel.add((Component)this.myCbDeleteLocalVariable, gbConstraints);
            this.myCbDeleteLocalVariable.setSelected(settings.INTRODUCE_PARAMETER_DELETE_LOCAL_VARIABLE);
            gbConstraints.insets = new Insets(4, 0, 4, 8);
            if (this.myHasInitializer) {
                this.myCbUseInitializer = new StateRestoringCheckBox();
                this.myCbUseInitializer.setText(RefactoringBundle.message((String)"use.variable.initializer.to.initialize.parameter"));
                ++gbConstraints.gridy;
                panel.add((Component)this.myCbUseInitializer, gbConstraints);
            }
        }
        ++gbConstraints.gridy;
        this.myCbGenerateDelegate = new NonFocusableCheckBox(RefactoringBundle.message((String)"delegation.panel.delegate.via.overloading.method"));
        panel.add((Component)this.myCbGenerateDelegate, gbConstraints);
        for (int i = 0; i < this.myParametersToRemove.length; ++i) {
            PsiParameter parameter = this.myParametersToRemove[i];
            if (parameter == null) continue;
            final NonFocusableCheckBox cb = new NonFocusableCheckBox(RefactoringBundle.message((String)"remove.parameter.0.no.longer.used", (Object[])new Object[]{parameter.getName()}));
            cb.setSelected(true);
            ++gbConstraints.gridy;
            panel.add((Component)cb, gbConstraints);
            final int i1 = i;
            cb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((IntroduceParameterDialog)IntroduceParameterDialog.this).myParametersToRemoveChecked[i1] = cb.isSelected();
                }
            });
            this.myParametersToRemoveChecked[i] = true;
        }
        this.updateControls();
        if (this.myCbReplaceAllOccurences != null) {
            this.myCbReplaceAllOccurences.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    IntroduceParameterDialog.this.updateControls();
                }
            });
        }
        return panel;
    }

    private void updateControls() {
        if (this.myCbReplaceAllOccurences != null) {
            this.myTypeSelectorManager.setAllOccurences(this.myCbReplaceAllOccurences.isSelected());
            if (this.myCbReplaceAllOccurences.isSelected()) {
                if (this.myCbDeleteLocalVariable != null) {
                    this.myCbDeleteLocalVariable.makeSelectable();
                }
            } else if (this.myCbDeleteLocalVariable != null) {
                this.myCbDeleteLocalVariable.makeUnselectable(false);
            }
        } else {
            this.myTypeSelectorManager.setAllOccurences(this.myIsInvokedOnDeclaration);
        }
    }

    private JPanel createReplaceFieldsWithGettersPanel() {
        JPanel radioButtonPanel = new JPanel(new GridBagLayout());
        radioButtonPanel.setBorder(IdeBorderFactory.createBorder());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = new Insets(4, 8, 4, 8);
        gbConstraints.weighty = 1.0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridy = 0;
        gbConstraints.gridwidth = 0;
        gbConstraints.fill = 1;
        gbConstraints.anchor = 17;
        radioButtonPanel.add((Component)new JLabel(RefactoringBundle.message((String)"replace.fields.used.in.expressions.with.their.getters")), gbConstraints);
        this.myReplaceFieldsWithGettersNoneRadio = new JRadioButton();
        this.myReplaceFieldsWithGettersNoneRadio.setText(RefactoringBundle.message((String)"do.not.replace"));
        this.myReplaceFieldsWithGettersInaccessibleRadio = new JRadioButton();
        this.myReplaceFieldsWithGettersInaccessibleRadio.setText(RefactoringBundle.message((String)"replace.fields.inaccessible.in.usage.context"));
        this.myReplaceFieldsWithGettersAllRadio = new JRadioButton();
        this.myReplaceFieldsWithGettersAllRadio.setText(RefactoringBundle.message((String)"replace.all.fields"));
        ++gbConstraints.gridy;
        radioButtonPanel.add((Component)this.myReplaceFieldsWithGettersNoneRadio, gbConstraints);
        ++gbConstraints.gridy;
        radioButtonPanel.add((Component)this.myReplaceFieldsWithGettersInaccessibleRadio, gbConstraints);
        ++gbConstraints.gridy;
        radioButtonPanel.add((Component)this.myReplaceFieldsWithGettersAllRadio, gbConstraints);
        int currentSetting = JavaRefactoringSettings.getInstance().INTRODUCE_PARAMETER_REPLACE_FIELDS_WITH_GETTERS;
        this.myReplaceFieldsWithGettersButtonGroup.add(this.myReplaceFieldsWithGettersNoneRadio);
        this.myReplaceFieldsWithGettersButtonGroup.add(this.myReplaceFieldsWithGettersInaccessibleRadio);
        this.myReplaceFieldsWithGettersButtonGroup.add(this.myReplaceFieldsWithGettersAllRadio);
        if (currentSetting == 2) {
            this.myReplaceFieldsWithGettersAllRadio.setSelected(true);
        } else if (currentSetting == 1) {
            this.myReplaceFieldsWithGettersInaccessibleRadio.setSelected(true);
        } else if (currentSetting == 0) {
            this.myReplaceFieldsWithGettersNoneRadio.setSelected(true);
        }
        return radioButtonPanel;
    }

    protected JComponent createCenterPanel() {
        if (Util.anyFieldsWithGettersPresent(this.myClassMembersList)) {
            return this.createReplaceFieldsWithGettersPanel();
        }
        return null;
    }

    @Override
    protected void doAction() {
        JavaRefactoringSettings settings = JavaRefactoringSettings.getInstance();
        settings.INTRODUCE_PARAMETER_REPLACE_FIELDS_WITH_GETTERS = this.getReplaceFieldsWithGetters();
        if (this.myCbDeclareFinal != null && !this.myMustBeFinal) {
            settings.INTRODUCE_PARAMETER_CREATE_FINALS = this.myCbDeclareFinal.isSelected();
        }
        if (this.myCbDeleteLocalVariable != null) {
            settings.INTRODUCE_PARAMETER_DELETE_LOCAL_VARIABLE = this.myCbDeleteLocalVariable.isSelectedWhenSelectable();
        }
        this.myNameSuggestionsManager.nameSelected();
        boolean isDeleteLocalVariable = false;
        PsiExpression parameterInitializer = this.myExpression;
        if (this.myLocalVar != null) {
            if (this.isUseInitializer()) {
                parameterInitializer = this.myLocalVar.getInitializer();
            }
            isDeleteLocalVariable = this.isDeleteLocalVariable();
        }
        IntroduceParameterProcessor processor = new IntroduceParameterProcessor(this.myProject, this.myMethodToReplaceIn, this.myMethodToSearchFor, parameterInitializer, this.myExpression, this.myLocalVar, isDeleteLocalVariable, this.getParameterName(), this.isReplaceAllOccurences(), this.getReplaceFieldsWithGetters(), this.isDeclareFinal(), this.isGenerateDelegate(), this.getSelectedType(), this.getParametersToRemove());
        this.invokeRefactoring(processor);
        this.myParameterNameField.requestFocusInWindow();
    }

    private TIntArrayList getParametersToRemove() {
        TIntArrayList parameters = new TIntArrayList();
        for (int i = 0; i < this.myParametersToRemoveChecked.length; ++i) {
            if (!this.myParametersToRemoveChecked[i]) continue;
            parameters.add(i);
        }
        return parameters;
    }

    @Override
    protected void canRun() throws ConfigurationException {
        String name = this.getParameterName();
        if (name == null || !JavaPsiFacade.getInstance((Project)this.myProject).getNameHelper().isIdentifier(name.trim())) {
            throw new ConfigurationException("'" + StringUtil.first((String)(name != null ? name : ""), (int)10, (boolean)true) + "' is invalid parameter name");
        }
    }
}

