/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.ui;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypeUtil;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.TailType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.ui.TypeListCreatingVisitor;
import com.intellij.refactoring.ui.TypeSelector;
import com.intellij.refactoring.ui.TypeSelectorManager;
import com.intellij.refactoring.util.RefactoringHierarchyUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class TypeSelectorManagerImpl
implements TypeSelectorManager {
    private final PsiType myDefaultType;
    private final PsiExpression myMainOccurence;
    private final PsiExpression[] myOccurrences;
    private final PsiType[] myTypesForMain;
    private final PsiType[] myTypesForAll;
    private final boolean myIsOneSuggestion;
    private TypeSelector myTypeSelector;
    private final PsiElementFactory myFactory;
    private ExpectedTypesProvider.ExpectedClassProvider myOccurrenceClassProvider;
    private ExpectedTypesProvider myExpectedTypesProvider;

    public TypeSelectorManagerImpl(Project project, PsiType type, PsiExpression mainOccurence, PsiExpression[] occurrences) {
        this.myFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        this.myDefaultType = type;
        this.myMainOccurence = mainOccurence;
        this.myOccurrences = occurrences;
        this.myExpectedTypesProvider = ExpectedTypesProvider.getInstance(project);
        this.myOccurrenceClassProvider = this.createOccurrenceClassProvider();
        this.myTypesForMain = this.getTypesForMain();
        this.myTypesForAll = this.getTypesForAll(true);
        this.myIsOneSuggestion = this.myTypesForMain.length == 1 && this.myTypesForAll.length == 1 && this.myTypesForAll[0].equals(this.myTypesForMain[0]);
        this.myTypeSelector = this.myIsOneSuggestion ? new TypeSelector(this.myTypesForAll[0]) : new TypeSelector();
    }

    public TypeSelectorManagerImpl(Project project, PsiType type, PsiExpression[] occurrences) {
        this(project, type, occurrences, true);
    }

    public TypeSelectorManagerImpl(Project project, PsiType type, PsiExpression[] occurrences, boolean areTypesDirected) {
        this.myFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        this.myDefaultType = type;
        this.myMainOccurence = null;
        this.myOccurrences = occurrences;
        this.myExpectedTypesProvider = ExpectedTypesProvider.getInstance(project);
        this.myOccurrenceClassProvider = this.createOccurrenceClassProvider();
        this.myTypesForAll = this.getTypesForAll(areTypesDirected);
        this.myTypesForMain = PsiType.EMPTY_ARRAY;
        boolean bl = this.myIsOneSuggestion = this.myTypesForAll.length == 1;
        if (this.myIsOneSuggestion) {
            this.myTypeSelector = new TypeSelector(this.myTypesForAll[0]);
        } else {
            this.myTypeSelector = new TypeSelector();
            this.setTypesAndPreselect(this.myTypesForAll);
        }
    }

    public PsiType[] getTypesForAll() {
        return this.myTypesForAll;
    }

    private ExpectedTypesProvider.ExpectedClassProvider createOccurrenceClassProvider() {
        HashSet<PsiClass> occurrenceClasses = new HashSet<PsiClass>();
        for (PsiExpression occurence : this.myOccurrences) {
            PsiType occurrenceType = occurence.getType();
            PsiClass aClass = PsiUtil.resolveClassInType((PsiType)occurrenceType);
            if (aClass == null) continue;
            occurrenceClasses.add(aClass);
        }
        return new ExpectedTypeUtil.ExpectedClassesFromSetProvider(occurrenceClasses);
    }

    private PsiType[] getTypesForMain() {
        final ExpectedTypeInfo[] expectedTypes = this.myExpectedTypesProvider.getExpectedTypes(this.myMainOccurence, false, this.myOccurrenceClassProvider);
        final ArrayList<PsiType> allowedTypes = new ArrayList<PsiType>();
        RefactoringHierarchyUtil.processSuperTypes(this.myDefaultType, new RefactoringHierarchyUtil.SuperTypeVisitor(){

            @Override
            public void visitType(PsiType aType) {
                this.checkIfAllowed(aType);
            }

            @Override
            public void visitClass(PsiClass aClass) {
                this.checkIfAllowed((PsiType)TypeSelectorManagerImpl.this.myFactory.createType(aClass));
            }

            private void checkIfAllowed(PsiType type) {
                if (expectedTypes != null && expectedTypes.length > 0) {
                    TypeSelectorManagerImpl.this.myExpectedTypesProvider;
                    ExpectedTypeInfo typeInfo = ExpectedTypesProvider.createInfo(type, 0, type, TailType.NONE);
                    for (ExpectedTypeInfo expectedType : expectedTypes) {
                        if (expectedType.intersect(typeInfo).length == 0) continue;
                        allowedTypes.add(type);
                        break;
                    }
                } else {
                    allowedTypes.add(type);
                }
            }
        });
        ArrayList<PsiType> result = this.normalizeTypeList(allowedTypes);
        return result.toArray(new PsiType[result.size()]);
    }

    private PsiType[] getTypesForAll(boolean areTypesDirected) {
        final ArrayList<ExpectedTypeInfo[]> expectedTypesFromAll = new ArrayList<ExpectedTypeInfo[]>();
        for (PsiExpression occurrence : this.myOccurrences) {
            ExpectedTypeInfo[] expectedTypes = this.myExpectedTypesProvider.getExpectedTypes(occurrence, false, this.myOccurrenceClassProvider);
            if (expectedTypes.length <= 0) continue;
            expectedTypesFromAll.add(expectedTypes);
        }
        final ArrayList<PsiType> allowedTypes = new ArrayList<PsiType>();
        RefactoringHierarchyUtil.processSuperTypes(this.myDefaultType, new RefactoringHierarchyUtil.SuperTypeVisitor(){

            @Override
            public void visitType(PsiType aType) {
                this.checkIfAllowed(aType);
            }

            @Override
            public void visitClass(PsiClass aClass) {
                this.checkIfAllowed((PsiType)TypeSelectorManagerImpl.this.myFactory.createType(aClass));
            }

            private void checkIfAllowed(PsiType type) {
                Iterator i$ = expectedTypesFromAll.iterator();
                block0: while (i$.hasNext()) {
                    ExpectedTypeInfo[] expectedTypes;
                    for (ExpectedTypeInfo info : expectedTypes = (ExpectedTypeInfo[])i$.next()) {
                        if (ExpectedTypeUtil.matches(type, info)) continue block0;
                    }
                    return;
                }
                allowedTypes.add(type);
            }
        });
        ArrayList<PsiType> result = this.normalizeTypeList(allowedTypes);
        if (!areTypesDirected) {
            Collections.reverse(result);
        }
        return result.toArray(new PsiType[result.size()]);
    }

    private ArrayList<PsiType> normalizeTypeList(ArrayList<PsiType> typeList) {
        PsiPrimitiveType unboxedType;
        ArrayList<PsiType> result = new ArrayList<PsiType>();
        TypeListCreatingVisitor visitor = new TypeListCreatingVisitor(result, this.myFactory);
        for (PsiType psiType : typeList) {
            visitor.visitType(psiType);
        }
        for (int index = 0; index < result.size(); ++index) {
            PsiType psiType;
            psiType = result.get(index);
            if (!psiType.equals(this.myDefaultType)) continue;
            result.remove(index);
            break;
        }
        if ((unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)this.myDefaultType)) != null) {
            result.remove(unboxedType);
            result.add(0, (PsiType)unboxedType);
        }
        result.add(0, this.myDefaultType);
        return result;
    }

    @Override
    public void setAllOccurences(boolean allOccurences) {
        if (this.myIsOneSuggestion) {
            return;
        }
        this.setTypesAndPreselect(allOccurences ? this.myTypesForAll : this.myTypesForMain);
    }

    private void setTypesAndPreselect(PsiType[] types) {
        this.myTypeSelector.setTypes(types);
        THashMap map = new THashMap();
        for (PsiType psiType : types) {
            map.put(this.serialize(psiType), psiType);
        }
        for (PsiType psiType : StatisticsManager.getInstance().getAllValues(this.getStatsKey())) {
            PsiType candidate = (PsiType)map.get(psiType.getValue());
            if (candidate == null || StatisticsManager.getInstance().getUseCount((StatisticsInfo)psiType) <= 0) continue;
            this.myTypeSelector.selectType(candidate);
            return;
        }
    }

    @Override
    public boolean isSuggestedType(String fqName) {
        for (PsiType type : this.myTypesForAll) {
            if (!type.getCanonicalText().equals(fqName)) continue;
            return true;
        }
        for (PsiType type : this.myTypesForMain) {
            if (!type.getCanonicalText().equals(fqName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void typeSelected(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/ui/TypeSelectorManagerImpl.typeSelected must not be null");
        }
        StatisticsManager.getInstance().incUseCount(new StatisticsInfo(this.getStatsKey(), this.serialize(type)));
    }

    private String getStatsKey() {
        return "IntroduceVariable##" + this.serialize(this.myDefaultType);
    }

    private String serialize(PsiType type) {
        return TypeConversionUtil.erasure((PsiType)type).getCanonicalText();
    }

    @Override
    public TypeSelector getTypeSelector() {
        return this.myTypeSelector;
    }
}

