/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.semantic.SemService;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.JavaMethod;
import com.intellij.util.xml.impl.AbstractDomChildDescriptionImpl;
import com.intellij.util.xml.impl.AttributeChildDescriptionImpl;
import com.intellij.util.xml.impl.ChildrenDescriptionsHolder;
import com.intellij.util.xml.impl.CollectionChildDescriptionImpl;
import com.intellij.util.xml.impl.CustomDomChildrenDescriptionImpl;
import com.intellij.util.xml.impl.DomGenericInfoEx;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.FixedChildDescriptionImpl;
import com.intellij.util.xml.impl.Invocation;
import com.intellij.util.xml.impl.StaticGenericInfo;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.reflect.DomExtender;
import com.intellij.util.xml.reflect.DomExtenderEP;
import com.intellij.util.xml.reflect.DomExtensionImpl;
import com.intellij.util.xml.reflect.DomExtensionsRegistrar;
import com.intellij.util.xml.reflect.DomExtensionsRegistrarImpl;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import gnu.trove.THashSet;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicGenericInfo
extends DomGenericInfoEx {
    private final StaticGenericInfo myStaticGenericInfo;
    @NotNull
    private final DomInvocationHandler myInvocationHandler;
    private final Project myProject;
    private final ThreadLocal<Boolean> myComputing;
    private volatile boolean myInitialized;
    private volatile ChildrenDescriptionsHolder<AttributeChildDescriptionImpl> myAttributes;
    private volatile ChildrenDescriptionsHolder<FixedChildDescriptionImpl> myFixeds;
    private volatile ChildrenDescriptionsHolder<CollectionChildDescriptionImpl> myCollections;
    private volatile CustomDomChildrenDescriptionImpl myCustomChildren;

    public DynamicGenericInfo(@NotNull DomInvocationHandler handler, StaticGenericInfo staticGenericInfo, Project project) {
        if (handler == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/impl/DynamicGenericInfo.<init> must not be null");
        }
        this.myComputing = new ThreadLocal();
        this.myInvocationHandler = handler;
        this.myStaticGenericInfo = staticGenericInfo;
        this.myProject = project;
        this.myAttributes = staticGenericInfo.getAttributes();
        this.myFixeds = staticGenericInfo.getFixed();
        this.myCollections = staticGenericInfo.getCollections();
    }

    @Override
    public Invocation createInvocation(JavaMethod method) {
        return this.myStaticGenericInfo.createInvocation(method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean checkInitialized() {
        if (this.myInitialized) {
            return true;
        }
        this.myStaticGenericInfo.buildMethodMaps();
        if (this.myComputing.get() == Boolean.TRUE) {
            return false;
        }
        XmlElement element = this.myInvocationHandler.getXmlElement();
        if (element == null) {
            return true;
        }
        this.myComputing.set(Boolean.TRUE);
        try {
            DomExtensionsRegistrarImpl registrar = this.runDomExtenders();
            XmlElement xmlElement = element;
            synchronized (xmlElement) {
                block22: {
                    if (!this.myInitialized) break block22;
                    boolean bl = true;
                    return bl;
                }
                if (registrar != null) {
                    DomExtensionImpl extension;
                    SemService semService = SemService.getSemService((Project)this.myProject);
                    List<DomExtensionImpl> fixeds = registrar.getFixeds();
                    List<DomExtensionImpl> collections = registrar.getCollections();
                    List<DomExtensionImpl> attributes = registrar.getAttributes();
                    if (!attributes.isEmpty()) {
                        ChildrenDescriptionsHolder<AttributeChildDescriptionImpl> newAttributes = new ChildrenDescriptionsHolder<AttributeChildDescriptionImpl>(this.myStaticGenericInfo.getAttributes());
                        for (DomExtensionImpl extension2 : attributes) {
                            newAttributes.addDescription(extension2.addAnnotations(new AttributeChildDescriptionImpl(extension2.getXmlName(), extension2.getType())));
                        }
                        for (XmlAttribute attribute : ((XmlTag)element).getAttributes()) {
                            semService.clearCachedSemElements((PsiElement)attribute);
                        }
                        this.myAttributes = newAttributes;
                    }
                    boolean clearSubTags = false;
                    if (!fixeds.isEmpty()) {
                        ChildrenDescriptionsHolder<FixedChildDescriptionImpl> newFixeds = new ChildrenDescriptionsHolder<FixedChildDescriptionImpl>(this.myStaticGenericInfo.getFixed());
                        for (DomExtensionImpl extension3 : fixeds) {
                            newFixeds.addDescription(extension3.addAnnotations(new FixedChildDescriptionImpl(extension3.getXmlName(), extension3.getType(), extension3.getCount(), ArrayUtil.EMPTY_COLLECTION_ARRAY)));
                        }
                        clearSubTags = true;
                        this.myFixeds = newFixeds;
                    }
                    if (!collections.isEmpty()) {
                        ChildrenDescriptionsHolder<CollectionChildDescriptionImpl> newCollections = new ChildrenDescriptionsHolder<CollectionChildDescriptionImpl>(this.myStaticGenericInfo.getCollections());
                        for (DomExtensionImpl extension4 : collections) {
                            newCollections.addDescription(extension4.addAnnotations(new CollectionChildDescriptionImpl(extension4.getXmlName(), extension4.getType(), Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST)));
                        }
                        clearSubTags = true;
                        this.myCollections = newCollections;
                    }
                    if ((extension = registrar.getCustomChildrenType()) != null) {
                        this.myCustomChildren = new CustomDomChildrenDescriptionImpl(null, extension.getType());
                        clearSubTags = true;
                    }
                    if (clearSubTags) {
                        for (XmlTag tag : ((XmlTag)element).getSubTags()) {
                            semService.clearCachedSemElements((PsiElement)tag);
                        }
                    }
                }
                this.myInitialized = true;
            }
        }
        finally {
            this.myComputing.set(null);
        }
        return true;
    }

    @Nullable
    private DomExtensionsRegistrarImpl runDomExtenders() {
        List<DomExtender> extenders;
        DomExtensionsRegistrarImpl registrar = null;
        DomElement domElement = this.myInvocationHandler.getProxy();
        for (DomExtenderEP extenderEP : (DomExtenderEP[])Extensions.getExtensions(DomExtenderEP.EP_NAME)) {
            registrar = extenderEP.extend(this.myProject, domElement, registrar);
        }
        AbstractDomChildrenDescription description = this.myInvocationHandler.getChildDescription();
        if (description != null && (extenders = description.getUserData(DomExtensionImpl.DOM_EXTENDER_KEY)) != null) {
            if (registrar == null) {
                registrar = new DomExtensionsRegistrarImpl();
            }
            for (DomExtender extender : extenders) {
                extender.registerExtensions(domElement, (DomExtensionsRegistrar)registrar);
            }
        }
        return registrar;
    }

    public XmlElement getNameElement(DomElement element) {
        return this.myStaticGenericInfo.getNameElement(element);
    }

    public GenericDomValue getNameDomElement(DomElement element) {
        return this.myStaticGenericInfo.getNameDomElement(element);
    }

    @Nullable
    public CustomDomChildrenDescriptionImpl getCustomNameChildrenDescription() {
        this.checkInitialized();
        if (this.myCustomChildren != null) {
            return this.myCustomChildren;
        }
        return this.myStaticGenericInfo.getCustomNameChildrenDescription();
    }

    public String getElementName(DomElement element) {
        return this.myStaticGenericInfo.getElementName(element);
    }

    @NotNull
    public List<AbstractDomChildDescriptionImpl> getChildrenDescriptions() {
        this.checkInitialized();
        ArrayList<AbstractDomChildDescriptionImpl> list = new ArrayList<AbstractDomChildDescriptionImpl>();
        list.addAll(this.myAttributes.getDescriptions());
        list.addAll(this.myFixeds.getDescriptions());
        list.addAll(this.myCollections.getDescriptions());
        ContainerUtil.addIfNotNull((Object)this.myStaticGenericInfo.getCustomNameChildrenDescription(), list);
        ArrayList<AbstractDomChildDescriptionImpl> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DynamicGenericInfo.getChildrenDescriptions must not return null");
        }
        return arrayList;
    }

    @NotNull
    public final List<FixedChildDescriptionImpl> getFixedChildrenDescriptions() {
        this.checkInitialized();
        List<FixedChildDescriptionImpl> list = this.myFixeds.getDescriptions();
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DynamicGenericInfo.getFixedChildrenDescriptions must not return null");
        }
        return list;
    }

    @NotNull
    public final List<CollectionChildDescriptionImpl> getCollectionChildrenDescriptions() {
        this.checkInitialized();
        List<CollectionChildDescriptionImpl> list = this.myCollections.getDescriptions();
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DynamicGenericInfo.getCollectionChildrenDescriptions must not return null");
        }
        return list;
    }

    public FixedChildDescriptionImpl getFixedChildDescription(String tagName) {
        this.checkInitialized();
        return this.myFixeds.findDescription(tagName);
    }

    public DomFixedChildDescription getFixedChildDescription(@NonNls String tagName, @NonNls String namespace) {
        this.checkInitialized();
        return this.myFixeds.getDescription(tagName, namespace);
    }

    public CollectionChildDescriptionImpl getCollectionChildDescription(String tagName) {
        this.checkInitialized();
        return this.myCollections.findDescription(tagName);
    }

    public DomCollectionChildDescription getCollectionChildDescription(@NonNls String tagName, @NonNls String namespace) {
        this.checkInitialized();
        return this.myCollections.getDescription(tagName, namespace);
    }

    public AttributeChildDescriptionImpl getAttributeChildDescription(String attributeName) {
        this.checkInitialized();
        return this.myAttributes.findDescription(attributeName);
    }

    public DomAttributeChildDescription getAttributeChildDescription(@NonNls String attributeName, @NonNls String namespace) {
        this.checkInitialized();
        return this.myAttributes.getDescription(attributeName, namespace);
    }

    public Type[] getConcreteInterfaceVariants() {
        return this.myStaticGenericInfo.getConcreteInterfaceVariants();
    }

    public boolean isTagValueElement() {
        return this.myStaticGenericInfo.isTagValueElement();
    }

    @Override
    @NotNull
    public List<AttributeChildDescriptionImpl> getAttributeChildrenDescriptions() {
        this.checkInitialized();
        List<AttributeChildDescriptionImpl> list = this.myAttributes.getDescriptions();
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DynamicGenericInfo.getAttributeChildrenDescriptions must not return null");
        }
        return list;
    }

    @Override
    public boolean processAttributeChildrenDescriptions(Processor<AttributeChildDescriptionImpl> processor) {
        THashSet visited = new THashSet();
        if (!this.myStaticGenericInfo.processAttributeChildrenDescriptions(new Processor<AttributeChildDescriptionImpl>((Set)visited, processor){
            final /* synthetic */ Set val$visited;
            final /* synthetic */ Processor val$processor;
            {
                this.val$visited = set;
                this.val$processor = processor;
            }

            public boolean process(AttributeChildDescriptionImpl attributeChildDescription) {
                this.val$visited.add(attributeChildDescription);
                return this.val$processor.process((Object)attributeChildDescription);
            }
        })) {
            return false;
        }
        for (AttributeChildDescriptionImpl description : this.getAttributeChildrenDescriptions()) {
            if (visited.contains(description) || processor.process((Object)description)) continue;
            return false;
        }
        return true;
    }
}

