/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NonNls;

public class EditorInfo {
    @NonNls
    public static final String CARET_MARKER = "<caret>";
    @NonNls
    public static final String SELECTION_START_MARKER = "<selection>";
    @NonNls
    public static final String SELECTION_END_MARKER = "</selection>";
    String newFileText = null;
    public RangeMarker caretMarker = null;
    RangeMarker selStartMarker = null;
    RangeMarker selEndMarker = null;

    public EditorInfo(String fileText) {
        this.updateCaretAndSelection(EditorFactory.getInstance().createDocument(fileText));
    }

    public boolean updateCaretAndSelection(Document document) {
        this.newFileText = document.getText();
        int caretIndex = this.newFileText.indexOf(CARET_MARKER);
        int selStartIndex = this.newFileText.indexOf(SELECTION_START_MARKER);
        int selEndIndex = this.newFileText.indexOf(SELECTION_END_MARKER);
        this.caretMarker = caretIndex >= 0 ? document.createRangeMarker(caretIndex, caretIndex) : null;
        this.selStartMarker = selStartIndex >= 0 ? document.createRangeMarker(selStartIndex, selStartIndex) : null;
        RangeMarker rangeMarker = this.selEndMarker = selEndIndex >= 0 ? document.createRangeMarker(selEndIndex, selEndIndex) : null;
        if (this.caretMarker != null) {
            document.deleteString(this.caretMarker.getStartOffset(), this.caretMarker.getStartOffset() + CARET_MARKER.length());
        }
        if (this.selStartMarker != null) {
            document.deleteString(this.selStartMarker.getStartOffset(), this.selStartMarker.getStartOffset() + SELECTION_START_MARKER.length());
        }
        if (this.selEndMarker != null) {
            document.deleteString(this.selEndMarker.getStartOffset(), this.selEndMarker.getStartOffset() + SELECTION_END_MARKER.length());
        }
        this.newFileText = document.getText();
        return this.caretMarker != null || this.selStartMarker != null || this.selEndMarker != null;
    }

    public String getNewFileText() {
        return this.newFileText;
    }

    public void applyToEditor(Editor editor) {
        if (this.caretMarker != null) {
            int caretLine = StringUtil.offsetToLineNumber((CharSequence)this.newFileText, (int)this.caretMarker.getStartOffset());
            int caretCol = this.caretMarker.getStartOffset() - StringUtil.lineColToOffset((CharSequence)this.newFileText, (int)caretLine, (int)0);
            LogicalPosition pos = new LogicalPosition(caretLine, caretCol);
            editor.getCaretModel().moveToLogicalPosition(pos);
        }
        if (this.selStartMarker != null) {
            editor.getSelectionModel().setSelection(this.selStartMarker.getStartOffset(), this.selEndMarker.getStartOffset());
        }
    }
}

