/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant;

import com.intellij.compiler.ant.ChunkCustomCompilerExtension;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import org.jetbrains.annotations.Nullable;

public class ModuleChunk {
    private final Module[] myModules;
    private final ChunkCustomCompilerExtension[] myCustomCompilers;
    private Module myMainModule;
    private ModuleChunk[] myDependentChunks;
    private File myBaseDir = null;

    public ModuleChunk(Module[] modules) {
        this.myModules = modules;
        Arrays.sort(this.myModules, new Comparator<Module>(){

            @Override
            public int compare(Module o1, Module o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        this.myMainModule = this.myModules[0];
        this.myCustomCompilers = ChunkCustomCompilerExtension.getCustomCompile(this);
    }

    public String getName() {
        return this.myMainModule.getName();
    }

    public ChunkCustomCompilerExtension[] getCustomCompilers() {
        return this.myCustomCompilers;
    }

    public Module[] getModules() {
        return this.myModules;
    }

    @Nullable
    public String getOutputDirUrl() {
        return CompilerModuleExtension.getInstance(this.myMainModule).getCompilerOutputUrl();
    }

    @Nullable
    public String getTestsOutputDirUrl() {
        return CompilerModuleExtension.getInstance(this.myMainModule).getCompilerOutputUrlForTests();
    }

    public boolean isJdkInherited() {
        return ModuleRootManager.getInstance(this.myMainModule).isSdkInherited();
    }

    @Nullable
    public Sdk getJdk() {
        return ModuleRootManager.getInstance(this.myMainModule).getSdk();
    }

    public ModuleChunk[] getDependentChunks() {
        return this.myDependentChunks;
    }

    public void setDependentChunks(ModuleChunk[] dependentChunks) {
        this.myDependentChunks = dependentChunks;
    }

    public File getBaseDir() {
        if (this.myBaseDir != null) {
            return this.myBaseDir;
        }
        return new File(this.myMainModule.getModuleFilePath()).getParentFile();
    }

    public void setBaseDir(File baseDir) {
        this.myBaseDir = baseDir;
    }

    public void setMainModule(Module module) {
        this.myMainModule = module;
    }

    public Project getProject() {
        return this.myMainModule.getProject();
    }

    public boolean contains(Module module) {
        for (Module chunkModule : this.myModules) {
            if (!chunkModule.equals(module)) continue;
            return true;
        }
        return false;
    }
}

