/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FoldingDescriptor {
    public static final FoldingDescriptor[] EMPTY = new FoldingDescriptor[0];
    private final ASTNode myElement;
    private final TextRange myRange;
    @Nullable
    private final FoldingGroup myGroup;
    private Set<Object> myDependencies;

    public FoldingDescriptor(@NotNull ASTNode node, @NotNull TextRange range) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/folding/FoldingDescriptor.<init> must not be null");
        }
        if (range == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/folding/FoldingDescriptor.<init> must not be null");
        }
        this(node, range, null);
    }

    public FoldingDescriptor(@NotNull PsiElement element, @NotNull TextRange range) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/folding/FoldingDescriptor.<init> must not be null");
        }
        if (range == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/folding/FoldingDescriptor.<init> must not be null");
        }
        this((ASTNode)ObjectUtils.assertNotNull((Object)element.getNode()), range, null);
    }

    public FoldingDescriptor(@NotNull ASTNode node, @NotNull TextRange range, @Nullable FoldingGroup group) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/folding/FoldingDescriptor.<init> must not be null");
        }
        if (range == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/folding/FoldingDescriptor.<init> must not be null");
        }
        this(node, range, group, Collections.emptySet());
    }

    public FoldingDescriptor(@NotNull ASTNode node, @NotNull TextRange range, @Nullable FoldingGroup group, Set<Object> dependencies) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/folding/FoldingDescriptor.<init> must not be null");
        }
        if (range == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/folding/FoldingDescriptor.<init> must not be null");
        }
        assert (range.getStartOffset() + 1 < range.getEndOffset()) : range;
        this.myElement = node;
        ProperTextRange.assertProperRange((TextRange)range);
        this.myRange = range;
        this.myGroup = group;
        assert (this.getRange().getLength() >= 2) : "range:" + this.getRange();
        this.myDependencies = dependencies;
    }

    @NotNull
    public ASTNode getElement() {
        ASTNode aSTNode = this.myElement;
        if (aSTNode == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/folding/FoldingDescriptor.getElement must not return null");
        }
        return aSTNode;
    }

    @NotNull
    public TextRange getRange() {
        TextRange textRange = this.myRange;
        if (textRange == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/folding/FoldingDescriptor.getRange must not return null");
        }
        return textRange;
    }

    @Nullable
    public FoldingGroup getGroup() {
        return this.myGroup;
    }

    @Nullable
    public String getPlaceholderText() {
        PsiElement psiElement = this.myElement.getPsi();
        if (psiElement == null) {
            return null;
        }
        Language lang = psiElement.getLanguage();
        FoldingBuilder foldingBuilder = LanguageFolding.INSTANCE.forLanguage(lang);
        if (foldingBuilder != null) {
            return foldingBuilder.getPlaceholderText(this.myElement);
        }
        return null;
    }

    @NotNull
    public Set<Object> getDependencies() {
        Set<Object> set = this.myDependencies;
        if (set == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/folding/FoldingDescriptor.getDependencies must not return null");
        }
        return set;
    }
}

