/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.UiDecorator;
import com.intellij.ui.tabs.impl.ActionPanel;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.util.ui.Centerizer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class TabLabel
extends JPanel {
    private final SimpleColoredComponent myLabel = new SimpleColoredComponent();
    private final LayeredIcon myIcon;
    private Icon myOverlayedIcon;
    private final TabInfo myInfo;
    private ActionPanel myActionPanel;
    private boolean myCentered;
    private final Wrapper myLabelPlaceholder = new Wrapper();
    private final JBTabsImpl myTabs;
    private BufferedImage myImage;
    private BufferedImage myInactiveStateImage;
    private Rectangle myLastPaintedInactiveImageBounds;

    public TabLabel(JBTabsImpl tabs, final TabInfo info) {
        this.myTabs = tabs;
        this.myInfo = info;
        this.myLabel.setOpaque(false);
        this.myLabel.setBorder(null);
        this.myLabel.setIconTextGap(new JLabel().getIconTextGap());
        this.myLabel.setIconOpaque(false);
        this.myLabel.setIpad(new Insets(0, 0, 0, 0));
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.myLabelPlaceholder.setOpaque(false);
        this.add((Component)this.myLabelPlaceholder, "Center");
        this.setAligmentToCenter(true);
        this.myIcon = new LayeredIcon(2);
        this.myLabel.setIcon(this.myIcon);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (TabLabel.this.myTabs.isSelectionClick(e, false) && TabLabel.this.myInfo.isEnabled()) {
                    TabLabel.this.myTabs.select(info, true);
                } else {
                    TabLabel.this.handlePopup(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                TabLabel.this.handlePopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                TabLabel.this.handlePopup(e);
            }
        });
    }

    public void setAligmentToCenter(boolean toCenter) {
        if (this.myCentered == toCenter && this.myLabel.getParent() != null) {
            return;
        }
        this.myLabelPlaceholder.removeAll();
        if (toCenter) {
            Centerizer center = new Centerizer((JComponent)this.myLabel);
            this.myLabelPlaceholder.setContent((JComponent)center);
        } else {
            this.myLabelPlaceholder.setContent(this.myLabel);
        }
        this.myCentered = toCenter;
    }

    @Override
    public void paint(Graphics g) {
        if (this.myTabs.getSelectedInfo() != this.myInfo) {
            this.myImage = null;
            this.doPaint(g);
        } else if (!SystemInfo.isMac) {
            this.myImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            Graphics2D lg = this.myImage.createGraphics();
            this.doPaint(lg);
            lg.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintImage(Graphics g) {
        Rectangle b = this.getBounds();
        if (this.myImage != null) {
            g.drawImage(this.myImage, b.x, b.y, this.getWidth(), this.getHeight(), null);
        } else {
            Graphics lG = g.create(b.x, b.y, b.width, b.height);
            try {
                lG.setColor(Color.red);
                this.doPaint(lG);
            }
            finally {
                lG.dispose();
            }
        }
    }

    private void doPaint(Graphics g) {
        JBTabsPosition pos = this.myTabs.getTabsPosition();
        int dX = 0;
        int dXs = 0;
        int dY = 0;
        int dYs = 0;
        int selected = this.getSelectedOffset();
        int plain = this.getNonSelectedOffset();
        switch (pos) {
            case bottom: {
                dY = -plain;
                dYs = -selected;
                break;
            }
            case left: {
                dX = plain;
                dXs = selected;
                break;
            }
            case right: {
                dX = -plain;
                dXs = -selected;
                break;
            }
            case top: {
                dY = plain;
                dYs = selected;
            }
        }
        if (this.myTabs.getSelectedInfo() != this.myInfo) {
            g.translate(dX, dY);
        } else {
            g.translate(dXs, dYs);
        }
        super.paint(g);
        if (this.myTabs.getSelectedInfo() != this.myInfo) {
            g.translate(-dX, -dY);
        } else {
            g.translate(-dXs, -dYs);
        }
    }

    private int getNonSelectedOffset() {
        return 2;
    }

    private int getSelectedOffset() {
        return 1;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        JBTabsPosition pos = this.myTabs.getTabsPosition();
        switch (pos) {
            case bottom: 
            case top: {
                size.height += this.getSelectedOffset();
                break;
            }
            case left: 
            case right: {
                size.width += this.getSelectedOffset();
            }
        }
        return size;
    }

    private void handlePopup(MouseEvent e) {
        JBTabsImpl tabs;
        if (e.getClickCount() != 1 || !e.isPopupTrigger()) {
            return;
        }
        if (e.getX() < 0 || e.getX() >= e.getComponent().getWidth() || e.getY() < 0 || e.getY() >= e.getComponent().getHeight()) {
            return;
        }
        String place = this.myTabs.getPopupPlace();
        place = place != null ? place : "unknown";
        this.myTabs.myPopupInfo = this.myInfo;
        DefaultActionGroup toShow = new DefaultActionGroup();
        if (this.myTabs.getPopupGroup() != null) {
            toShow.addAll(this.myTabs.getPopupGroup());
            toShow.addSeparator();
        }
        if ((tabs = JBTabsImpl.NAVIGATION_ACTIONS_KEY.getData(DataManager.getInstance().getDataContext(e.getComponent(), e.getX(), e.getY()))) == this.myTabs && this.myTabs.myAddNavigationGroup) {
            toShow.addAll(this.myTabs.myNavigationActions);
        }
        if (toShow.getChildrenCount() == 0) {
            return;
        }
        this.myTabs.myActivePopup = this.myTabs.myActionManager.createActionPopupMenu(place, toShow).getComponent();
        this.myTabs.myActivePopup.addPopupMenuListener(this.myTabs.myPopupListener);
        this.myTabs.myActivePopup.addPopupMenuListener(this.myTabs);
        this.myTabs.myActivePopup.show(e.getComponent(), e.getX(), e.getY());
        this.myTabs.onPopup(this.myTabs.myPopupInfo);
    }

    public void setText(final SimpleColoredText text) {
        this.myLabel.change(new Runnable(){

            @Override
            public void run() {
                TabLabel.this.myLabel.clear();
                TabLabel.this.myLabel.setIcon(TabLabel.this.myIcon);
                if (text != null) {
                    text.appendToComponent(TabLabel.this.myLabel);
                }
            }
        }, false);
        this.invalidateIfNeeded();
    }

    private void invalidateIfNeeded() {
        if (this.myLabel.getRootPane() == null) {
            return;
        }
        if (this.myLabel.getSize() != null && this.myLabel.getSize().equals(this.myLabel.getPreferredSize())) {
            return;
        }
        this.setInactiveStateImage(null);
        this.myLabel.invalidate();
        if (this.myActionPanel != null) {
            this.myActionPanel.invalidate();
        }
        this.myTabs.revalidateAndRepaint(false);
    }

    public void setIcon(Icon icon) {
        this.getLayeredIcon().setIcon(icon, 0);
        this.invalidateIfNeeded();
    }

    private LayeredIcon getLayeredIcon() {
        return this.myIcon;
    }

    public void setAttraction(boolean enabled) {
        this.getLayeredIcon().setLayerEnabled(1, enabled);
    }

    public boolean isAttractionEnabled() {
        return this.getLayeredIcon().isLayerEnabled(1);
    }

    public TabInfo getInfo() {
        return this.myInfo;
    }

    public void apply(UiDecorator.UiDecoration decoration) {
        Insets current;
        Insets insets;
        if (decoration.getLabelFont() != null) {
            this.setFont(decoration.getLabelFont());
        }
        if ((insets = decoration.getLabelInsets()) != null && (current = JBTabsImpl.ourDefaultDecorator.getDecoration().getLabelInsets()) != null) {
            this.setBorder(new EmptyBorder(TabLabel.getValue(current.top, insets.top), TabLabel.getValue(current.left, insets.left), TabLabel.getValue(current.bottom, insets.bottom), TabLabel.getValue(current.right, insets.right)));
        }
    }

    private static int getValue(int curentValue, int newValue) {
        return newValue != -1 ? newValue : curentValue;
    }

    public void setTabActions(ActionGroup group) {
        this.removeOldActionPanel();
        if (group == null) {
            return;
        }
        this.myActionPanel = new ActionPanel(this.myTabs, this.myInfo, new Pass<MouseEvent>(){

            public void pass(MouseEvent event) {
                MouseEvent me = SwingUtilities.convertMouseEvent(event.getComponent(), event, TabLabel.this);
                TabLabel.this.processMouseEvent(me);
            }
        });
        this.toggleShowActions(false);
        this.add((Component)this.myActionPanel, "East");
        this.myTabs.revalidateAndRepaint(false);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
    }

    private void removeOldActionPanel() {
        if (this.myActionPanel != null) {
            this.myActionPanel.getParent().remove(this.myActionPanel);
            this.myActionPanel = null;
        }
    }

    public boolean updateTabActions() {
        return this.myActionPanel != null && this.myActionPanel.update();
    }

    private void setAttractionIcon(Icon icon) {
        if (this.myIcon.getIcon(0) == null) {
            this.getLayeredIcon().setIcon(null, 1);
            this.myOverlayedIcon = icon;
        } else {
            this.getLayeredIcon().setIcon(icon, 1);
            this.myOverlayedIcon = null;
        }
    }

    public boolean repaintAttraction() {
        if (!this.myTabs.myAttractions.contains(this.myInfo)) {
            if (this.getLayeredIcon().isLayerEnabled(1)) {
                this.getLayeredIcon().setLayerEnabled(1, false);
                this.setAttractionIcon(null);
                this.invalidateIfNeeded();
                return true;
            }
            return false;
        }
        boolean needsUpdate = false;
        if (this.getLayeredIcon().getIcon(1) != this.myInfo.getAlertIcon()) {
            this.setAttractionIcon(this.myInfo.getAlertIcon());
            needsUpdate = true;
        }
        int maxInitialBlinkCount = 5;
        int maxRefireBlinkCount = maxInitialBlinkCount + 2;
        if (this.myInfo.getBlinkCount() < maxInitialBlinkCount && this.myInfo.isAlertRequested()) {
            this.getLayeredIcon().setLayerEnabled(1, !this.getLayeredIcon().isLayerEnabled(1));
            if (this.myInfo.getBlinkCount() == 0) {
                needsUpdate = true;
            }
            this.myInfo.setBlinkCount(this.myInfo.getBlinkCount() + 1);
            if (this.myInfo.getBlinkCount() == maxInitialBlinkCount) {
                this.myInfo.resetAlertRequest();
            }
            this.repaint();
        } else if (this.myInfo.getBlinkCount() < maxRefireBlinkCount && this.myInfo.isAlertRequested()) {
            this.getLayeredIcon().setLayerEnabled(1, !this.getLayeredIcon().isLayerEnabled(1));
            this.myInfo.setBlinkCount(this.myInfo.getBlinkCount() + 1);
            if (this.myInfo.getBlinkCount() == maxRefireBlinkCount) {
                this.myInfo.setBlinkCount(maxInitialBlinkCount);
                this.myInfo.resetAlertRequest();
            }
            this.repaint();
        } else {
            needsUpdate = !this.getLayeredIcon().isLayerEnabled(1);
            this.getLayeredIcon().setLayerEnabled(1, true);
        }
        this.invalidateIfNeeded();
        return needsUpdate;
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this.myOverlayedIcon == null || this.myLabel.getParent() == null) {
            return;
        }
        Rectangle textBounds = SwingUtilities.convertRectangle(this.myLabel.getParent(), this.myLabel.getBounds(), this);
        if (this.getLayeredIcon().isLayerEnabled(1)) {
            int top = (this.getSize().height - this.myOverlayedIcon.getIconHeight()) / 2;
            this.myOverlayedIcon.paintIcon(this, g, textBounds.x - this.myOverlayedIcon.getIconWidth() / 2, top);
        }
    }

    public void setTabActionsAutoHide(boolean autoHide) {
        if (this.myActionPanel == null || this.myActionPanel.isAutoHide() == autoHide) {
            return;
        }
        this.myActionPanel.setAutoHide(autoHide);
    }

    public void toggleShowActions(boolean show) {
        if (this.myActionPanel != null) {
            this.myActionPanel.toggleShowActtions(show);
        }
    }

    @Override
    public String toString() {
        return this.myInfo.getText();
    }

    public void setTabEnabled(boolean enabled) {
        this.myLabel.setEnabled(enabled);
    }

    public BufferedImage getInactiveStateImage(Rectangle effectiveBounds) {
        BufferedImage img = null;
        if (this.myLastPaintedInactiveImageBounds != null && this.myLastPaintedInactiveImageBounds.getSize().equals(effectiveBounds.getSize())) {
            img = this.myInactiveStateImage;
        } else {
            this.setInactiveStateImage(null);
        }
        this.myLastPaintedInactiveImageBounds = effectiveBounds;
        return img;
    }

    public void setInactiveStateImage(BufferedImage img) {
        if (this.myInactiveStateImage != null && img != this.myInactiveStateImage) {
            this.myInactiveStateImage.flush();
        }
        this.myInactiveStateImage = img;
    }
}

