/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.Disposable;
import com.intellij.util.ui.Animator;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;

public abstract class AnimatedIcon
extends JComponent
implements Disposable {
    private Icon[] myIcons;
    private Dimension myPrefSize = new Dimension();
    private int myCurrentIconIndex;
    private Icon myPassiveIcon;
    private Icon myEmptyPassiveIcon;
    private boolean myPaintPassive = true;
    private boolean myRunning = true;
    protected Animator myAnimator;
    private final String myName;
    private boolean myLastPaintWasRunning;
    private boolean myPaintingBgNow;

    protected AnimatedIcon(String name) {
        this.myName = name;
    }

    protected final void init(Icon[] icons, Icon passiveIcon, int cycleLength, int interCycleGap, int maxRepeatCount) {
        this.myIcons = icons;
        this.myPassiveIcon = passiveIcon;
        this.myPrefSize = new Dimension();
        for (Icon each : icons) {
            this.myPrefSize.width = Math.max(each.getIconWidth(), this.myPrefSize.width);
            this.myPrefSize.height = Math.max(each.getIconHeight(), this.myPrefSize.height);
        }
        this.myPrefSize.width = Math.max(passiveIcon.getIconWidth(), this.myPrefSize.width);
        this.myPrefSize.height = Math.max(passiveIcon.getIconHeight(), this.myPrefSize.height);
        UIUtil.removeQuaquaVisualMarginsIn((Component)this);
        this.myAnimator = new Animator(this.myName, icons.length, cycleLength, true, interCycleGap, maxRepeatCount){

            @Override
            public void paintNow(float frame, float totalFrames, float cycle) {
                AnimatedIcon.this.myCurrentIconIndex = (int)frame;
                AnimatedIcon.this.paintImmediately(0, 0, AnimatedIcon.this.getWidth(), AnimatedIcon.this.getHeight());
            }

            @Override
            protected void onAnimationMaxCycleReached() throws InterruptedException {
                AnimatedIcon.this.onAnimationMaxCycleReached();
            }

            @Override
            public boolean isAnimated() {
                return AnimatedIcon.this.isAnimated();
            }
        };
        this.myEmptyPassiveIcon = icons.length > 0 ? new EmptyIcon(icons[0]) : new EmptyIcon(0);
        this.setOpaque(false);
    }

    public void setPaintPassiveIcon(boolean paintPassive) {
        this.myPaintPassive = paintPassive;
    }

    protected void onAnimationMaxCycleReached() throws InterruptedException {
    }

    private boolean ensureAnimation(boolean running) {
        boolean changes;
        boolean bl = changes = this.myAnimator.isRunning() != running;
        if (running) {
            this.myAnimator.resume();
        } else {
            this.myAnimator.suspend();
        }
        return changes;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.myRunning) {
            this.ensureAnimation(true);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.ensureAnimation(false);
    }

    public void resume() {
        this.myRunning = true;
        this.ensureAnimation(true);
    }

    public void suspend() {
        this.myRunning = false;
        if (this.ensureAnimation(false)) {
            this.repaint();
        }
    }

    public void dispose() {
        this.myAnimator.dispose();
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        return new Dimension(this.myPrefSize.width + insets.left + insets.right, this.myPrefSize.height + insets.top + insets.bottom);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.myPaintingBgNow) {
            return;
        }
        if (this.isOpaque()) {
            Container parent = this.getParent();
            Component opaque = null;
            if (parent instanceof JComponent) {
                opaque = (JComponent)UIUtil.findNearestOpaque((JComponent)((JComponent)parent));
            }
            Color bg = opaque != null ? opaque.getBackground() : UIManager.getColor("Panel.background");
            g.setColor(bg);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        Icon icon = this.myAnimator.isRunning() ? this.myIcons[this.myCurrentIconIndex] : this.getPassiveIcon();
        Dimension size = this.getSize();
        int x = (size.width - icon.getIconWidth()) / 2;
        int y = (size.height - icon.getIconHeight()) / 2;
        this.paintIcon(g, icon, x, y);
        this.myLastPaintWasRunning = this.myAnimator.isRunning();
    }

    protected void paintIcon(Graphics g, Icon icon, int x, int y) {
        icon.paintIcon(this, g, x, y);
    }

    protected Icon getPassiveIcon() {
        return this.myPaintPassive ? this.myPassiveIcon : this.myEmptyPassiveIcon;
    }

    public boolean isRunning() {
        return this.myAnimator.isRunning();
    }

    public boolean isAnimated() {
        return true;
    }

    @Override
    public String toString() {
        return this.myName + " isRunning=" + this.myRunning + " isOpaque=" + this.isOpaque() + " paintPassive=" + this.myPaintPassive;
    }
}

