/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.xml.AnnotatedElement;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.JavaMethodSignature;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.jetbrains.annotations.NonNls;

public final class JavaMethod
implements AnnotatedElement {
    public static final JavaMethod[] EMPTY_ARRAY = new JavaMethod[0];
    private static final FactoryMap<JavaMethodSignature, FactoryMap<Class, JavaMethod>> ourMethods = new FactoryMap<JavaMethodSignature, FactoryMap<Class, JavaMethod>>(){

        protected FactoryMap<Class, JavaMethod> create(final JavaMethodSignature signature) {
            return new FactoryMap<Class, JavaMethod>(){

                protected JavaMethod create(Class key) {
                    return new JavaMethod(key, signature);
                }
            };
        }
    };
    private final JavaMethodSignature mySignature;
    private final Class myDeclaringClass;
    private final Method myMethod;
    private FactoryMap<Class, Annotation> myAnnotationsMap = new ConcurrentFactoryMap<Class, Annotation>(){

        protected Annotation create(Class key) {
            return JavaMethod.this.mySignature.findAnnotation(key, JavaMethod.this.myDeclaringClass);
        }
    };

    private JavaMethod(Class declaringClass, JavaMethodSignature signature) {
        this.mySignature = signature;
        this.myMethod = signature.findMethod(declaringClass);
        assert (this.myMethod != null) : "No method " + signature + " in class " + declaringClass;
        this.myDeclaringClass = this.myMethod.getDeclaringClass();
    }

    public final Class getDeclaringClass() {
        return this.myDeclaringClass;
    }

    public final JavaMethodSignature getSignature() {
        return this.mySignature;
    }

    public final Method getMethod() {
        return this.myMethod;
    }

    public final Type[] getGenericParameterTypes() {
        return this.myMethod.getGenericParameterTypes();
    }

    public final Type getGenericReturnType() {
        return this.myMethod.getGenericReturnType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JavaMethod getMethod(Class declaringClass, JavaMethodSignature signature) {
        FactoryMap<JavaMethodSignature, FactoryMap<Class, JavaMethod>> factoryMap = ourMethods;
        synchronized (factoryMap) {
            return (JavaMethod)((FactoryMap)ourMethods.get((Object)signature)).get((Object)declaringClass);
        }
    }

    public static JavaMethod getMethod(Class declaringClass, Method method) {
        return JavaMethod.getMethod(declaringClass, JavaMethodSignature.getSignature(method));
    }

    public final Object invoke(Object o, Object ... args) {
        return DomReflectionUtil.invokeMethod(this.myMethod, o, args);
    }

    public String toString() {
        return "JavaMethod: " + this.myMethod.toString();
    }

    @NonNls
    public final String getName() {
        return this.myMethod.getName();
    }

    @Override
    public final <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)((Annotation)this.myAnnotationsMap.get(annotationClass));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaMethod)) {
            return false;
        }
        JavaMethod that = (JavaMethod)o;
        if (!this.myDeclaringClass.equals(that.myDeclaringClass)) {
            return false;
        }
        return this.mySignature.equals(that.mySignature);
    }

    public int hashCode() {
        int result = this.mySignature.hashCode();
        result = 31 * result + this.myDeclaringClass.hashCode();
        return result;
    }

    public final Class getReturnType() {
        return this.myMethod.getReturnType();
    }

    public Class<?>[] getParameterTypes() {
        return this.myMethod.getParameterTypes();
    }
}

