/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

public class GrClassReferenceType
extends PsiClassType {
    private final GrCodeReferenceElement myReferenceElement;

    public GrClassReferenceType(GrCodeReferenceElement referenceElement) {
        super(LanguageLevel.JDK_1_5);
        this.myReferenceElement = referenceElement;
    }

    public GrClassReferenceType(GrCodeReferenceElement referenceElement, LanguageLevel languageLevel) {
        super(languageLevel);
        this.myReferenceElement = referenceElement;
    }

    @Nullable
    public PsiClass resolve() {
        GroovyResolveResult[] results = this.multiResolve();
        if (results.length == 1) {
            PsiElement only = results[0].getElement();
            return only instanceof PsiClass ? (PsiClass)only : null;
        }
        return null;
    }

    private GroovyResolveResult[] multiResolve() {
        return this.myReferenceElement.multiResolve(false);
    }

    public String getClassName() {
        return this.myReferenceElement.getReferenceName();
    }

    @NotNull
    public PsiType[] getParameters() {
        if (PsiType.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/GrClassReferenceType.getParameters must not return null");
        }
        return PsiType.EMPTY_ARRAY;
    }

    @NotNull
    public PsiClassType.ClassResolveResult resolveGenerics() {
        PsiClassType.ClassResolveResult classResolveResult = new PsiClassType.ClassResolveResult(){

            public PsiClass getElement() {
                return GrClassReferenceType.this.resolve();
            }

            public PsiSubstitutor getSubstitutor() {
                GroovyResolveResult[] results = GrClassReferenceType.this.multiResolve();
                if (results.length != 1) {
                    return PsiSubstitutor.UNKNOWN;
                }
                return results[0].getSubstitutor();
            }

            public boolean isPackagePrefixPackageReference() {
                return false;
            }

            public boolean isAccessible() {
                GroovyResolveResult[] results;
                for (GroovyResolveResult result : results = GrClassReferenceType.this.multiResolve()) {
                    if (!result.isAccessible()) continue;
                    return true;
                }
                return false;
            }

            public boolean isStaticsScopeCorrect() {
                return true;
            }

            public PsiElement getCurrentFileResolveScope() {
                return null;
            }

            public boolean isValidResult() {
                return this.isStaticsScopeCorrect() && this.isAccessible();
            }
        };
        if (classResolveResult == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/GrClassReferenceType.resolveGenerics must not return null");
        }
        return classResolveResult;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiClassType rawType() {
        GrClassReferenceType grClassReferenceType;
        PsiClass clazz = this.resolve();
        if (clazz != null) {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)clazz.getProject()).getElementFactory();
            grClassReferenceType = factory.createType(clazz, factory.createRawSubstitutor((PsiTypeParameterListOwner)clazz));
            if (grClassReferenceType == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/GrClassReferenceType.rawType must not return null");
            return grClassReferenceType;
        }
        grClassReferenceType = this;
        if (grClassReferenceType != null) return grClassReferenceType;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/GrClassReferenceType.rawType must not return null");
    }

    public String getPresentableText() {
        return PsiNameHelper.getPresentableText((String)this.myReferenceElement.getReferenceName(), (PsiType[])this.myReferenceElement.getTypeArguments());
    }

    @Nullable
    public String getCanonicalText() {
        PsiClass resolved = this.resolve();
        if (resolved == null) {
            return null;
        }
        if (resolved instanceof PsiTypeParameter) {
            return resolved.getName();
        }
        String qName = resolved.getQualifiedName();
        if (this.isRaw()) {
            return qName;
        }
        PsiType[] typeArgs = this.myReferenceElement.getTypeArguments();
        if (typeArgs.length == 0) {
            return qName;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(qName).append("<");
        for (int i = 0; i < typeArgs.length; ++i) {
            String typeArgCanonical;
            if (i > 0) {
                builder.append(",");
            }
            if ((typeArgCanonical = typeArgs[i].getCanonicalText()) == null) {
                return null;
            }
            builder.append(typeArgCanonical);
        }
        builder.append(">");
        return builder.toString();
    }

    public String getInternalCanonicalText() {
        return this.getCanonicalText();
    }

    public boolean isValid() {
        return this.myReferenceElement.isValid();
    }

    public boolean equalsToText(@NonNls String text) {
        return text.endsWith(this.getPresentableText()) && text.equals(this.getCanonicalText());
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = this.myReferenceElement.getResolveScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/GrClassReferenceType.getResolveScope must not return null");
        }
        return globalSearchScope;
    }

    @NotNull
    public LanguageLevel getLanguageLevel() {
        LanguageLevel languageLevel = this.myLanguageLevel;
        if (languageLevel == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/GrClassReferenceType.getLanguageLevel must not return null");
        }
        return languageLevel;
    }

    public PsiClassType setLanguageLevel(LanguageLevel languageLevel) {
        GrClassReferenceType copy = new GrClassReferenceType(this.myReferenceElement, languageLevel);
        return copy;
    }
}

