/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs.elements;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import java.util.Set;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrStubElementType;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef.enumConstant.GrEnumConstantImpl;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrFieldStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.elements.GrFieldElementType;
import org.jetbrains.plugins.groovy.lang.psi.stubs.impl.GrFieldStubImpl;

public class GrEnumConstantElementType
extends GrStubElementType<GrFieldStub, GrEnumConstant> {
    public GrEnumConstantElementType() {
        super("Enumeration constant");
    }

    @Override
    public PsiElement createElement(ASTNode node) {
        return new GrEnumConstantImpl(node);
    }

    public GrEnumConstant createPsi(GrFieldStub stub) {
        return new GrEnumConstantImpl(stub);
    }

    public GrFieldStub createStub(GrEnumConstant psi, StubElement parentStub) {
        GrModifierList list = psi.getModifierList();
        String[] annNames = list == null ? ArrayUtil.EMPTY_STRING_ARRAY : (String[])ContainerUtil.map((Object[])list.getAnnotations(), (Function)new Function<GrAnnotation, String>(){

            public String fun(GrAnnotation grAnnotation) {
                GrCodeReferenceElement element = grAnnotation.getClassReference();
                if (element == null) {
                    return null;
                }
                return element.getReferenceName();
            }
        }, (Object[])ArrayUtil.EMPTY_STRING_ARRAY);
        return new GrFieldStubImpl(parentStub, StringRef.fromString((String)psi.getName()), annNames, new Set[0], GroovyElementTypes.ENUM_CONSTANT, GrFieldStubImpl.buildFlags(psi));
    }

    public void serialize(GrFieldStub stub, StubOutputStream dataStream) throws IOException {
        GrEnumConstantElementType.serializeFieldStub(stub, dataStream);
    }

    public GrFieldStub deserialize(StubInputStream dataStream, StubElement parentStub) throws IOException {
        return GrFieldElementType.deserializeFieldStub(dataStream, parentStub);
    }

    protected static void serializeFieldStub(GrFieldStub stub, StubOutputStream dataStream) throws IOException {
        GrFieldElementType.serializeFieldStub(stub, dataStream);
    }

    @Override
    public void indexStub(GrFieldStub stub, IndexSink sink) {
        GrFieldElementType.indexFieldStub(stub, sink);
    }
}

