/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.extractMethod;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrMemberOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.FragmentVariableInfos;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.ReachingDefinitionsCollector;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.VariableInfo;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;
import org.jetbrains.plugins.groovy.refactoring.extractMethod.ExtractMethodInfoHelper;
import org.jetbrains.plugins.groovy.refactoring.extractMethod.ExtractMethodSettings;
import org.jetbrains.plugins.groovy.refactoring.extractMethod.ExtractMethodUtil;
import org.jetbrains.plugins.groovy.refactoring.extractMethod.GroovyExtractMethodDialog;

public class GroovyExtractMethodHandler
implements RefactoringActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.refactoring.extractMethod.GroovyExtractMethodHandler");
    protected static String REFACTORING_NAME = GroovyRefactoringBundle.message("extract.method.title", new Object[0]);
    private String myInvokeResult = "ok";

    protected void showErrorMessage(String message, Project project, Editor editor) {
        Application application = ApplicationManager.getApplication();
        this.myInvokeResult = message;
        if (!application.isUnitTestMode()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.extractMethod");
        }
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/refactoring/extractMethod/GroovyExtractMethodHandler.invoke must not be null");
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        if (!editor.getSelectionModel().hasSelection()) {
            editor.getSelectionModel().selectLineAtCaret();
        }
        this.invokeOnEditor(project, editor, file);
    }

    boolean invokeOnEditor(Project project, Editor editor, PsiFile file) {
        String methodName;
        GrStatement statement;
        GrStatement[] statements;
        GroovyRefactoringUtil.trimSpacesAndComments(editor, file, false);
        if (!(file instanceof GroovyFileBase)) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)GroovyRefactoringBundle.message("only.in.groovy.files", new Object[0]));
            this.showErrorMessage(message, project, editor);
            return false;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        int startOffset = selectionModel.getSelectionStart();
        int endOffset = selectionModel.getSelectionEnd();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiElement[] elements = ExtractMethodUtil.getElementsInOffset(file, startOffset, endOffset);
        if (elements.length == 1 && elements[0] instanceof GrExpression) {
            selectionModel.setSelection(startOffset, elements[0].getTextRange().getEndOffset());
        }
        if ((statements = ExtractMethodUtil.getStatementsByElements(elements)).length == 0) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)GroovyRefactoringBundle.message("selected.block.should.represent.a.statement.set", new Object[0]));
            this.showErrorMessage(message, project, editor);
            return false;
        }
        for (GrStatement statement2 : statements) {
            if (!GroovyRefactoringUtil.isSuperOrThisCall(statement2, true, true)) continue;
            String message = RefactoringBundle.getCannotRefactorMessage((String)GroovyRefactoringBundle.message("selected.block.contains.invocation.of.another.class.constructor", new Object[0]));
            this.showErrorMessage(message, project, editor);
            return false;
        }
        GrMemberOwner owner = ExtractMethodUtil.getMemberOwner(statements[0]);
        GrStatementOwner declarationOwner = ExtractMethodUtil.getDeclarationOwner(statements[0]);
        if (owner == null || declarationOwner == null && !ExtractMethodUtil.isSingleExpression(statements)) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)GroovyRefactoringBundle.message("refactoring.is.not.supported.in.the.current.context", new Object[0]));
            this.showErrorMessage(message, project, editor);
            return false;
        }
        if (declarationOwner == null && ExtractMethodUtil.isSingleExpression(statements) && statements[0] instanceof GrExpression && PsiType.VOID.equals(((GrExpression)statements[0]).getType())) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)GroovyRefactoringBundle.message("selected.expression.has.void.type", new Object[0]));
            this.showErrorMessage(message, project, editor);
            return false;
        }
        ArrayList<GrReturnStatement> returnStatements = new ArrayList<GrReturnStatement>();
        for (GrStatement statement3 : statements) {
            returnStatements.addAll(GroovyRefactoringUtil.findReturnStatements(statement3));
        }
        FragmentVariableInfos fragmentVariableInfos = ReachingDefinitionsCollector.obtainVariableFlowInformation(statements[0], statements[statements.length - 1]);
        VariableInfo[] inputInfos = fragmentVariableInfos.getInputVariableNames();
        VariableInfo[] outputInfos = fragmentVariableInfos.getOutputVariableNames();
        if (outputInfos.length > 1 || outputInfos.length == 1 && returnStatements.size() > 0) {
            String message = GroovyRefactoringBundle.message("multiple.output.values", new Object[0]);
            this.showErrorMessage(message, project, editor);
            return false;
        }
        boolean hasInterruptingStatements = false;
        GrStatement[] arr$ = statements;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && !(hasInterruptingStatements = GroovyRefactoringUtil.hasWrongBreakStatements(statement = arr$[i$]) || GroovyRefactoringUtil.haswrongContinueStatements(statement)); ++i$) {
        }
        boolean hasReturns = returnStatements.size() > 0;
        boolean isReturnStatement = ExtractMethodUtil.isReturnStatement(statements[statements.length - 1], returnStatements);
        if (!isReturnStatement && hasReturns || hasInterruptingStatements) {
            String message = GroovyRefactoringBundle.message("refactoring.is.not.supported.when.return.statement.interrupts.the.execution.flow", new Object[0]);
            this.showErrorMessage(message, project, editor);
            return false;
        }
        VariableInfo outputInfo = outputInfos.length == 0 ? null : outputInfos[0];
        boolean canBeStatic = ExtractMethodUtil.canBeStatic(statements[0]);
        ExtractMethodInfoHelper helper = new ExtractMethodInfoHelper(inputInfos, outputInfo, elements, statements, owner, canBeStatic, isReturnStatement);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            GroovyExtractMethodDialog dialog = this.getDialog(helper);
            if (!dialog.isOK()) {
                return false;
            }
            ExtractMethodSettings settings = dialog.getSettings();
            methodName = settings.getEnteredName();
            helper = settings.getHelper();
        } else {
            methodName = "testMethod";
        }
        assert (methodName != null);
        this.runRefactoring(methodName, helper, owner, declarationOwner, editor, statements[0]);
        return true;
    }

    private void runRefactoring(final String methodName, final @NotNull ExtractMethodInfoHelper helper, final @NotNull GrMemberOwner owner, final GrStatementOwner declarationOwner, final Editor editor, final PsiElement startElement) {
        if (helper == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/refactoring/extractMethod/GroovyExtractMethodHandler.runRefactoring must not be null");
        }
        if (owner == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/plugins/groovy/refactoring/extractMethod/GroovyExtractMethodHandler.runRefactoring must not be null");
        }
        final GrMethod method = ExtractMethodUtil.createMethodByHelper(methodName, helper);
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    GrStatement realStatement;
                    PsiElement anchor = ExtractMethodUtil.calculateAnchorToInsertBefore(owner, startElement);
                    GrMethod newMethod = owner.addMemberDeclaration(method, anchor);
                    ExtractMethodUtil.renameParameterOccurrences(newMethod, helper);
                    PsiUtil.shortenReferences(newMethod);
                    if (declarationOwner != null && !ExtractMethodUtil.isSingleExpression(helper.getStatements())) {
                        GrStatement newStatement = ExtractMethodUtil.createResultStatement(helper, methodName);
                        GrStatement[] statements = helper.getStatements();
                        assert (statements.length > 0);
                        realStatement = declarationOwner.addStatementBefore(newStatement, statements[0]);
                        ExtractMethodUtil.removeOldStatements(declarationOwner, helper);
                        PsiImplUtil.removeNewLineAfter(realStatement);
                    } else {
                        GrMethodCallExpression methodCall = ExtractMethodUtil.createMethodCallByHelper(methodName, helper);
                        GrExpression oldExpr = (GrExpression)helper.getStatements()[0];
                        realStatement = oldExpr.replaceWithExpression(methodCall, true);
                    }
                    PsiUtil.shortenReferences(realStatement);
                    if (editor != null) {
                        PsiDocumentManager.getInstance((Project)helper.getProject()).commitDocument(editor.getDocument());
                        editor.getCaretModel().moveToOffset(ExtractMethodUtil.getCaretOffset(realStatement));
                    }
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        };
        Project project = helper.getProject();
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(runnable);
                editor.getSelectionModel().removeSelection();
            }
        }, REFACTORING_NAME, null);
    }

    private GroovyExtractMethodDialog getDialog(@NotNull ExtractMethodInfoHelper helper) {
        if (helper == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/refactoring/extractMethod/GroovyExtractMethodHandler.getDialog must not be null");
        }
        GroovyExtractMethodDialog dialog = new GroovyExtractMethodDialog(helper, helper.getProject());
        dialog.show();
        return dialog;
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/refactoring/extractMethod/GroovyExtractMethodHandler.invoke must not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/refactoring/extractMethod/GroovyExtractMethodHandler.invoke must not be null");
        }
    }

    public String getInvokeResult() {
        return this.myInvokeResult;
    }
}

