/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.Serializable;
import java.security.Timestamp;
import java.security.cert.CRL;
import java.security.cert.CertPath;
import sun.misc.JavaSecurityCodeSignerAccess;
import sun.misc.SharedSecrets;

public final class CodeSigner
implements Serializable {
    private static final long serialVersionUID = 6819288105193937581L;
    private CertPath signerCertPath;
    private Timestamp timestamp;
    private transient int myhash = -1;
    private transient CRL[] crls;

    public CodeSigner(CertPath certPath, Timestamp timestamp) {
        if (certPath == null) {
            throw new NullPointerException();
        }
        this.signerCertPath = certPath;
        this.timestamp = timestamp;
    }

    public CertPath getSignerCertPath() {
        return this.signerCertPath;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public int hashCode() {
        if (this.myhash == -1) {
            this.myhash = this.timestamp == null ? this.signerCertPath.hashCode() : this.signerCertPath.hashCode() + this.timestamp.hashCode();
        }
        return this.myhash;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof CodeSigner)) {
            return false;
        }
        CodeSigner codeSigner = (CodeSigner)object;
        if (this == codeSigner) {
            return true;
        }
        Timestamp timestamp = codeSigner.getTimestamp();
        if (this.timestamp == null ? timestamp != null : timestamp == null || !this.timestamp.equals(timestamp)) {
            return false;
        }
        return this.signerCertPath.equals(codeSigner.getSignerCertPath());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append("Signer: " + this.signerCertPath.getCertificates().get(0));
        if (this.timestamp != null) {
            stringBuffer.append("timestamp: " + this.timestamp);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    void setCRLs(CRL[] cRLArray) {
        this.crls = cRLArray;
    }

    CRL[] getCRLs() {
        return this.crls;
    }

    static {
        SharedSecrets.setJavaSecurityCodeSignerAccess(new JavaSecurityCodeSignerAccess(){

            @Override
            public void setCRLs(CodeSigner codeSigner, CRL[] cRLArray) {
                codeSigner.setCRLs(cRLArray);
            }

            @Override
            public CRL[] getCRLs(CodeSigner codeSigner) {
                return codeSigner.getCRLs();
            }
        });
    }
}

