/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.io.File;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.SaveActionBase;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class SaveAction
extends SaveActionBase {
    public SaveAction() {
        super(I18n.tr("Save"), "save", I18n.tr("Save the current data."), Shortcut.registerShortcut("system:save", I18n.tr("File: {0}", I18n.tr("Save")), 83, 2));
        this.putValue("help", HelpUtil.ht("/Action/Save"));
    }

    public File getFile(Layer layer) {
        File f = layer.getAssociatedFile();
        if (f != null && !f.exists()) {
            f = null;
        }
        if (f != null && layer instanceof GpxLayer) {
            ExtendedDialog dialog = new ExtendedDialog(Main.parent, I18n.tr("Overwrite"), new String[]{I18n.tr("Overwrite"), I18n.tr("Cancel")});
            dialog.setButtonIcons(new String[]{"save_as.png", "cancel.png"});
            dialog.setContent(I18n.tr("File {0} exists. Overwrite?", f.getName()));
            dialog.showDialog();
            int ret = dialog.getValue();
            if (ret != 1) {
                f = null;
            }
        }
        return f == null ? SaveAction.openFileDialog(layer) : f;
    }
}

