/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.search;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ActionParameter;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.ParameterizedAction;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Filter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Property;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchAction
extends JosmAction
implements ParameterizedAction {
    public static final int DEFAULT_SEARCH_HISTORY_SIZE = 10;
    private static final String SEARCH_EXPRESSION = "searchExpression";
    private static LinkedList<SearchSetting> searchHistory = null;
    private static SearchSetting lastSearch = null;

    public static Collection<SearchSetting> getSearchHistory() {
        if (searchHistory == null) {
            searchHistory = new LinkedList();
            for (String s : Main.pref.getCollection("search.history", Collections.<String>emptyList())) {
                SearchSetting ss = SearchSetting.readFromString(s);
                if (ss == null) continue;
                searchHistory.add(ss);
            }
        }
        return searchHistory;
    }

    public static void saveToHistory(SearchSetting s) {
        if (searchHistory.isEmpty() || !s.equals(searchHistory.getFirst())) {
            searchHistory.addFirst(new SearchSetting(s));
        }
        int maxsize = Main.pref.getInteger("search.history-size", 10);
        while (searchHistory.size() > maxsize) {
            searchHistory.removeLast();
        }
        ArrayList<String> savedHistory = new ArrayList<String>();
        for (SearchSetting item : searchHistory) {
            savedHistory.add(item.writeToString());
        }
        Main.pref.putCollection("search.history", savedHistory);
    }

    public static List<String> getSearchExpressionHistory() {
        ArrayList<String> ret = new ArrayList<String>(SearchAction.getSearchHistory().size());
        for (SearchSetting ss : SearchAction.getSearchHistory()) {
            ret.add(ss.text);
        }
        return ret;
    }

    public SearchAction() {
        super(I18n.tr("Search..."), "dialogs/search", I18n.tr("Search for objects."), Shortcut.registerShortcut("system:find", I18n.tr("Search..."), 70, 1), true);
        this.putValue("help", HelpUtil.ht("/Action/Search"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        SearchAction.search();
    }

    @Override
    public void actionPerformed(ActionEvent e, Map<String, Object> parameters) {
        if (parameters.get(SEARCH_EXPRESSION) == null) {
            this.actionPerformed(e);
        } else {
            SearchAction.searchWithoutHistory((SearchSetting)parameters.get(SEARCH_EXPRESSION));
        }
    }

    public static SearchSetting showSearchDialog(SearchSetting initialValues) {
        if (initialValues == null) {
            initialValues = new SearchSetting();
        }
        JLabel label = new JLabel(initialValues instanceof Filter ? I18n.tr("Please enter a filter string.") : I18n.tr("Please enter a search string."));
        final HistoryComboBox hcbSearchString = new HistoryComboBox();
        hcbSearchString.setText(initialValues.text);
        hcbSearchString.getEditor().selectAll();
        hcbSearchString.getEditor().getEditorComponent().requestFocusInWindow();
        hcbSearchString.setToolTipText(I18n.tr("Enter the search expression"));
        List<String> searchExpressionHistory = SearchAction.getSearchExpressionHistory();
        Collections.reverse(searchExpressionHistory);
        hcbSearchString.setPossibleItems(searchExpressionHistory);
        JRadioButton replace = new JRadioButton(I18n.tr("replace selection"), initialValues.mode == SearchMode.replace);
        JRadioButton add = new JRadioButton(I18n.tr("add to selection"), initialValues.mode == SearchMode.add);
        JRadioButton remove = new JRadioButton(I18n.tr("remove from selection"), initialValues.mode == SearchMode.remove);
        JRadioButton in_selection = new JRadioButton(I18n.tr("find in selection"), initialValues.mode == SearchMode.in_selection);
        ButtonGroup bg = new ButtonGroup();
        bg.add(replace);
        bg.add(add);
        bg.add(remove);
        bg.add(in_selection);
        final JCheckBox caseSensitive = new JCheckBox(I18n.tr("case sensitive"), initialValues.caseSensitive);
        JCheckBox allElements = new JCheckBox(I18n.tr("all objects"), initialValues.allElements);
        allElements.setToolTipText(I18n.tr("Also include incomplete and deleted objects in search."));
        final JCheckBox regexSearch = new JCheckBox(I18n.tr("regular expression"), initialValues.regexSearch);
        JPanel left = new JPanel(new GridBagLayout());
        left.add((Component)label, GBC.eop());
        left.add((Component)hcbSearchString, GBC.eop().fill(2));
        left.add((Component)replace, GBC.eol());
        left.add((Component)add, GBC.eol());
        left.add((Component)remove, GBC.eol());
        left.add((Component)in_selection, GBC.eop());
        left.add((Component)caseSensitive, GBC.eol());
        left.add((Component)allElements, GBC.eol());
        left.add((Component)regexSearch, GBC.eol());
        JPanel right = new JPanel();
        JLabel description = new JLabel("<html><ul><li>" + I18n.tr("<b>Baker Street</b> - ''Baker'' and ''Street'' in any key or name.") + "</li>" + "<li>" + I18n.tr("<b>\"Baker Street\"</b> - ''Baker Street'' in any key or name.") + "</li>" + "<li>" + I18n.tr("<b>name:Bak</b> - ''Bak'' anywhere in the name.") + "</li>" + "<li>" + I18n.tr("<b>type=route</b> - key ''type'' with value exactly ''route''.") + "</li>" + "<li>" + I18n.tr("<b>type=*</b> - key ''type'' with any value. Try also <b>*=value</b>, <b>type=</b>, <b>*=*</b>, <b>*=</b>") + "</li>" + "<li>" + I18n.tr("<b>-name:Bak</b> - not ''Bak'' in the name.") + "</li>" + "<li>" + I18n.tr("<b>oneway?</b> - oneway=yes, true, 1 or on") + "</li>" + "<li>" + I18n.tr("<b>foot:</b> - key=foot set to any value.") + "</li>" + "<li>" + I18n.tr("<u>Special targets:</u>") + "</li>" + "<li>" + I18n.tr("<b>type:</b> - type of the object (<b>node</b>, <b>way</b>, <b>relation</b>)") + "</li>" + "<li>" + I18n.tr("<b>user:</b>... - all objects changed by user") + "</li>" + "<li>" + I18n.tr("<b>user:anonymous</b> - all objects changed by anonymous users") + "</li>" + "<li>" + I18n.tr("<b>id:</b>... - object with given ID (0 for new objects)") + "</li>" + "<li>" + I18n.tr("<b>version:</b>... - object with given version (0 objects without an assigned version)") + "</li>" + "<li>" + I18n.tr("<b>changeset:</b>... - object with given changeset id (0 objects without assigned changeset)") + "</li>" + "<li>" + I18n.tr("<b>nodes:</b>... - object with given number of nodes (nodes:count or nodes:min-max)") + "</li>" + "<li>" + I18n.tr("<b>tags:</b>... - object with given number of tags (tags:count or tags:min-max)") + "</li>" + "<li>" + I18n.tr("<b>role:</b>... - object with given role in a relation") + "</li>" + "<li>" + I18n.tr("<b>timestamp:</b>... -  objects with this timestamp (<b>2009-11-12T14:51:09Z</b>, <b>2009-11-12</b> or <b>T14:51</b> ...)") + "</li>" + "<li>" + I18n.tr("<b>modified</b> - all changed objects") + "</li>" + "<li>" + I18n.tr("<b>selected</b> - all selected objects") + "</li>" + "<li>" + I18n.tr("<b>incomplete</b> - all incomplete objects") + "</li>" + "<li>" + I18n.tr("<b>untagged</b> - all untagged objects") + "</li>" + "<li>" + I18n.tr("<b>child <i>expr</i></b> - all children of objects matching the expression") + "</li>" + "<li>" + I18n.tr("<b>parent <i>expr</i></b> - all parents of objects matching the expression") + "</li>" + "<li>" + I18n.tr("Use <b>|</b> or <b>OR</b> to combine with logical or") + "</li>" + "<li>" + I18n.tr("Use <b>\"</b> to quote operators (e.g. if key contains <b>:</b>)") + "<br/>" + I18n.tr("Within quoted strings the <b>\"</b> and <b>\\</b> characters need to be escaped by a preceding <b>\\</b> (e.g. <b>\\\"</b> and <b>\\\\</b>).") + "</li>" + "<li>" + I18n.tr("Use <b>(</b> and <b>)</b> to group expressions") + "</li>" + "</ul></html>");
        description.setFont(description.getFont().deriveFont(0));
        right.add(description);
        JPanel p = new JPanel();
        p.add(left);
        p.add(right);
        ExtendedDialog dialog = new ExtendedDialog(Main.parent, initialValues instanceof Filter ? I18n.tr("Filter") : I18n.tr("Search"), new String[]{initialValues instanceof Filter ? I18n.tr("Submit filter") : I18n.tr("Start Search"), I18n.tr("Cancel")}){

            protected void buttonAction(int buttonIndex, ActionEvent evt) {
                if (buttonIndex == 0) {
                    try {
                        SearchCompiler.compile(hcbSearchString.getText(), caseSensitive.isSelected(), regexSearch.isSelected());
                        super.buttonAction(buttonIndex, evt);
                    }
                    catch (SearchCompiler.ParseError e) {
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr("Search expression is not valid: \n\n {0}", e.getMessage()), I18n.tr("Invalid search expression"), 0);
                    }
                } else {
                    super.buttonAction(buttonIndex, evt);
                }
            }
        };
        dialog.setButtonIcons(new String[]{"dialogs/search.png", "cancel.png"});
        dialog.configureContextsensitiveHelp("/Action/Search", true);
        dialog.setContent(p);
        dialog.showDialog();
        int result = dialog.getValue();
        if (result != 1) {
            return null;
        }
        SearchMode mode = replace.isSelected() ? SearchMode.replace : (add.isSelected() ? SearchMode.add : (remove.isSelected() ? SearchMode.remove : SearchMode.in_selection));
        initialValues.text = hcbSearchString.getText();
        initialValues.mode = mode;
        initialValues.caseSensitive = caseSensitive.isSelected();
        initialValues.allElements = allElements.isSelected();
        initialValues.regexSearch = regexSearch.isSelected();
        return initialValues;
    }

    public static void search() {
        SearchSetting se = SearchAction.showSearchDialog(lastSearch);
        if (se != null) {
            SearchAction.searchWithHistory(se);
        }
    }

    public static void searchWithHistory(SearchSetting s) {
        SearchAction.saveToHistory(s);
        lastSearch = new SearchSetting(s);
        SearchAction.search(s);
    }

    public static void searchWithoutHistory(SearchSetting s) {
        lastSearch = new SearchSetting(s);
        SearchAction.search(s);
    }

    public static int getSelection(SearchSetting s, Collection<OsmPrimitive> sel, Function f) {
        int foundMatches = 0;
        try {
            String searchText = s.text;
            SearchCompiler.Match matcher = SearchCompiler.compile(searchText, s.caseSensitive, s.regexSearch);
            if (s.mode == SearchMode.replace) {
                sel.clear();
            }
            Collection<OsmPrimitive> all = s.allElements ? Main.main.getCurrentDataSet().allPrimitives() : Main.main.getCurrentDataSet().allNonDeletedCompletePrimitives();
            for (OsmPrimitive osm : all) {
                if (s.mode == SearchMode.replace) {
                    if (!matcher.match(osm)) continue;
                    sel.add(osm);
                    ++foundMatches;
                    continue;
                }
                if (s.mode == SearchMode.add && !f.isSomething(osm).booleanValue() && matcher.match(osm)) {
                    sel.add(osm);
                    ++foundMatches;
                    continue;
                }
                if (s.mode == SearchMode.remove && f.isSomething(osm).booleanValue() && matcher.match(osm)) {
                    sel.remove(osm);
                    ++foundMatches;
                    continue;
                }
                if (s.mode != SearchMode.in_selection || !f.isSomething(osm).booleanValue() || matcher.match(osm)) continue;
                sel.remove(osm);
                ++foundMatches;
            }
        }
        catch (SearchCompiler.ParseError e) {
            JOptionPane.showMessageDialog(Main.parent, e.getMessage(), I18n.tr("Error"), 0);
        }
        return foundMatches;
    }

    public static void getSelection(SearchSetting s, Collection<OsmPrimitive> all, Property<OsmPrimitive, Boolean> p) {
        try {
            String searchText = s.text;
            if (s instanceof Filter && ((Filter)s).inverted) {
                searchText = String.format("-(%s)", searchText);
            }
            SearchCompiler.Match matcher = SearchCompiler.compile(searchText, s.caseSensitive, s.regexSearch);
            for (OsmPrimitive osm : all) {
                if (s.mode == SearchMode.replace) {
                    if (matcher.match(osm)) {
                        p.set(osm, true);
                        continue;
                    }
                    p.set(osm, false);
                    continue;
                }
                if (s.mode == SearchMode.add && !p.get(osm).booleanValue() && matcher.match(osm)) {
                    p.set(osm, true);
                    continue;
                }
                if (s.mode == SearchMode.remove && p.get(osm).booleanValue() && matcher.match(osm)) {
                    p.set(osm, false);
                    continue;
                }
                if (s.mode != SearchMode.in_selection || !p.get(osm).booleanValue() || matcher.match(osm)) continue;
                p.set(osm, false);
            }
        }
        catch (SearchCompiler.ParseError e) {
            JOptionPane.showMessageDialog(Main.parent, e.getMessage(), I18n.tr("Error"), 0);
        }
    }

    public static void search(String search, SearchMode mode) {
        SearchAction.search(new SearchSetting(search, mode, false, false, false));
    }

    public static void search(SearchSetting s) {
        final DataSet ds = Main.main.getCurrentDataSet();
        HashSet<OsmPrimitive> sel = new HashSet<OsmPrimitive>(ds.getSelected());
        int foundMatches = SearchAction.getSelection(s, sel, new Function(){

            public Boolean isSomething(OsmPrimitive o) {
                return ds.isSelected(o);
            }
        });
        ds.setSelected(sel);
        if (foundMatches == 0) {
            String msg = null;
            if (s.mode == SearchMode.replace) {
                msg = I18n.tr("No match found for ''{0}''", s.text);
            } else if (s.mode == SearchMode.add) {
                msg = I18n.tr("Nothing added to selection by searching for ''{0}''", s.text);
            } else if (s.mode == SearchMode.remove) {
                msg = I18n.tr("Nothing removed from selection by searching for ''{0}''", s.text);
            } else if (s.mode == SearchMode.in_selection) {
                msg = I18n.tr("Nothing found in selection by searching for ''{0}''", s.text);
            }
            Main.map.statusLine.setHelpText(msg);
            JOptionPane.showMessageDialog(Main.parent, msg, I18n.tr("Warning"), 2);
        } else {
            Main.map.statusLine.setHelpText(I18n.tr("Found {0} matches", foundMatches));
        }
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.getEditLayer() != null);
    }

    @Override
    public List<ActionParameter<?>> getActionParameters() {
        return Collections.singletonList(new ActionParameter.SearchSettingsActionParameter(SEARCH_EXPRESSION));
    }

    public static class SearchSetting {
        public String text;
        public SearchMode mode;
        public boolean caseSensitive;
        public boolean regexSearch;
        public boolean allElements;

        public SearchSetting() {
            this("", SearchMode.replace, false, false, false);
        }

        public SearchSetting(String text, SearchMode mode, boolean caseSensitive, boolean regexSearch, boolean allElements) {
            this.caseSensitive = caseSensitive;
            this.regexSearch = regexSearch;
            this.allElements = allElements;
            this.mode = mode;
            this.text = text;
        }

        public SearchSetting(SearchSetting original) {
            this(original.text, original.mode, original.caseSensitive, original.regexSearch, original.allElements);
        }

        public String toString() {
            String cs = this.caseSensitive ? I18n.trc("search", "CS") : I18n.trc("search", "CI");
            String rx = this.regexSearch ? ", " + I18n.trc("search", "RX") : "";
            String all = this.allElements ? ", " + I18n.trc("search", "A") : "";
            return "\"" + this.text + "\" (" + cs + rx + all + ", " + (Object)((Object)this.mode) + ")";
        }

        public boolean equals(Object other) {
            if (!(other instanceof SearchSetting)) {
                return false;
            }
            SearchSetting o = (SearchSetting)other;
            return o.caseSensitive == this.caseSensitive && o.regexSearch == this.regexSearch && o.allElements == this.allElements && o.mode.equals((Object)this.mode) && o.text.equals(this.text);
        }

        public int hashCode() {
            return this.text.hashCode();
        }

        public static SearchSetting readFromString(String s) {
            if (s.length() == 0) {
                return null;
            }
            SearchSetting result = new SearchSetting();
            int index = 1;
            result.mode = SearchMode.fromCode(s.charAt(0));
            if (result.mode == null) {
                result.mode = SearchMode.replace;
                index = 0;
            }
            while (index < s.length()) {
                if (s.charAt(index) == 'C') {
                    result.caseSensitive = true;
                } else if (s.charAt(index) == 'R') {
                    result.regexSearch = true;
                } else if (s.charAt(index) == 'A') {
                    result.allElements = true;
                } else {
                    if (s.charAt(index) == ' ') break;
                    System.out.println("Uknown char in SearchSettings: " + s);
                    break;
                }
                ++index;
            }
            if (index < s.length() && s.charAt(index) == ' ') {
                ++index;
            }
            result.text = s.substring(index);
            return result;
        }

        public String writeToString() {
            if (this.text == null || this.text.length() == 0) {
                return "";
            }
            StringBuilder result = new StringBuilder();
            result.append(this.mode.getCode());
            if (this.caseSensitive) {
                result.append('C');
            }
            if (this.regexSearch) {
                result.append('R');
            }
            if (this.allElements) {
                result.append('A');
            }
            result.append(' ');
            result.append(this.text);
            return result.toString();
        }
    }

    public static interface Function {
        public Boolean isSomething(OsmPrimitive var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchMode {
        replace('R'),
        add('A'),
        remove('D'),
        in_selection('S');

        private final char code;

        private SearchMode(char code) {
            this.code = code;
        }

        public char getCode() {
            return this.code;
        }

        public static SearchMode fromCode(char code) {
            for (SearchMode mode : SearchMode.values()) {
                if (mode.getCode() != code) continue;
                return mode;
            }
            return null;
        }
    }
}

