/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint.relations;

import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.NavigatableComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Multipolygon {
    private final NavigatableComponent nc;
    private final List<Way> innerWays = new ArrayList<Way>();
    private final List<Way> outerWays = new ArrayList<Way>();
    private final List<PolyData> innerPolygons = new ArrayList<PolyData>();
    private final List<PolyData> outerPolygons = new ArrayList<PolyData>();
    private final List<PolyData> combinedPolygons = new ArrayList<PolyData>();

    public Multipolygon(NavigatableComponent nc) {
        this.nc = nc;
    }

    public void load(Relation r) {
        for (RelationMember m : r.getMembers()) {
            Way w;
            if (!m.getMember().isDrawable() || !m.isWay() || (w = m.getWay()).getNodesCount() < 2) continue;
            if ("inner".equals(m.getRole())) {
                this.getInnerWays().add(w);
                continue;
            }
            if ("outer".equals(m.getRole())) {
                this.getOuterWays().add(w);
                continue;
            }
            if (m.hasRole()) continue;
            this.getOuterWays().add(w);
        }
        this.createPolygons(this.innerWays, this.innerPolygons);
        this.createPolygons(this.outerWays, this.outerPolygons);
        if (!this.outerPolygons.isEmpty()) {
            this.addInnerToOuters();
        }
    }

    private void createPolygons(List<Way> ways, List<PolyData> result) {
        ArrayList<Way> waysToJoin = new ArrayList<Way>();
        for (Way way : ways) {
            if (way.isClosed()) {
                result.add(new PolyData(this.nc, way.getNodes(), way.isSelected()));
                continue;
            }
            waysToJoin.add(way);
        }
        for (JoinedWay jw : Multipolygon.joinWays(waysToJoin)) {
            result.add(new PolyData(this.nc, jw));
        }
    }

    public static Collection<JoinedWay> joinWays(Collection<Way> join) {
        ArrayList<JoinedWay> res = new ArrayList<JoinedWay>();
        Way[] joinArray = join.toArray(new Way[join.size()]);
        int left = join.size();
        while (left != 0) {
            Way w = null;
            boolean selected = false;
            List<Node> n = null;
            boolean joined = true;
            while (joined && left != 0) {
                joined = false;
                for (int i = 0; i < joinArray.length && left != 0; ++i) {
                    int nl;
                    if (joinArray[i] == null) continue;
                    Way c = joinArray[i];
                    if (w == null) {
                        w = c;
                        selected = w.isSelected();
                        joinArray[i] = null;
                        --left;
                        continue;
                    }
                    int mode = 0;
                    int cl = c.getNodesCount() - 1;
                    if (n == null) {
                        nl = w.getNodesCount() - 1;
                        if (w.getNode(nl) == c.getNode(0)) {
                            mode = 21;
                        } else if (w.getNode(nl) == c.getNode(cl)) {
                            mode = 22;
                        } else if (w.getNode(0) == c.getNode(0)) {
                            mode = 11;
                        } else if (w.getNode(0) == c.getNode(cl)) {
                            mode = 12;
                        }
                    } else {
                        nl = n.size() - 1;
                        if (n.get(nl) == c.getNode(0)) {
                            mode = 21;
                        } else if (n.get(0) == c.getNode(cl)) {
                            mode = 12;
                        } else if (n.get(0) == c.getNode(0)) {
                            mode = 11;
                        } else if (n.get(nl) == c.getNode(cl)) {
                            mode = 22;
                        }
                    }
                    if (mode == 0) continue;
                    joinArray[i] = null;
                    joined = true;
                    if (c.isSelected()) {
                        selected = true;
                    }
                    --left;
                    if (n == null) {
                        n = w.getNodes();
                    }
                    n.remove(mode == 21 || mode == 22 ? nl : 0);
                    if (mode == 21) {
                        n.addAll(c.getNodes());
                        continue;
                    }
                    if (mode == 12) {
                        n.addAll(0, c.getNodes());
                        continue;
                    }
                    if (mode == 22) {
                        for (Node node : c.getNodes()) {
                            n.add(nl, node);
                        }
                        continue;
                    }
                    for (Node node : c.getNodes()) {
                        n.add(0, node);
                    }
                }
            }
            if (n == null) {
                n = w.getNodes();
            }
            res.add(new JoinedWay(n, selected));
        }
        return res;
    }

    public PolyData findOuterPolygon(PolyData inner, List<PolyData> outerPolygons) {
        PolyData result = null;
        Rectangle innerBox = inner.getBounds();
        PolyData insidePolygon = null;
        PolyData intersectingPolygon = null;
        int insideCount = 0;
        int intersectingCount = 0;
        for (PolyData outer : outerPolygons) {
            if (outer.getBounds().contains(innerBox)) {
                insidePolygon = outer;
                ++insideCount;
                continue;
            }
            if (!outer.getBounds().intersects(innerBox)) continue;
            intersectingPolygon = outer;
            ++intersectingCount;
        }
        if (insideCount == 1) {
            return insidePolygon;
        }
        if (intersectingCount == 1) {
            return intersectingPolygon;
        }
        for (PolyData combined : outerPolygons) {
            PolyData.Intersection c = combined.contains(inner.poly);
            if (c == PolyData.Intersection.OUTSIDE || result != null && result.contains(combined.poly) == PolyData.Intersection.INSIDE) continue;
            result = combined;
        }
        return result;
    }

    private void addInnerToOuters() {
        if (this.innerPolygons.isEmpty()) {
            this.combinedPolygons.addAll(this.outerPolygons);
        } else if (this.outerPolygons.size() == 1) {
            PolyData combinedOuter = new PolyData(this.outerPolygons.get(0));
            for (PolyData inner : this.innerPolygons) {
                combinedOuter.addInner(inner.poly);
            }
            this.combinedPolygons.add(combinedOuter);
        } else {
            for (PolyData outer : this.outerPolygons) {
                this.combinedPolygons.add(new PolyData(outer));
            }
            for (PolyData pdInner : this.innerPolygons) {
                PolyData o = this.findOuterPolygon(pdInner, this.combinedPolygons);
                if (o == null) {
                    o = this.outerPolygons.get(0);
                }
                o.addInner(pdInner.poly);
            }
        }
    }

    public List<Way> getOuterWays() {
        return this.outerWays;
    }

    public List<Way> getInnerWays() {
        return this.innerWays;
    }

    public List<PolyData> getInnerPolygons() {
        return this.innerPolygons;
    }

    public List<PolyData> getOuterPolygons() {
        return this.outerPolygons;
    }

    public List<PolyData> getCombinedPolygons() {
        return this.combinedPolygons;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PolyData {
        public Polygon poly = new Polygon();
        public final boolean selected;
        private Point lastP;
        private Rectangle bounds;

        public PolyData(NavigatableComponent nc, JoinedWay joinedWay) {
            this(nc, joinedWay.getNodes(), joinedWay.isSelected());
        }

        public PolyData(NavigatableComponent nc, List<Node> nodes, boolean selected) {
            this.selected = selected;
            Point p = null;
            for (Node n : nodes) {
                p = nc.getPoint(n);
                this.poly.addPoint(p.x, p.y);
            }
            if (!nodes.get(0).equals(nodes.get(nodes.size() - 1))) {
                p = nc.getPoint(nodes.get(0));
                this.poly.addPoint(p.x, p.y);
            }
            this.lastP = p;
        }

        public PolyData(PolyData copy) {
            this.poly = new Polygon(copy.poly.xpoints, copy.poly.ypoints, copy.poly.npoints);
            this.selected = copy.selected;
            this.lastP = copy.lastP;
        }

        public Intersection contains(Polygon p) {
            int contains = p.npoints;
            for (int i = 0; i < p.npoints; ++i) {
                if (!this.poly.contains(p.xpoints[i], p.ypoints[i])) continue;
                --contains;
            }
            if (contains == 0) {
                return Intersection.INSIDE;
            }
            if (contains == p.npoints) {
                return Intersection.OUTSIDE;
            }
            return Intersection.CROSSING;
        }

        public void addInner(Polygon p) {
            for (int i = 0; i < p.npoints; ++i) {
                this.poly.addPoint(p.xpoints[i], p.ypoints[i]);
            }
            this.poly.addPoint(this.lastP.x, this.lastP.y);
        }

        public Polygon get() {
            return this.poly;
        }

        public Rectangle getBounds() {
            if (this.bounds == null) {
                this.bounds = this.poly.getBounds();
            }
            return this.bounds;
        }

        public String toString() {
            return "Points: " + this.poly.npoints + " Selected: " + this.selected;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Intersection {
            INSIDE,
            OUTSIDE,
            CROSSING;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JoinedWay {
        private final List<Node> nodes;
        private final boolean selected;

        public JoinedWay(List<Node> nodes, boolean selected) {
            this.nodes = nodes;
            this.selected = selected;
        }

        public List<Node> getNodes() {
            return this.nodes;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public boolean isClosed() {
            return this.nodes.isEmpty() || this.nodes.get(this.nodes.size() - 1).equals(this.nodes.get(0));
        }
    }
}

