/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.preferences;

import org.openstreetmap.josm.Main;

public class IntegerProperty {
    private final String key;
    private final int defaultValue;

    public IntegerProperty(String key, int defaultValue) {
        this.key = key;
        this.defaultValue = defaultValue;
    }

    public int get() {
        return Main.pref.getInteger(this.getKey(), this.getDefaultValue());
    }

    public boolean put(int value) {
        return Main.pref.putInteger(this.getKey(), value);
    }

    public boolean parseAndPut(String value) {
        Integer intVal;
        try {
            intVal = Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return this.put(intVal);
    }

    public String getKey() {
        return this.key;
    }

    public int getDefaultValue() {
        return this.defaultValue;
    }
}

