/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolverModel;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolverTable;
import org.openstreetmap.josm.tools.I18n;

public class TagConflictResolver
extends JPanel {
    private TagConflictResolverModel model = new TagConflictResolverModel();
    private JCheckBox cbShowTagsWithConflictsOnly;
    private JCheckBox cbShowTagsWithMultiValuesOnly;

    protected JPanel buildInfoPanel() {
        JPanel pnl = new JPanel();
        pnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pnl.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 1;
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        gc.anchor = 21;
        pnl.add((Component)new JLabel(I18n.tr("<html>Please select the values to keep for the following tags.</html>")), gc);
        gc.gridy = 1;
        gc.fill = 2;
        gc.weighty = 0.0;
        this.cbShowTagsWithConflictsOnly = new JCheckBox(I18n.tr("Show tags with conflicts only"));
        pnl.add((Component)this.cbShowTagsWithConflictsOnly, gc);
        this.cbShowTagsWithMultiValuesOnly = new JCheckBox(I18n.tr("Show tags with multiple values only"));
        pnl.add((Component)this.cbShowTagsWithMultiValuesOnly, gc);
        this.cbShowTagsWithConflictsOnly.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                TagConflictResolver.this.model.setShowTagsWithConflictsOnly(TagConflictResolver.this.cbShowTagsWithConflictsOnly.isSelected());
                TagConflictResolver.this.cbShowTagsWithMultiValuesOnly.setEnabled(TagConflictResolver.this.cbShowTagsWithConflictsOnly.isSelected());
            }
        });
        this.cbShowTagsWithConflictsOnly.setSelected(Main.pref.getBoolean(this.getClass().getName() + ".showTagsWithConflictsOnly", false));
        this.cbShowTagsWithMultiValuesOnly.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                TagConflictResolver.this.model.setShowTagsWithMultiValuesOnly(TagConflictResolver.this.cbShowTagsWithMultiValuesOnly.isSelected());
            }
        });
        this.cbShowTagsWithMultiValuesOnly.setSelected(Main.pref.getBoolean(this.getClass().getName() + ".showTagsWithMultiValuesOnly", false));
        this.cbShowTagsWithMultiValuesOnly.setEnabled(this.cbShowTagsWithConflictsOnly.isSelected());
        return pnl;
    }

    public void rememberPreferences() {
        Main.pref.put(this.getClass().getName() + ".showTagsWithConflictsOnly", this.cbShowTagsWithConflictsOnly.isSelected());
        Main.pref.put(this.getClass().getName() + ".showTagsWithMultiValuesOnly", this.cbShowTagsWithMultiValuesOnly.isSelected());
    }

    protected void build() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.buildInfoPanel(), "North");
        this.add((Component)new JScrollPane(new TagConflictResolverTable(this.model)), "Center");
    }

    public TagConflictResolver() {
        this.build();
    }

    public TagConflictResolverModel getModel() {
        return this.model;
    }
}

