/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DownloadReferrersAction;
import org.openstreetmap.josm.actions.UpdateDataAction;
import org.openstreetmap.josm.actions.UpdateSelectionAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.UpdatePrimitivesTask;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmApiInitializationException;
import org.openstreetmap.josm.io.OsmApiPrimitiveGoneException;
import org.openstreetmap.josm.tools.DateUtils;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public abstract class AbstractUploadTask
extends PleaseWaitRunnable {
    private static final Logger logger = Logger.getLogger(AbstractUploadTask.class.getName());

    public AbstractUploadTask(String title, boolean ignoreException) {
        super(title, ignoreException);
    }

    public AbstractUploadTask(String title, ProgressMonitor progressMonitor, boolean ignoreException) {
        super(title, progressMonitor, ignoreException);
    }

    public AbstractUploadTask(String title) {
        super(title);
    }

    protected void synchronizePrimitive(OsmPrimitiveType type, long id) {
        OsmDataLayer layer = Main.main.getEditLayer();
        if (layer == null) {
            throw new IllegalStateException(I18n.tr("Failed to update primitive with id {0} because current edit layer is null", id));
        }
        OsmPrimitive p = layer.data.getPrimitiveById(id, type);
        if (p == null) {
            throw new IllegalStateException(I18n.tr("Failed to update primitive with id {0} because current edit layer does not include such a primitive", id));
        }
        Main.worker.execute(new UpdatePrimitivesTask(layer, Collections.singleton(p)));
    }

    protected void synchronizeDataSet() {
        UpdateDataAction act = new UpdateDataAction();
        act.actionPerformed(new ActionEvent(this, 0, ""));
    }

    protected void handleUploadConflictForKnownConflict(OsmPrimitiveType primitiveType, long id, String serverVersion, String myVersion) {
        String lbl = "";
        switch (primitiveType) {
            case NODE: {
                lbl = I18n.tr("Synchronize node {0} only", id);
                break;
            }
            case WAY: {
                lbl = I18n.tr("Synchronize way {0} only", id);
                break;
            }
            case RELATION: {
                lbl = I18n.tr("Synchronize relation {0} only", id);
            }
        }
        HelpAwareOptionPane.ButtonSpec[] spec = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(lbl, ImageProvider.get("updatedata"), null, null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Synchronize entire dataset"), ImageProvider.get("updatedata"), null, null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Cancel"), ImageProvider.get("cancel"), null, null)};
        String msg = I18n.tr("<html>Uploading <strong>failed</strong> because the server has a newer version of one<br>of your nodes, ways, or relations.<br>The conflict is caused by the <strong>{0}</strong> with id <strong>{1}</strong>,<br>the server has version {2}, your version is {3}.<br><br>Click <strong>{4}</strong> to synchronize the conflicting primitive only.<br>Click <strong>{5}</strong> to synchronize the entire local dataset with the server.<br>Click <strong>{6}</strong> to abort and continue editing.<br></html>", I18n.tr(primitiveType.getAPIName()), id, serverVersion, myVersion, spec[0].text, spec[1].text, spec[2].text);
        int ret = HelpAwareOptionPane.showOptionDialog(Main.parent, msg, I18n.tr("Conflicts detected"), 0, null, spec, spec[0], "/Concepts/Conflict");
        switch (ret) {
            case 0: {
                this.synchronizePrimitive(primitiveType, id);
                break;
            }
            case 1: {
                this.synchronizeDataSet();
                break;
            }
            default: {
                return;
            }
        }
    }

    protected void handleUploadConflictForUnknownConflict() {
        HelpAwareOptionPane.ButtonSpec[] spec = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Synchronize entire dataset"), ImageProvider.get("updatedata"), null, null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Cancel"), ImageProvider.get("cancel"), null, null)};
        String msg = I18n.tr("<html>Uploading <strong>failed</strong> because the server has a newer version of one<br>of your nodes, ways, or relations.<br><br>Click <strong>{0}</strong> to synchronize the entire local dataset with the server.<br>Click <strong>{1}</strong> to abort and continue editing.<br></html>", spec[0].text, spec[1].text);
        int ret = HelpAwareOptionPane.showOptionDialog(Main.parent, msg, I18n.tr("Conflicts detected"), 0, null, spec, spec[0], HelpUtil.ht("Concepts/Conflict"));
        if (ret == 0) {
            this.synchronizeDataSet();
        }
    }

    protected void handleUploadConflictForClosedChangeset(long changesetId, Date d) {
        String msg = I18n.tr("<html>Uploading <strong>failed</strong> because you have been using<br>changeset {0} which was already closed at {1}.<br>Please upload again with a new or an existing open changeset.</html>", changesetId, new SimpleDateFormat().format(d));
        JOptionPane.showMessageDialog(Main.parent, msg, I18n.tr("Changeset closed"), 0);
    }

    protected void handleUploadConflictForNodeStillInUse(long nodeId, long wayId) {
        HelpAwareOptionPane.ButtonSpec[] options = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Prepare conflict resolution"), ImageProvider.get("ok"), I18n.tr("Click to download all parent ways for node {0}", nodeId), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Cancel"), ImageProvider.get("cancel"), I18n.tr("Click to cancel and to resume editing the map", nodeId), null)};
        String msg = I18n.tr("<html>Uploading <strong>failed</strong> because you tried to delete node {0} which is still in use in way {1}.<br><br>Click <strong>{2}</strong> to download all parent ways of node {0}.<br>If necessary JOSM will create conflicts which you can resolve in the Conflict Resolution Dialog.</html>", nodeId, wayId, options[0].text);
        int ret = HelpAwareOptionPane.showOptionDialog(Main.parent, msg, I18n.tr("Node still in use"), 0, null, options, options[0], "/Action/Upload#NodeStillInUseInWay");
        if (ret != 0) {
            return;
        }
        DownloadReferrersAction.downloadReferrers(Main.map.mapView.getEditLayer(), nodeId, OsmPrimitiveType.NODE);
    }

    protected void handleUploadConflict(OsmApiException e) {
        String pattern = "Version mismatch: Provided (\\d+), server had: (\\d+) of (\\S+) (\\d+)";
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(e.getErrorHeader());
        if (m.matches()) {
            this.handleUploadConflictForKnownConflict(OsmPrimitiveType.from(m.group(3)), Long.parseLong(m.group(4)), m.group(2), m.group(1));
            return;
        }
        pattern = "The changeset (\\d+) was closed at (.*)";
        p = Pattern.compile(pattern);
        m = p.matcher(e.getErrorHeader());
        if (m.matches()) {
            this.handleUploadConflictForClosedChangeset(Long.parseLong(m.group(1)), DateUtils.fromString(m.group(2)));
            return;
        }
        pattern = "Node (\\d+) is still used by way (\\d+).";
        p = Pattern.compile(pattern);
        m = p.matcher(e.getErrorHeader());
        if (m.matches()) {
            this.handleUploadConflictForNodeStillInUse(Long.parseLong(m.group(1)), Long.parseLong(m.group(2)));
            return;
        }
        logger.warning(I18n.tr("Warning: error header \"{0}\" did not match with an expected pattern", e.getErrorHeader()));
        this.handleUploadConflictForUnknownConflict();
    }

    protected void handlePreconditionFailed(OsmApiException e) {
        String pattern = "Precondition failed: Node (\\d+) is still used by way (\\d+).";
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(e.getErrorHeader());
        if (m.matches()) {
            this.handleUploadConflictForNodeStillInUse(Long.parseLong(m.group(1)), Long.parseLong(m.group(2)));
            return;
        }
        logger.warning(I18n.tr("Warning: error header \"{0}\" did not match with an expected pattern", e.getErrorHeader()));
        ExceptionDialogUtil.explainPreconditionFailed(e);
    }

    protected void handleGone(OsmApiPrimitiveGoneException e) {
        if (e.isKnownPrimitive()) {
            new UpdateSelectionAction().handlePrimitiveGoneException(e.getPrimitiveId(), e.getPrimitiveType());
        } else {
            ExceptionDialogUtil.explainGoneForUnknownPrimitive(e);
        }
    }

    protected void handleFailedUpload(Exception e) {
        if (e instanceof OsmApiInitializationException) {
            ExceptionDialogUtil.explainOsmApiInitializationException((OsmApiInitializationException)e);
            return;
        }
        if (e instanceof OsmApiPrimitiveGoneException) {
            this.handleGone((OsmApiPrimitiveGoneException)e);
            return;
        }
        if (e instanceof OsmApiException) {
            OsmApiException ex = (OsmApiException)e;
            if (ex.getResponseCode() == 409) {
                this.handleUploadConflict(ex);
                return;
            }
            if (ex.getResponseCode() == 412) {
                this.handlePreconditionFailed(ex);
                return;
            }
            if (ex.getResponseCode() == 404) {
                ExceptionDialogUtil.explainNotFound(ex);
                return;
            }
        }
        ExceptionDialogUtil.explainException(e);
    }
}

