/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.oauth;

import java.awt.Component;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.openstreetmap.josm.gui.oauth.AuthorizationProcedure;
import org.openstreetmap.josm.tools.I18n;

public class AuthorizationProcedureComboBox
extends JComboBox {
    public AuthorizationProcedureComboBox() {
        this.setModel(new AuthorisationProcedureComboBoxModel());
        this.setRenderer(new AuthorisationProcedureCellRenderer());
        this.setSelectedItem((Object)AuthorizationProcedure.FULLY_AUTOMATIC);
    }

    private static class AuthorisationProcedureCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public AuthorisationProcedureCellRenderer() {
            this.setOpaque(true);
        }

        protected void renderColors(boolean isSelected) {
            if (isSelected) {
                this.setForeground(UIManager.getColor("List.selectionForeground"));
                this.setBackground(UIManager.getColor("List.selectionBackground"));
            } else {
                this.setForeground(UIManager.getColor("List.foreground"));
                this.setBackground(UIManager.getColor("List.background"));
            }
        }

        protected void renderText(AuthorizationProcedure value) {
            switch (value) {
                case FULLY_AUTOMATIC: {
                    this.setText(I18n.tr("Fully automatic"));
                    break;
                }
                case SEMI_AUTOMATIC: {
                    this.setText(I18n.tr("Semi-automatic"));
                    break;
                }
                case MANUALLY: {
                    this.setText(I18n.tr("Manual"));
                }
            }
        }

        protected void renderToolTipText(AuthorizationProcedure value) {
            switch (value) {
                case FULLY_AUTOMATIC: {
                    this.setToolTipText(I18n.tr("<html>Run a fully automatic procedure to get an access token from the OSM website.<br>JOSM accesses the OSM website on behalf of the JOSM user and fully<br>automatically authorizes the user and retrieves an Access Token.</html>"));
                    break;
                }
                case SEMI_AUTOMATIC: {
                    this.setToolTipText(I18n.tr("<html>Run a semi-automatic procedure to get an access token from the OSM website.<br>JOSM submits the standards OAuth requests to get a Request Token and an<br>Access Token. It dispatches the user to the OSM website in an external browser<br>to authenticate itself and to accept the request token submitted by JOSM.</html>"));
                    break;
                }
                case MANUALLY: {
                    this.setToolTipText(I18n.tr("<html>Enter an Access Token manually if it was generated and retrieved outside<br>of JOSM.</html>"));
                }
            }
        }

        public Component getListCellRendererComponent(JList list, Object value, int idx, boolean isSelected, boolean hasFocus) {
            AuthorizationProcedure procedure = (AuthorizationProcedure)((Object)value);
            this.renderColors(isSelected);
            this.renderText(procedure);
            this.renderToolTipText(procedure);
            return this;
        }
    }

    private static class AuthorisationProcedureComboBoxModel
    extends DefaultComboBoxModel {
        private AuthorisationProcedureComboBoxModel() {
        }

        public Object getElementAt(int index) {
            switch (index) {
                case 0: {
                    return AuthorizationProcedure.FULLY_AUTOMATIC;
                }
                case 1: {
                    return AuthorizationProcedure.SEMI_AUTOMATIC;
                }
                case 2: {
                    return AuthorizationProcedure.MANUALLY;
                }
            }
            return null;
        }

        public int getSize() {
            return 3;
        }
    }
}

