/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.oauth;

import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.OAuthProvider;
import oauth.signpost.basic.DefaultOAuthProvider;
import oauth.signpost.exception.OAuthCommunicationException;
import oauth.signpost.exception.OAuthException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.data.oauth.OAuthParameters;
import org.openstreetmap.josm.data.oauth.OAuthToken;
import org.openstreetmap.josm.data.oauth.OsmPrivileges;
import org.openstreetmap.josm.gui.oauth.OsmLoginFailedException;
import org.openstreetmap.josm.gui.oauth.OsmOAuthAuthorizationException;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmTransferCancelledException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsmOAuthAuthorizationClient {
    private static final Logger logger = Logger.getLogger(OsmOAuthAuthorizationClient.class.getName());
    private OAuthParameters oauthProviderParameters;
    private OAuthConsumer consumer;
    private OAuthProvider provider;
    private boolean canceled;
    private HttpURLConnection connection;

    public OsmOAuthAuthorizationClient() {
        this.oauthProviderParameters = OAuthParameters.createDefault();
        this.consumer = this.oauthProviderParameters.buildConsumer();
        this.provider = this.oauthProviderParameters.buildProvider(this.consumer);
    }

    public OsmOAuthAuthorizationClient(OAuthParameters parameters) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(parameters, "parameters");
        this.oauthProviderParameters = new OAuthParameters(parameters);
        this.consumer = this.oauthProviderParameters.buildConsumer();
        this.provider = this.oauthProviderParameters.buildProvider(this.consumer);
    }

    public OsmOAuthAuthorizationClient(OAuthParameters parameters, OAuthToken requestToken) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(parameters, "parameters");
        this.oauthProviderParameters = new OAuthParameters(parameters);
        this.consumer = this.oauthProviderParameters.buildConsumer();
        this.provider = this.oauthProviderParameters.buildProvider(this.consumer);
        this.consumer.setTokenWithSecret(requestToken.getKey(), requestToken.getSecret());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        DefaultOAuthProvider p = (DefaultOAuthProvider)this.provider;
        this.canceled = true;
        if (p != null) {
            try {
                Field f = p.getClass().getDeclaredField("connection");
                f.setAccessible(true);
                HttpURLConnection con = (HttpURLConnection)f.get(p);
                if (con != null) {
                    con.disconnect();
                }
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
                System.err.println(I18n.tr("Warning: failed to cancel running OAuth operation"));
            }
            catch (SecurityException e) {
                e.printStackTrace();
                System.err.println(I18n.tr("Warning: failed to cancel running OAuth operation"));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                System.err.println(I18n.tr("Warning: failed to cancel running OAuth operation"));
            }
        }
        OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
        synchronized (osmOAuthAuthorizationClient) {
            if (this.connection != null) {
                this.connection.disconnect();
            }
        }
    }

    public OAuthToken getRequestToken(ProgressMonitor monitor) throws OsmOAuthAuthorizationException, OsmTransferCancelledException {
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        try {
            monitor.beginTask("");
            monitor.indeterminateSubTask(I18n.tr("Retrieving OAuth Request Token from ''{0}''", this.oauthProviderParameters.getRequestTokenUrl()));
            this.provider.retrieveRequestToken(this.consumer, "");
            OAuthToken oAuthToken = OAuthToken.createToken(this.consumer);
            return oAuthToken;
        }
        catch (OAuthCommunicationException e) {
            if (this.canceled) {
                throw new OsmTransferCancelledException();
            }
            throw new OsmOAuthAuthorizationException(e);
        }
        catch (OAuthException e) {
            if (this.canceled) {
                throw new OsmTransferCancelledException();
            }
            throw new OsmOAuthAuthorizationException(e);
        }
        finally {
            monitor.finishTask();
        }
    }

    public OAuthToken getAccessToken(ProgressMonitor monitor) throws OsmOAuthAuthorizationException, OsmTransferCancelledException {
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        try {
            monitor.beginTask("");
            monitor.indeterminateSubTask(I18n.tr("Retrieving OAuth Access Token from ''{0}''", this.oauthProviderParameters.getAccessTokenUrl()));
            this.provider.retrieveAccessToken(this.consumer, null);
            OAuthToken oAuthToken = OAuthToken.createToken(this.consumer);
            return oAuthToken;
        }
        catch (OAuthCommunicationException e) {
            if (this.canceled) {
                throw new OsmTransferCancelledException();
            }
            throw new OsmOAuthAuthorizationException(e);
        }
        catch (OAuthException e) {
            if (this.canceled) {
                throw new OsmTransferCancelledException();
            }
            throw new OsmOAuthAuthorizationException(e);
        }
        finally {
            monitor.finishTask();
        }
    }

    public String getAuthoriseUrl(OAuthToken requestToken) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.oauthProviderParameters.getAuthoriseUrl()).append("?").append("oauth_token").append("=").append(requestToken.getKey());
        return sb.toString();
    }

    protected String extractOsmSession(HttpURLConnection connection) {
        List<String> setCookies = connection.getHeaderFields().get("Set-Cookie");
        if (setCookies == null) {
            return null;
        }
        for (String setCookie : setCookies) {
            String[] kvPairs = setCookie.split(";");
            if (kvPairs == null || kvPairs.length == 0) continue;
            for (String kvPair : kvPairs) {
                String[] kv = (kvPair = kvPair.trim()).split("=");
                if (kv == null || kv.length != 2 || !kv[0].equals("_osm_session")) continue;
                return kv[1];
            }
        }
        return null;
    }

    protected String buildPostRequest(Map<String, String> parameters) throws OsmOAuthAuthorizationException {
        try {
            StringBuilder sb = new StringBuilder();
            Iterator<Map.Entry<String, String>> it = parameters.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, String> entry = it.next();
                String value = entry.getValue();
                value = value == null ? "" : value;
                sb.append(entry.getKey()).append("=").append(URLEncoder.encode(value, "UTF-8"));
                if (!it.hasNext()) continue;
                sb.append("&");
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new OsmOAuthAuthorizationException(e);
        }
    }

    public String buildOsmLoginUrl() throws OsmOAuthAuthorizationException {
        try {
            URL autUrl = new URL(this.oauthProviderParameters.getAuthoriseUrl());
            URL url = new URL(Main.pref.get("oauth.protocol", "https"), autUrl.getHost(), autUrl.getPort(), "/login");
            return url.toString();
        }
        catch (MalformedURLException e) {
            throw new OsmOAuthAuthorizationException(e);
        }
    }

    protected String buildOsmLogoutUrl() throws OsmOAuthAuthorizationException {
        try {
            URL autUrl = new URL(this.oauthProviderParameters.getAuthoriseUrl());
            URL url = new URL("http", autUrl.getHost(), autUrl.getPort(), "/logout");
            return url.toString();
        }
        catch (MalformedURLException e) {
            throw new OsmOAuthAuthorizationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String fetchOsmWebsiteSessionId() throws OsmOAuthAuthorizationException {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(this.buildOsmLoginUrl()).append("?cookie_test=true");
            URL url = new URL(sb.toString());
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = (HttpURLConnection)url.openConnection();
            }
            this.connection.setRequestMethod("GET");
            this.connection.setDoInput(true);
            this.connection.setDoOutput(false);
            this.setHttpRequestParameters(this.connection);
            this.connection.connect();
            String sessionId = this.extractOsmSession(this.connection);
            if (sessionId == null) {
                throw new OsmOAuthAuthorizationException(I18n.tr("OSM website did not return a session cookie in response to ''{0}'',", url.toString()));
            }
            String string = sessionId;
            return string;
        }
        catch (IOException e) {
            throw new OsmOAuthAuthorizationException(e);
        }
        finally {
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void authenticateOsmSession(String sessionId, String userName, String password) throws OsmLoginFailedException {
        FilterOutputStream dout = null;
        try {
            URL url = new URL(this.buildOsmLoginUrl());
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = (HttpURLConnection)url.openConnection();
            }
            this.connection.setRequestMethod("POST");
            this.connection.setDoInput(true);
            this.connection.setDoOutput(true);
            this.connection.setUseCaches(false);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("user[email]", userName);
            parameters.put("user[password]", password);
            parameters.put("referer", "/");
            parameters.put("commit", "Login");
            String request = this.buildPostRequest(parameters);
            this.connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            this.connection.setRequestProperty("Content-Length", Integer.toString(request.length()));
            this.connection.setRequestProperty("Cookie", "_osm_session=" + sessionId);
            this.connection.setInstanceFollowRedirects(false);
            this.setHttpRequestParameters(this.connection);
            this.connection.connect();
            dout = new DataOutputStream(this.connection.getOutputStream());
            ((DataOutputStream)dout).writeBytes(request);
            ((DataOutputStream)dout).flush();
            dout.close();
            int retCode = this.connection.getResponseCode();
            if (retCode != 302) {
                throw new OsmOAuthAuthorizationException(I18n.tr("Failed to authenticate user ''{0}'' with password ''***'' as OAuth user", userName));
            }
        }
        catch (OsmOAuthAuthorizationException e) {
            throw new OsmLoginFailedException(e.getCause());
        }
        catch (IOException e) {
            throw new OsmLoginFailedException(e);
        }
        finally {
            if (dout != null) {
                try {
                    dout.close();
                }
                catch (IOException e) {}
            }
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logoutOsmSession(String sessionId) throws OsmOAuthAuthorizationException {
        try {
            URL url = new URL(this.buildOsmLogoutUrl());
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = (HttpURLConnection)url.openConnection();
            }
            this.connection.setRequestMethod("GET");
            this.connection.setDoInput(true);
            this.connection.setDoOutput(false);
            this.setHttpRequestParameters(this.connection);
            this.connection.connect();
        }
        catch (MalformedURLException e) {
            throw new OsmOAuthAuthorizationException(e);
        }
        catch (IOException e) {
            throw new OsmOAuthAuthorizationException(e);
        }
        finally {
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendAuthorisationRequest(String sessionId, OAuthToken requestToken, OsmPrivileges privileges) throws OsmOAuthAuthorizationException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("oauth_token", requestToken.getKey());
        parameters.put("oauth_callback", "");
        if (privileges.isAllowWriteApi()) {
            parameters.put("allow_write_api", "yes");
        }
        if (privileges.isAllowWriteGpx()) {
            parameters.put("allow_write_gpx", "yes");
        }
        if (privileges.isAllowReadGpx()) {
            parameters.put("allow_read_gpx", "yes");
        }
        if (privileges.isAllowWritePrefs()) {
            parameters.put("allow_write_prefs", "yes");
        }
        if (privileges.isAllowReadPrefs()) {
            parameters.put("allow_read_prefs", "yes");
        }
        parameters.put("commit", "Save changes");
        String request = this.buildPostRequest(parameters);
        FilterOutputStream dout = null;
        try {
            URL url = new URL(this.oauthProviderParameters.getAuthoriseUrl());
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = (HttpURLConnection)url.openConnection();
            }
            this.connection.setRequestMethod("POST");
            this.connection.setDoInput(true);
            this.connection.setDoOutput(true);
            this.connection.setUseCaches(false);
            this.connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            this.connection.setRequestProperty("Content-Length", Integer.toString(request.length()));
            this.connection.setRequestProperty("Cookie", "_osm_session=" + sessionId);
            this.connection.setInstanceFollowRedirects(false);
            this.setHttpRequestParameters(this.connection);
            this.connection.connect();
            dout = new DataOutputStream(this.connection.getOutputStream());
            ((DataOutputStream)dout).writeBytes(request);
            ((DataOutputStream)dout).flush();
            dout.close();
            int retCode = this.connection.getResponseCode();
            if (retCode != 302) {
                throw new OsmOAuthAuthorizationException(I18n.tr("Failed to authorize OAuth request  ''{0}''", requestToken.getKey()));
            }
        }
        catch (MalformedURLException e) {
            throw new OsmOAuthAuthorizationException(e);
        }
        catch (IOException e) {
            throw new OsmOAuthAuthorizationException(e);
        }
        finally {
            if (dout != null) {
                try {
                    dout.close();
                }
                catch (IOException e) {}
            }
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = null;
            }
        }
    }

    protected void setHttpRequestParameters(HttpURLConnection connection) {
        connection.setRequestProperty("User-Agent", Version.getInstance().getAgentString());
        connection.setRequestProperty("Host", connection.getURL().getHost());
    }

    public void authorise(OAuthToken requestToken, String osmUserName, String osmPassword, OsmPrivileges privileges, ProgressMonitor monitor) throws IllegalArgumentException, OsmOAuthAuthorizationException, OsmTransferCancelledException {
        CheckParameterUtil.ensureParameterNotNull(requestToken, "requestToken");
        CheckParameterUtil.ensureParameterNotNull(osmUserName, "osmUserName");
        CheckParameterUtil.ensureParameterNotNull(osmPassword, "osmPassword");
        CheckParameterUtil.ensureParameterNotNull(privileges, "privileges");
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        try {
            monitor.beginTask(I18n.tr("Authorizing OAuth Request token ''{0}'' at the OSM website ...", requestToken.getKey()));
            monitor.setTicksCount(4);
            monitor.indeterminateSubTask(I18n.tr("Initializing a session at the OSM website..."));
            String sessionId = this.fetchOsmWebsiteSessionId();
            if (this.canceled) {
                throw new OsmTransferCancelledException();
            }
            monitor.worked(1);
            monitor.indeterminateSubTask(I18n.tr("Authenticating the session for user ''{0}''...", osmUserName));
            this.authenticateOsmSession(sessionId, osmUserName, osmPassword);
            if (this.canceled) {
                throw new OsmTransferCancelledException();
            }
            monitor.worked(1);
            monitor.indeterminateSubTask(I18n.tr("Authorizing request token ''{0}''...", requestToken.getKey()));
            this.sendAuthorisationRequest(sessionId, requestToken, privileges);
            if (this.canceled) {
                throw new OsmTransferCancelledException();
            }
            monitor.worked(1);
            monitor.indeterminateSubTask(I18n.tr("Logging out session ''{0}''...", sessionId));
            this.logoutOsmSession(sessionId);
            if (this.canceled) {
                throw new OsmTransferCancelledException();
            }
            monitor.worked(1);
        }
        catch (OsmOAuthAuthorizationException e) {
            if (this.canceled) {
                throw new OsmTransferCancelledException();
            }
            throw e;
        }
        finally {
            monitor.finishTask();
        }
    }
}

