/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.server;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.server.BasicAuthenticationPreferencesPanel;
import org.openstreetmap.josm.gui.preferences.server.OAuthAccessTokenHolder;
import org.openstreetmap.josm.gui.preferences.server.OAuthAuthenticationPreferencesPanel;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.io.auth.CredentialsManagerFactory;
import org.openstreetmap.josm.tools.I18n;

public class AuthenticationPreferencesPanel
extends VerticallyScrollablePanel
implements PropertyChangeListener {
    private JRadioButton rbBasicAuthentication;
    private JRadioButton rbOAuth;
    private JPanel pnlAuthenticationParameteters;
    private BasicAuthenticationPreferencesPanel pnlBasicAuthPreferences;
    private OAuthAuthenticationPreferencesPanel pnlOAuthPreferences;

    protected void build() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        AuthenticationMethodChangeListener authChangeListener = new AuthenticationMethodChangeListener();
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 0.0;
        gc.insets = new Insets(0, 0, 0, 3);
        this.rbBasicAuthentication = new JRadioButton();
        this.add((Component)this.rbBasicAuthentication, gc);
        this.rbBasicAuthentication.setText(I18n.tr("Use Basic Authentication"));
        this.rbBasicAuthentication.setToolTipText(I18n.tr("Select to use HTTP basic authentication with your OSM username and password"));
        this.rbBasicAuthentication.addItemListener(authChangeListener);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.rbOAuth = new JRadioButton();
        this.add((Component)this.rbOAuth, gc);
        this.rbOAuth.setText(I18n.tr("Use OAuth"));
        this.rbOAuth.setToolTipText(I18n.tr("Select to use OAuth as authentication mechanism"));
        this.rbOAuth.addItemListener(authChangeListener);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.rbBasicAuthentication);
        bg.add(this.rbOAuth);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.gridwidth = 2;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        this.pnlAuthenticationParameteters = new JPanel();
        this.add((Component)this.pnlAuthenticationParameteters, gc);
        this.pnlAuthenticationParameteters.setLayout(new BorderLayout());
        this.pnlBasicAuthPreferences = new BasicAuthenticationPreferencesPanel();
        this.pnlOAuthPreferences = new OAuthAuthenticationPreferencesPanel();
        this.rbBasicAuthentication.setSelected(true);
        this.pnlAuthenticationParameteters.add((Component)this.pnlBasicAuthPreferences, "Center");
    }

    public AuthenticationPreferencesPanel() {
        this.build();
        HelpUtil.setHelpContext(this, HelpUtil.ht("/Preferences/Connection#AuthenticationSettings"));
    }

    public void initFromPreferences() {
        String authMethod = Main.pref.get("osm-server.auth-method", "basic");
        if (authMethod.equals("basic")) {
            this.rbBasicAuthentication.setSelected(true);
        } else if (authMethod.equals("oauth")) {
            this.rbOAuth.setSelected(true);
        } else {
            System.err.println(I18n.tr("Warning: Unsupported value in preference ''{0}'', got {1}''. Using authentication method ''Basic Authentication''.", "osm-server.auth-method", authMethod));
            this.rbBasicAuthentication.setSelected(true);
        }
        this.pnlBasicAuthPreferences.initFromPreferences();
        this.pnlOAuthPreferences.initFromPreferences();
    }

    public void saveToPreferences() {
        String authMethod = this.rbBasicAuthentication.isSelected() ? "basic" : "oauth";
        Main.pref.put("osm-server.auth-method", authMethod);
        if (authMethod.equals("basic")) {
            this.pnlBasicAuthPreferences.saveToPreferences();
            OAuthAccessTokenHolder.getInstance().clear();
            OAuthAccessTokenHolder.getInstance().save(Main.pref, CredentialsManagerFactory.getCredentialManager());
        } else if (authMethod.equals("oauth")) {
            this.pnlBasicAuthPreferences.clearPassword();
            this.pnlBasicAuthPreferences.saveToPreferences();
            this.pnlOAuthPreferences.saveToPreferences();
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.pnlOAuthPreferences != null) {
            this.pnlOAuthPreferences.propertyChange(evt);
        }
    }

    class AuthenticationMethodChangeListener
    implements ItemListener {
        AuthenticationMethodChangeListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (AuthenticationPreferencesPanel.this.rbBasicAuthentication.isSelected()) {
                AuthenticationPreferencesPanel.this.pnlAuthenticationParameteters.removeAll();
                AuthenticationPreferencesPanel.this.pnlAuthenticationParameteters.add((Component)AuthenticationPreferencesPanel.this.pnlBasicAuthPreferences, "Center");
                AuthenticationPreferencesPanel.this.pnlBasicAuthPreferences.revalidate();
            } else {
                AuthenticationPreferencesPanel.this.pnlAuthenticationParameteters.removeAll();
                AuthenticationPreferencesPanel.this.pnlAuthenticationParameteters.add((Component)AuthenticationPreferencesPanel.this.pnlOAuthPreferences, "Center");
                AuthenticationPreferencesPanel.this.pnlOAuthPreferences.revalidate();
            }
            AuthenticationPreferencesPanel.this.repaint();
        }
    }
}

