/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.data.osm.history.HistoryNode;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.data.osm.history.HistoryRelation;
import org.openstreetmap.josm.data.osm.history.HistoryWay;
import org.openstreetmap.josm.data.osm.history.RelationMember;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.DateUtils;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OsmHistoryReader {
    private final InputStream in;
    private final HistoryDataSet data;

    public OsmHistoryReader(InputStream source) {
        this.in = source;
        this.data = new HistoryDataSet();
    }

    public HistoryDataSet parse(ProgressMonitor progressMonitor) throws SAXException, IOException {
        InputSource inputSource = new InputSource(new InputStreamReader(this.in, "UTF-8"));
        progressMonitor.beginTask(I18n.tr("Parsing OSM history data ..."));
        try {
            SAXParserFactory.newInstance().newSAXParser().parse(inputSource, (DefaultHandler)new Parser());
        }
        catch (ParserConfigurationException e1) {
            e1.printStackTrace();
            throw new SAXException(e1);
        }
        finally {
            progressMonitor.finishTask();
        }
        return this.data;
    }

    private class Parser
    extends DefaultHandler {
        private HistoryOsmPrimitive current;
        private Locator locator;

        private Parser() {
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        protected String getCurrentPosition() {
            if (this.locator == null) {
                return "";
            }
            return "(" + this.locator.getLineNumber() + "," + this.locator.getColumnNumber() + ")";
        }

        protected void throwException(String message) throws SAXException {
            throw new SAXException(this.getCurrentPosition() + message);
        }

        protected long getMandatoryAttributeLong(Attributes attr, String name) throws SAXException {
            String v = attr.getValue(name);
            if (v == null) {
                this.throwException(I18n.tr("Missing mandatory attribute ''{0}''.", name));
            }
            Long l = 0L;
            try {
                l = Long.parseLong(v);
            }
            catch (NumberFormatException e) {
                this.throwException(I18n.tr("Illegal value for mandatory attribute ''{0}'' of type long. Got ''{1}''.", name, v));
            }
            if (l < 0L) {
                this.throwException(I18n.tr("Illegal value for mandatory attribute ''{0}'' of type long (>=0). Got ''{1}''.", name, v));
            }
            return l;
        }

        protected long getAttributeLong(Attributes attr, String name, long defaultValue) throws SAXException {
            String v = attr.getValue(name);
            if (v == null) {
                return defaultValue;
            }
            Long l = 0L;
            try {
                l = Long.parseLong(v);
            }
            catch (NumberFormatException e) {
                this.throwException(I18n.tr("Illegal value for mandatory attribute ''{0}'' of type long. Got ''{1}''.", name, v));
            }
            if (l < 0L) {
                this.throwException(I18n.tr("Illegal value for mandatory attribute ''{0}'' of type long (>=0). Got ''{1}''.", name, v));
            }
            return l;
        }

        protected Double getMandatoryAttributeDouble(Attributes attr, String name) throws SAXException {
            String v = attr.getValue(name);
            if (v == null) {
                this.throwException(I18n.tr("Missing mandatory attribute ''{0}''.", name));
            }
            double d = 0.0;
            try {
                d = Double.parseDouble(v);
            }
            catch (NumberFormatException e) {
                this.throwException(I18n.tr("Illegal value for mandatory attribute ''{0}'' of type double. Got ''{1}''.", name, v));
            }
            return d;
        }

        protected String getMandatoryAttributeString(Attributes attr, String name) throws SAXException {
            String v = attr.getValue(name);
            if (v == null) {
                this.throwException(I18n.tr("Missing mandatory attribute ''{0}''.", name));
            }
            return v;
        }

        protected String getAttributeString(Attributes attr, String name, String defaultValue) {
            String v = attr.getValue(name);
            if (v == null) {
                return defaultValue;
            }
            return v;
        }

        protected boolean getMandatoryAttributeBoolean(Attributes attr, String name) throws SAXException {
            String v = attr.getValue(name);
            if (v == null) {
                this.throwException(I18n.tr("Missing mandatory attribute ''{0}''.", name));
            }
            if ("true".equals(v)) {
                return true;
            }
            if ("false".equals(v)) {
                return false;
            }
            this.throwException(I18n.tr("Illegal value for mandatory attribute ''{0}'' of type boolean. Got ''{1}''.", name, v));
            return false;
        }

        protected HistoryOsmPrimitive createPrimitive(Attributes atts, OsmPrimitiveType type) throws SAXException {
            long id = this.getMandatoryAttributeLong(atts, "id");
            long version = this.getMandatoryAttributeLong(atts, "version");
            long changesetId = this.getMandatoryAttributeLong(atts, "changeset");
            boolean visible = this.getMandatoryAttributeBoolean(atts, "visible");
            long uid = this.getAttributeLong(atts, "uid", -1L);
            String user = this.getAttributeString(atts, "user", I18n.tr("<anonymous>"));
            String v = this.getMandatoryAttributeString(atts, "timestamp");
            Date timestamp = DateUtils.fromString(v);
            HistoryOsmPrimitive primitive = null;
            if (type.equals((Object)OsmPrimitiveType.NODE)) {
                double lat = this.getMandatoryAttributeDouble(atts, "lat");
                double lon = this.getMandatoryAttributeDouble(atts, "lon");
                primitive = new HistoryNode(id, version, visible, user, uid, changesetId, timestamp, new LatLon(lat, lon));
            } else if (type.equals((Object)OsmPrimitiveType.WAY)) {
                primitive = new HistoryWay(id, version, visible, user, uid, changesetId, timestamp);
            }
            if (type.equals((Object)OsmPrimitiveType.RELATION)) {
                primitive = new HistoryRelation(id, version, visible, user, uid, changesetId, timestamp);
            }
            return primitive;
        }

        protected void startNode(Attributes atts) throws SAXException {
            this.current = this.createPrimitive(atts, OsmPrimitiveType.NODE);
        }

        protected void startWay(Attributes atts) throws SAXException {
            this.current = this.createPrimitive(atts, OsmPrimitiveType.WAY);
        }

        protected void startRelation(Attributes atts) throws SAXException {
            this.current = this.createPrimitive(atts, OsmPrimitiveType.RELATION);
        }

        protected void handleTag(Attributes atts) throws SAXException {
            String key = this.getMandatoryAttributeString(atts, "k");
            String value = this.getMandatoryAttributeString(atts, "v");
            this.current.put(key, value);
        }

        protected void handleNodeReference(Attributes atts) throws SAXException {
            long ref = this.getMandatoryAttributeLong(atts, "ref");
            ((HistoryWay)this.current).addNode(ref);
        }

        protected void handleMember(Attributes atts) throws SAXException {
            long ref = this.getMandatoryAttributeLong(atts, "ref");
            String v = this.getMandatoryAttributeString(atts, "type");
            OsmPrimitiveType type = null;
            try {
                type = OsmPrimitiveType.fromApiTypeName(v);
            }
            catch (IllegalArgumentException e) {
                this.throwException(I18n.tr("Illegal value for mandatory attribute ''{0}'' of type OsmPrimitiveType. Got ''{1}''.", "type", v));
            }
            String role = this.getMandatoryAttributeString(atts, "role");
            RelationMember member = new RelationMember(role, type, ref);
            ((HistoryRelation)this.current).addMember(member);
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (qName.equals("node")) {
                this.startNode(atts);
            } else if (qName.equals("way")) {
                this.startWay(atts);
            } else if (qName.equals("relation")) {
                this.startRelation(atts);
            } else if (qName.equals("tag")) {
                this.handleTag(atts);
            } else if (qName.equals("nd")) {
                this.handleNodeReference(atts);
            } else if (qName.equals("member")) {
                this.handleMember(atts);
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("node") || qName.equals("way") || qName.equals("relation")) {
                OsmHistoryReader.this.data.put(this.current);
            }
        }
    }
}

