/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Random;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArgsFile;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBinding;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyContinuation;
import org.jruby.RubyEnumerator;
import org.jruby.RubyException;
import org.jruby.RubyFile;
import org.jruby.RubyFileTest;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyIO;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNameError;
import org.jruby.RubyNil;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyProcess;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubySystemExit;
import org.jruby.RubyThread;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.common.IRubyWarnings;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.platform.Platform;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.IAutoloadMethod;
import org.jruby.runtime.load.LoadService;
import org.jruby.util.IdUtil;
import org.jruby.util.ShellLauncher;
import org.jruby.util.TypeConverter;

@JRubyModule(name={"Kernel"})
public class RubyKernel {
    public static final Class<?> IRUBY_OBJECT = IRubyObject.class;

    public static RubyModule createKernelModule(Ruby runtime2) {
        RubyModule module = runtime2.defineModule("Kernel");
        runtime2.setKernel(module);
        module.defineAnnotatedMethods(RubyKernel.class);
        module.defineAnnotatedMethods(RubyObject.class);
        runtime2.setRespondToMethod(module.searchMethod("respond_to?"));
        module.setFlag(4096, false);
        runtime2.setPrivateMethodMissing(new MethodMissingMethod(module){

            public IRubyObject methodMissing(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                return RubyKernel.methodMissing(context, self, name2, Visibility.PRIVATE, CallType.NORMAL, args2, block);
            }
        });
        runtime2.setProtectedMethodMissing(new MethodMissingMethod(module){

            public IRubyObject methodMissing(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                return RubyKernel.methodMissing(context, self, name2, Visibility.PROTECTED, CallType.NORMAL, args2, block);
            }
        });
        runtime2.setVariableMethodMissing(new MethodMissingMethod(module){

            public IRubyObject methodMissing(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                return RubyKernel.methodMissing(context, self, name2, Visibility.PUBLIC, CallType.VARIABLE, args2, block);
            }
        });
        runtime2.setSuperMethodMissing(new MethodMissingMethod(module){

            public IRubyObject methodMissing(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                return RubyKernel.methodMissing(context, self, name2, Visibility.PUBLIC, CallType.SUPER, args2, block);
            }
        });
        runtime2.setNormalMethodMissing(new MethodMissingMethod(module){

            public IRubyObject methodMissing(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                return RubyKernel.methodMissing(context, self, name2, Visibility.PUBLIC, CallType.NORMAL, args2, block);
            }
        });
        runtime2.setDefaultMethodMissing(module.searchMethod("method_missing"));
        return module;
    }

    @JRubyMethod(name={"at_exit"}, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject at_exit(ThreadContext context, IRubyObject recv2, Block block) {
        return context.getRuntime().pushExitBlock(context.getRuntime().newProc(Block.Type.PROC, block));
    }

    @JRubyMethod(name={"autoload?"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject autoload_p(ThreadContext context, IRubyObject recv2, IRubyObject symbol) {
        Ruby runtime2 = context.getRuntime();
        RubyModule module = recv2 instanceof RubyModule ? (RubyModule)recv2 : runtime2.getObject();
        String name2 = module.getName() + "::" + symbol.asJavaString();
        IAutoloadMethod autoloadMethod = runtime2.getLoadService().autoloadFor(name2);
        if (autoloadMethod == null) {
            return runtime2.getNil();
        }
        return runtime2.newString(autoloadMethod.file());
    }

    @JRubyMethod(name={"autoload"}, required=2, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject autoload(IRubyObject recv2, IRubyObject symbol, final IRubyObject file2) {
        Ruby runtime2 = recv2.getRuntime();
        final LoadService loadService = runtime2.getLoadService();
        String nonInternedName = symbol.asJavaString();
        if (!IdUtil.isValidConstantName(nonInternedName)) {
            throw runtime2.newNameError("autoload must be constant name", nonInternedName);
        }
        if (!runtime2.is1_9() && !(file2 instanceof RubyString)) {
            throw runtime2.newTypeError(file2, runtime2.getString());
        }
        RubyString fileString = RubyFile.get_path(runtime2.getCurrentContext(), file2);
        if (fileString.isEmpty()) {
            throw runtime2.newArgumentError("empty file name");
        }
        final String baseName = symbol.asJavaString().intern();
        final RubyModule module = recv2 instanceof RubyModule ? (RubyModule)recv2 : runtime2.getObject();
        String nm = module.getName() + "::" + baseName;
        IRubyObject existingValue = module.fastFetchConstant(baseName);
        if (existingValue != null && existingValue != RubyObject.UNDEF) {
            return runtime2.getNil();
        }
        module.fastStoreConstant(baseName, RubyObject.UNDEF);
        loadService.addAutoload(nm, new IAutoloadMethod(){

            public String file() {
                return file2.toString();
            }

            public IRubyObject load(Ruby runtime2, String name2) {
                boolean required = loadService.require(this.file());
                if (!required) {
                    return null;
                }
                return module.fastGetConstant(baseName);
            }
        });
        return runtime2.getNil();
    }

    @JRubyMethod(name={"method_missing"}, rest=true, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject method_missing(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Visibility lastVis = context.getLastVisibility();
        CallType lastCallType = context.getLastCallType();
        if (args2.length == 0 || !(args2[0] instanceof RubySymbol)) {
            throw context.getRuntime().newArgumentError("no id given");
        }
        return RubyKernel.methodMissingDirect(context, recv2, (RubySymbol)args2[0], lastVis, lastCallType, args2, block);
    }

    private static IRubyObject methodMissingDirect(ThreadContext context, IRubyObject recv2, RubySymbol symbol, Visibility lastVis, CallType lastCallType, IRubyObject[] args2, Block block) {
        IRubyObject[] exArgs;
        RubyClass exc;
        Ruby runtime2 = context.getRuntime();
        RubyNameError.RubyNameErrorMessage msg = new RubyNameError.RubyNameErrorMessage(runtime2, recv2, symbol, lastVis, lastCallType);
        if (lastCallType != CallType.VARIABLE) {
            exc = runtime2.getNoMethodError();
            exArgs = new IRubyObject[]{msg, symbol, RubyArray.newArrayNoCopy(runtime2, args2, 1)};
        } else {
            exc = runtime2.getNameError();
            exArgs = new IRubyObject[]{msg, symbol};
        }
        throw new RaiseException((RubyException)exc.newInstance(context, exArgs, Block.NULL_BLOCK));
    }

    private static IRubyObject methodMissing(ThreadContext context, IRubyObject recv2, String name2, Visibility lastVis, CallType lastCallType, IRubyObject[] args2, Block block) {
        IRubyObject[] exArgs;
        RubyClass exc;
        Ruby runtime2 = context.getRuntime();
        RubySymbol symbol = runtime2.newSymbol(name2);
        RubyNameError.RubyNameErrorMessage msg = new RubyNameError.RubyNameErrorMessage(runtime2, recv2, symbol, lastVis, lastCallType);
        if (lastCallType != CallType.VARIABLE) {
            exc = runtime2.getNoMethodError();
            exArgs = new IRubyObject[]{msg, symbol, RubyArray.newArrayNoCopy(runtime2, args2)};
        } else {
            exc = runtime2.getNameError();
            exArgs = new IRubyObject[]{msg, symbol};
        }
        throw new RaiseException((RubyException)exc.newInstance(context, exArgs, Block.NULL_BLOCK));
    }

    @JRubyMethod(name={"open"}, required=1, optional=2, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject open(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        String arg2 = args2[0].convertToString().toString();
        Ruby runtime2 = context.getRuntime();
        if (arg2.startsWith("|")) {
            String command = arg2.substring(1);
            return RubyIO.popen(context, runtime2.getIO(), new IRubyObject[]{runtime2.newString(command)}, block);
        }
        return RubyFile.open(context, runtime2.getFile(), args2, block);
    }

    @JRubyMethod(name={"getc"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject getc(ThreadContext context, IRubyObject recv2) {
        context.getRuntime().getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "getc is obsolete; use STDIN.getc instead", "getc", "STDIN.getc");
        IRubyObject defin = context.getRuntime().getGlobalVariables().get("$stdin");
        return defin.callMethod(context, "getc");
    }

    @JRubyMethod(name={"gets"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject gets(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyArgsFile.gets(context, context.getRuntime().getArgsFile(), args2);
    }

    @JRubyMethod(name={"abort"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject abort(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        if (args2.length == 1) {
            context.getRuntime().getGlobalVariables().get("$stderr").callMethod(context, "puts", args2[0]);
        }
        throw new MainExitException(1, true);
    }

    @JRubyMethod(name={"Array"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_array(ThreadContext context, IRubyObject recv2, IRubyObject object) {
        return RuntimeHelpers.arrayValue(context, context.getRuntime(), object);
    }

    @JRubyMethod(name={"Complex"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject new_complex(ThreadContext context, IRubyObject recv2) {
        return RuntimeHelpers.invoke(context, context.getRuntime().getComplex(), "convert");
    }

    @JRubyMethod(name={"Complex"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject new_complex(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return RuntimeHelpers.invoke(context, (IRubyObject)context.getRuntime().getComplex(), "convert", arg2);
    }

    @JRubyMethod(name={"Complex"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject new_complex(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1) {
        return RuntimeHelpers.invoke(context, (IRubyObject)context.getRuntime().getComplex(), "convert", arg0, arg1);
    }

    @JRubyMethod(name={"Rational"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject new_rational(ThreadContext context, IRubyObject recv2) {
        return RuntimeHelpers.invoke(context, context.getRuntime().getRational(), "convert");
    }

    @JRubyMethod(name={"Rational"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject new_rational(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return RuntimeHelpers.invoke(context, (IRubyObject)context.getRuntime().getRational(), "convert", arg2);
    }

    @JRubyMethod(name={"Rational"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject new_rational(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1) {
        return RuntimeHelpers.invoke(context, (IRubyObject)context.getRuntime().getRational(), "convert", arg0, arg1);
    }

    @JRubyMethod(name={"Float"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static RubyFloat new_float(IRubyObject recv2, IRubyObject object) {
        if (object instanceof RubyFixnum) {
            return RubyFloat.newFloat(object.getRuntime(), ((RubyFixnum)object).getDoubleValue());
        }
        if (object instanceof RubyFloat) {
            return (RubyFloat)object;
        }
        if (object instanceof RubyBignum) {
            return RubyFloat.newFloat(object.getRuntime(), RubyBignum.big2dbl((RubyBignum)object));
        }
        if (object instanceof RubyString) {
            if (((RubyString)object).getByteList().getRealSize() == 0) {
                throw recv2.getRuntime().newArgumentError("invalid value for Float(): " + object.inspect());
            }
            return RubyNumeric.str2fnum(recv2.getRuntime(), (RubyString)object, true);
        }
        if (object.isNil()) {
            throw recv2.getRuntime().newTypeError("can't convert nil into Float");
        }
        RubyFloat rFloat = (RubyFloat)TypeConverter.convertToType(object, recv2.getRuntime().getFloat(), "to_f");
        if (Double.isNaN(rFloat.getDoubleValue())) {
            throw recv2.getRuntime().newArgumentError("invalid value for Float()");
        }
        return rFloat;
    }

    @JRubyMethod(name={"Float"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyFloat new_float19(IRubyObject recv2, IRubyObject object) {
        if (object instanceof RubyFixnum) {
            return RubyFloat.newFloat(object.getRuntime(), ((RubyFixnum)object).getDoubleValue());
        }
        if (object instanceof RubyFloat) {
            return (RubyFloat)object;
        }
        if (object instanceof RubyBignum) {
            return RubyFloat.newFloat(object.getRuntime(), RubyBignum.big2dbl((RubyBignum)object));
        }
        if (object instanceof RubyString) {
            if (((RubyString)object).getByteList().getRealSize() == 0) {
                throw recv2.getRuntime().newArgumentError("invalid value for Float(): " + object.inspect());
            }
            return RubyNumeric.str2fnum(recv2.getRuntime(), (RubyString)object, true);
        }
        if (object.isNil()) {
            throw recv2.getRuntime().newTypeError("can't convert nil into Float");
        }
        RubyFloat rFloat = (RubyFloat)TypeConverter.convertToType19(object, recv2.getRuntime().getFloat(), "to_f");
        return rFloat;
    }

    @JRubyMethod(name={"Integer"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static IRubyObject new_integer(ThreadContext context, IRubyObject recv2, IRubyObject object) {
        IRubyObject tmp;
        if (object instanceof RubyFloat) {
            double val = ((RubyFloat)object).getDoubleValue();
            if (val > 9.223372036854776E18 && val < -9.223372036854776E18) {
                return RubyNumeric.dbl2num(context.getRuntime(), ((RubyFloat)object).getDoubleValue());
            }
        } else {
            if (object instanceof RubyFixnum || object instanceof RubyBignum) {
                return object;
            }
            if (object instanceof RubyString) {
                return RubyNumeric.str2inum(context.getRuntime(), (RubyString)object, 0, true);
            }
        }
        if ((tmp = TypeConverter.convertToType(object, context.getRuntime().getInteger(), "to_int", false)).isNil()) {
            return object.convertToInteger("to_i");
        }
        return tmp;
    }

    @JRubyMethod(name={"Integer"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject new_integer19(ThreadContext context, IRubyObject recv2, IRubyObject object) {
        IRubyObject tmp;
        if (object instanceof RubyFloat) {
            double val = ((RubyFloat)object).getDoubleValue();
            if (val > 9.223372036854776E18 && val < -9.223372036854776E18) {
                return RubyNumeric.dbl2num(context.getRuntime(), ((RubyFloat)object).getDoubleValue());
            }
        } else {
            if (object instanceof RubyFixnum || object instanceof RubyBignum) {
                return object;
            }
            if (object instanceof RubyString) {
                return RubyNumeric.str2inum(context.getRuntime(), (RubyString)object, 0, true);
            }
            if (object instanceof RubyNil) {
                throw context.getRuntime().newTypeError("can't convert nil into Integer");
            }
        }
        if ((tmp = TypeConverter.convertToType(object, context.getRuntime().getInteger(), "to_int", false)).isNil()) {
            return object.convertToInteger("to_i");
        }
        return tmp;
    }

    @JRubyMethod(name={"Integer"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject new_integer19(ThreadContext context, IRubyObject recv2, IRubyObject object, IRubyObject base) {
        int bs = RubyNumeric.num2int(base);
        if (object instanceof RubyString) {
            return RubyNumeric.str2inum(context.getRuntime(), (RubyString)object, bs, true);
        }
        IRubyObject tmp = object.checkStringType();
        if (!tmp.isNil()) {
            return RubyNumeric.str2inum(context.getRuntime(), (RubyString)tmp, bs, true);
        }
        throw context.getRuntime().newArgumentError("base specified for non string value");
    }

    @JRubyMethod(name={"String"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static IRubyObject new_string(ThreadContext context, IRubyObject recv2, IRubyObject object) {
        return TypeConverter.convertToType(object, context.getRuntime().getString(), "to_s");
    }

    @JRubyMethod(name={"String"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject new_string19(ThreadContext context, IRubyObject recv2, IRubyObject object) {
        return TypeConverter.convertToType19(object, context.getRuntime().getString(), "to_s");
    }

    @JRubyMethod(name={"p"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject p(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        IRubyObject defout = runtime2.getGlobalVariables().get("$>");
        for (int i = 0; i < args2.length; ++i) {
            if (args2[i] == null) continue;
            defout.callMethod(context, "write", RubyObject.inspect(context, args2[i]));
            defout.callMethod(context, "write", runtime2.newString("\n"));
        }
        IRubyObject result = runtime2.getNil();
        if (runtime2.is1_9()) {
            if (args2.length == 1) {
                result = args2[0];
            } else if (args2.length > 1) {
                result = runtime2.newArray(args2);
            }
        }
        if (defout instanceof RubyFile) {
            ((RubyFile)defout).flush();
        }
        return result;
    }

    @JRubyMethod(name={"putc"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject putc(ThreadContext context, IRubyObject recv2, IRubyObject ch) {
        IRubyObject defout = context.getRuntime().getGlobalVariables().get("$>");
        return RubyIO.putc(context, defout, ch);
    }

    @JRubyMethod(name={"puts"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject puts(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject defout = context.getRuntime().getGlobalVariables().get("$>");
        return RubyIO.puts(context, defout, args2);
    }

    @JRubyMethod(name={"print"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject print(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject defout = context.getRuntime().getGlobalVariables().get("$>");
        return RubyIO.print(context, defout, args2);
    }

    @JRubyMethod(name={"printf"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject printf(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        if (args2.length != 0) {
            IRubyObject defout = context.getRuntime().getGlobalVariables().get("$>");
            if (!(args2[0] instanceof RubyString)) {
                defout = args2[0];
                args2 = ArgsUtil.popArray(args2);
            }
            defout.callMethod(context, "write", RubyKernel.sprintf(recv2, args2));
        }
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"readline"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject readline(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject line = RubyKernel.gets(context, recv2, args2);
        if (line.isNil()) {
            throw context.getRuntime().newEOFError();
        }
        return line;
    }

    @JRubyMethod(name={"readlines"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject readlines(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyArgsFile.readlines(context, context.getRuntime().getArgsFile(), args2);
    }

    private static RubyString getLastlineString(ThreadContext context, Ruby runtime2) {
        IRubyObject line = context.getCurrentScope().getLastLine(runtime2);
        if (line.isNil()) {
            throw runtime2.newTypeError("$_ value need to be String (nil given).");
        }
        if (!(line instanceof RubyString)) {
            throw runtime2.newTypeError("$_ value need to be String (" + line.getMetaClass().getName() + " given).");
        }
        return (RubyString)line;
    }

    public static IRubyObject sub_bang(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyKernel.getLastlineString(context, context.getRuntime()).sub_bang(context, args2, block);
    }

    @JRubyMethod(name={"sub!"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject sub_bang(ThreadContext context, IRubyObject recv2, IRubyObject arg0, Block block) {
        return RubyKernel.getLastlineString(context, context.getRuntime()).sub_bang(context, arg0, block);
    }

    @JRubyMethod(name={"sub!"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject sub_bang(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, Block block) {
        return RubyKernel.getLastlineString(context, context.getRuntime()).sub_bang(context, arg0, arg1, block);
    }

    public static IRubyObject sub(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyString str = (RubyString)RubyKernel.getLastlineString(context, context.getRuntime()).dup();
        if (!str.sub_bang(context, args2, block).isNil()) {
            context.getCurrentScope().setLastLine(str);
        }
        return str;
    }

    @JRubyMethod(name={"sub"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject sub(ThreadContext context, IRubyObject recv2, IRubyObject arg0, Block block) {
        RubyString str = (RubyString)RubyKernel.getLastlineString(context, context.getRuntime()).dup();
        if (!str.sub_bang(context, arg0, block).isNil()) {
            context.getCurrentScope().setLastLine(str);
        }
        return str;
    }

    @JRubyMethod(name={"sub"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject sub(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, Block block) {
        RubyString str = (RubyString)RubyKernel.getLastlineString(context, context.getRuntime()).dup();
        if (!str.sub_bang(context, arg0, arg1, block).isNil()) {
            context.getCurrentScope().setLastLine(str);
        }
        return str;
    }

    public static IRubyObject gsub_bang(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyKernel.getLastlineString(context, context.getRuntime()).gsub_bang(context, args2, block);
    }

    @JRubyMethod(name={"gsub!"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject gsub_bang(ThreadContext context, IRubyObject recv2, IRubyObject arg0, Block block) {
        return RubyKernel.getLastlineString(context, context.getRuntime()).gsub_bang(context, arg0, block);
    }

    @JRubyMethod(name={"gsub!"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject gsub_bang(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, Block block) {
        return RubyKernel.getLastlineString(context, context.getRuntime()).gsub_bang(context, arg0, arg1, block);
    }

    public static IRubyObject gsub(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyString str = (RubyString)RubyKernel.getLastlineString(context, context.getRuntime()).dup();
        if (!str.gsub_bang(context, args2, block).isNil()) {
            context.getCurrentScope().setLastLine(str);
        }
        return str;
    }

    @JRubyMethod(name={"gsub"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject gsub(ThreadContext context, IRubyObject recv2, IRubyObject arg0, Block block) {
        RubyString str = (RubyString)RubyKernel.getLastlineString(context, context.getRuntime()).dup();
        if (!str.gsub_bang(context, arg0, block).isNil()) {
            context.getCurrentScope().setLastLine(str);
        }
        return str;
    }

    @JRubyMethod(name={"gsub"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject gsub(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, Block block) {
        RubyString str = (RubyString)RubyKernel.getLastlineString(context, context.getRuntime()).dup();
        if (!str.gsub_bang(context, arg0, arg1, block).isNil()) {
            context.getCurrentScope().setLastLine(str);
        }
        return str;
    }

    @JRubyMethod(name={"chop!"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject chop_bang(ThreadContext context, IRubyObject recv2, Block block) {
        return RubyKernel.getLastlineString(context, context.getRuntime()).chop_bang(context);
    }

    @JRubyMethod(name={"chop"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject chop(ThreadContext context, IRubyObject recv2, Block block) {
        RubyString str = RubyKernel.getLastlineString(context, context.getRuntime());
        if (str.getByteList().getRealSize() > 0) {
            str = (RubyString)str.dup();
            str.chop_bang(context);
            context.getCurrentScope().setLastLine(str);
        }
        return str;
    }

    public static IRubyObject chomp_bang(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyKernel.getLastlineString(context, context.getRuntime()).chomp_bang(args2);
    }

    @JRubyMethod(name={"chomp!"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject chomp_bang(ThreadContext context, IRubyObject recv2) {
        return RubyKernel.getLastlineString(context, context.getRuntime()).chomp_bang(context);
    }

    @JRubyMethod(name={"chomp!"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject chomp_bang(ThreadContext context, IRubyObject recv2, IRubyObject arg0) {
        return RubyKernel.getLastlineString(context, context.getRuntime()).chomp_bang(context, arg0);
    }

    public static IRubyObject chomp(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyString str = RubyKernel.getLastlineString(context, context.getRuntime());
        RubyString dup2 = (RubyString)str.dup();
        if (dup2.chomp_bang(args2).isNil()) {
            return str;
        }
        context.getCurrentScope().setLastLine(dup2);
        return dup2;
    }

    @JRubyMethod(name={"chomp"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject chomp(ThreadContext context, IRubyObject recv2) {
        RubyString str = RubyKernel.getLastlineString(context, context.getRuntime());
        RubyString dup2 = (RubyString)str.dup();
        if (dup2.chomp_bang(context).isNil()) {
            return str;
        }
        context.getCurrentScope().setLastLine(dup2);
        return dup2;
    }

    @JRubyMethod(name={"chomp"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject chomp(ThreadContext context, IRubyObject recv2, IRubyObject arg0) {
        RubyString str = RubyKernel.getLastlineString(context, context.getRuntime());
        RubyString dup2 = (RubyString)str.dup();
        if (dup2.chomp_bang(context, arg0).isNil()) {
            return str;
        }
        context.getCurrentScope().setLastLine(dup2);
        return dup2;
    }

    public static IRubyObject split(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyKernel.getLastlineString(context, context.getRuntime()).split(context, args2);
    }

    @JRubyMethod(name={"split"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE, FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject split(ThreadContext context, IRubyObject recv2) {
        return RubyKernel.getLastlineString(context, context.getRuntime()).split(context);
    }

    @JRubyMethod(name={"split"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE, FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject split(ThreadContext context, IRubyObject recv2, IRubyObject arg0) {
        return RubyKernel.getLastlineString(context, context.getRuntime()).split(context, arg0);
    }

    @JRubyMethod(name={"split"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE, FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject split(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1) {
        return RubyKernel.getLastlineString(context, context.getRuntime()).split(context, arg0, arg1);
    }

    @JRubyMethod(name={"scan"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE, FrameField.BACKREF}, writes={FrameField.LASTLINE, FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject scan(ThreadContext context, IRubyObject recv2, IRubyObject pattern, Block block) {
        return RubyKernel.getLastlineString(context, context.getRuntime()).scan(context, pattern, block);
    }

    @JRubyMethod(name={"select"}, required=1, optional=3, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject select(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyIO.select_static(context, context.getRuntime(), args2);
    }

    @JRubyMethod(name={"sleep"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject sleep(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        long loopStartTime;
        long milliseconds;
        if (args2.length == 0) {
            milliseconds = 0L;
        } else {
            if (!(args2[0] instanceof RubyNumeric)) {
                throw context.getRuntime().newTypeError("can't convert " + args2[0].getMetaClass().getName() + "into time interval");
            }
            milliseconds = (long)(args2[0].convertToFloat().getDoubleValue() * 1000.0);
            if (milliseconds < 0L) {
                throw context.getRuntime().newArgumentError("time interval must be positive");
            }
            if (milliseconds == 0L) {
                return context.getRuntime().newFixnum(0);
            }
        }
        long startTime = System.currentTimeMillis();
        RubyThread rubyThread = context.getThread();
        do {
            loopStartTime = System.currentTimeMillis();
            try {
                if (rubyThread.sleep(milliseconds)) continue;
                break;
            }
            catch (InterruptedException iExcptn) {
                // empty catch block
            }
        } while ((milliseconds -= System.currentTimeMillis() - loopStartTime) > 0L);
        return context.getRuntime().newFixnum(Math.round((double)(System.currentTimeMillis() - startTime) / 1000.0));
    }

    @JRubyMethod(name={"exit"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject exit(IRubyObject recv2, IRubyObject[] args2) {
        RubyKernel.exit(recv2.getRuntime(), args2, false);
        return recv2.getRuntime().getNil();
    }

    @JRubyMethod(name={"exit!"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject exit_bang(IRubyObject recv2, IRubyObject[] args2) {
        RubyKernel.exit(recv2.getRuntime(), args2, true);
        return recv2.getRuntime().getNil();
    }

    private static void exit(Ruby runtime2, IRubyObject[] args2, boolean hard) {
        runtime2.secure(4);
        int status2 = 0;
        if (args2.length > 0) {
            RubyObject argument = (RubyObject)args2[0];
            status2 = argument instanceof RubyBoolean ? (argument.isFalse() ? 1 : 0) : RubyNumeric.fix2int(argument);
        }
        if (hard) {
            throw new MainExitException(status2, true);
        }
        throw runtime2.newSystemExit(status2);
    }

    @JRubyMethod(name={"global_variables"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyArray global_variables(ThreadContext context, IRubyObject recv2) {
        Ruby runtime2 = context.getRuntime();
        RubyArray globalVariables = runtime2.newArray();
        for (String globalVariableName : runtime2.getGlobalVariables().getNames()) {
            globalVariables.append(runtime2.newString(globalVariableName));
        }
        return globalVariables;
    }

    @JRubyMethod(name={"local_variables"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyArray local_variables(ThreadContext context, IRubyObject recv2) {
        Ruby runtime2 = context.getRuntime();
        RubyArray localVariables = runtime2.newArray();
        for (String name2 : context.getCurrentScope().getAllNamesInScope()) {
            if (!IdUtil.isLocal(name2)) continue;
            localVariables.append(runtime2.newString(name2));
        }
        return localVariables;
    }

    @JRubyMethod(name={"binding"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static RubyBinding binding(ThreadContext context, IRubyObject recv2, Block block) {
        return RubyBinding.newBinding(context.getRuntime(), context.currentBinding(recv2));
    }

    @JRubyMethod(name={"binding"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyBinding binding_1_9(ThreadContext context, IRubyObject recv2, Block block) {
        return RubyBinding.newBinding(context.getRuntime(), context.currentBinding());
    }

    @JRubyMethod(name={"block_given?", "iterator?"}, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static RubyBoolean block_given_p(ThreadContext context, IRubyObject recv2, Block block) {
        return context.getRuntime().newBoolean(context.getPreviousFrame().getBlock().isGiven());
    }

    @Deprecated
    public static IRubyObject sprintf(IRubyObject recv2, IRubyObject[] args2) {
        return RubyKernel.sprintf(recv2.getRuntime().getCurrentContext(), recv2, args2);
    }

    @JRubyMethod(name={"sprintf", "format"}, required=1, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject sprintf(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        if (args2.length == 0) {
            throw context.getRuntime().newArgumentError("sprintf must have at least one argument");
        }
        RubyString str = RubyString.stringValue(args2[0]);
        RubyArray newArgs = context.getRuntime().newArrayNoCopy(args2);
        newArgs.shift(context);
        return str.op_format(context, newArgs);
    }

    @JRubyMethod(name={"raise", "fail"}, optional=3, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject raise(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        IRubyObject exception2;
        Ruby runtime2 = context.getRuntime();
        if (args2.length == 0) {
            IRubyObject lastException = runtime2.getGlobalVariables().get("$!");
            if (lastException.isNil()) {
                throw new RaiseException(runtime2, runtime2.getRuntimeError(), "", false);
            }
            throw new RaiseException((RubyException)lastException);
        }
        if (args2.length == 1) {
            if (args2[0] instanceof RubyString) {
                throw new RaiseException((RubyException)runtime2.getRuntimeError().newInstance(context, args2, block));
            }
            if (!args2[0].respondsTo("exception")) {
                throw runtime2.newTypeError("exception class/object expected");
            }
            exception2 = args2[0].callMethod(context, "exception");
        } else {
            if (!args2[0].respondsTo("exception")) {
                throw runtime2.newTypeError("exception class/object expected");
            }
            exception2 = args2[0].callMethod(context, "exception", args2[1]);
        }
        if (!runtime2.fastGetClass("Exception").isInstance(exception2)) {
            throw runtime2.newTypeError("exception object expected");
        }
        if (args2.length == 3) {
            ((RubyException)exception2).set_backtrace(args2[2]);
        }
        if (runtime2.getDebug().isTrue()) {
            RubyKernel.printExceptionSummary(context, runtime2, (RubyException)exception2);
        }
        throw new RaiseException((RubyException)exception2);
    }

    private static void printExceptionSummary(ThreadContext context, Ruby runtime2, RubyException rEx) {
        Frame currentFrame = context.getCurrentFrame();
        String msg = String.format("Exception `%s' at %s:%s - %s\n", rEx.getMetaClass(), currentFrame.getFile(), currentFrame.getLine() + 1, rEx.convertToString().toString());
        runtime2.getErrorStream().print(msg);
    }

    @JRubyMethod(name={"require"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static IRubyObject require(IRubyObject recv2, IRubyObject name2, Block block) {
        return RubyKernel.requireCommon(recv2.getRuntime(), recv2, name2, block);
    }

    @JRubyMethod(name={"require"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject require19(ThreadContext context, IRubyObject recv2, IRubyObject name2, Block block) {
        Ruby runtime2 = context.getRuntime();
        IRubyObject tmp = name2.checkStringType();
        if (!tmp.isNil()) {
            return RubyKernel.requireCommon(runtime2, recv2, tmp, block);
        }
        return RubyKernel.requireCommon(runtime2, recv2, name2.respondsTo("to_path") ? name2.callMethod(context, "to_path") : name2, block);
    }

    private static IRubyObject requireCommon(Ruby runtime2, IRubyObject recv2, IRubyObject name2, Block block) {
        if (runtime2.getLoadService().lockAndRequire(name2.convertToString().toString())) {
            return runtime2.getTrue();
        }
        return runtime2.getFalse();
    }

    @JRubyMethod(name={"load"}, required=1, optional=1, frame=true, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static IRubyObject load(IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyKernel.loadCommon(args2[0], recv2.getRuntime(), args2, block);
    }

    @JRubyMethod(name={"load"}, required=1, optional=1, frame=true, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject load19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        IRubyObject file2 = args2[0];
        if (!(file2 instanceof RubyString) && file2.respondsTo("to_path")) {
            file2 = file2.callMethod(context, "to_path");
        }
        return RubyKernel.loadCommon(file2, context.getRuntime(), args2, block);
    }

    private static IRubyObject loadCommon(IRubyObject fileName, Ruby runtime2, IRubyObject[] args2, Block block) {
        RubyString file2 = fileName.convertToString();
        boolean wrap2 = args2.length == 2 ? args2[1].isTrue() : false;
        runtime2.getLoadService().load(file2.getByteList().toString(), wrap2);
        return runtime2.getTrue();
    }

    @JRubyMethod(name={"eval"}, required=1, optional=3, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject eval(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Binding binding2;
        Ruby runtime2 = context.getRuntime();
        RubyString src = args2[0].convertToString();
        runtime2.checkSafeString(src);
        boolean bindingGiven = args2.length > 1 && !args2[1].isNil();
        Binding binding3 = binding2 = bindingGiven ? RubyKernel.convertToBinding(args2[1]) : context.previousBinding();
        if (args2.length > 2) {
            binding2.setFile(args2[2].convertToString().toString());
        } else if (!bindingGiven) {
            binding2.setFile("(eval)");
        }
        if (args2.length > 3) {
            binding2.setLine((int)args2[3].convertToInteger().getLongValue() - 1);
        } else {
            binding2.setLine(0);
        }
        return ASTInterpreter.evalWithBinding(context, src, binding2);
    }

    private static Binding convertToBinding(IRubyObject scope) {
        if (scope instanceof RubyBinding) {
            return ((RubyBinding)scope).getBinding().clone();
        }
        if (scope instanceof RubyProc) {
            return ((RubyProc)scope).getBlock().getBinding().clone();
        }
        throw scope.getRuntime().newTypeError("wrong argument type " + scope.getMetaClass() + " (expected Proc/Binding)");
    }

    @JRubyMethod(name={"callcc"}, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject callcc(ThreadContext context, IRubyObject recv2, Block block) {
        RubyContinuation continuation = new RubyContinuation(context.getRuntime());
        return continuation.enter(context, block);
    }

    public static IRubyObject caller(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        int level2;
        int n = level2 = args2.length > 0 ? RubyNumeric.fix2int(args2[0]) : 1;
        if (level2 < 0) {
            throw context.getRuntime().newArgumentError("negative level (" + level2 + ')');
        }
        return context.createCallerBacktrace(context.getRuntime(), level2);
    }

    @JRubyMethod(name={"caller"}, optional=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject caller1_9(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        int level2;
        int n = level2 = args2.length > 0 ? RubyNumeric.fix2int(args2[0]) : 1;
        if (level2 < 0) {
            throw context.getRuntime().newArgumentError("negative level (" + level2 + ')');
        }
        return context.createCallerBacktrace(context.getRuntime(), level2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"catch"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject rbCatch(ThreadContext context, IRubyObject recv2, IRubyObject tag, Block block) {
        RubyContinuation rbContinuation = new RubyContinuation(context.getRuntime(), tag.asJavaString());
        try {
            context.pushCatch(rbContinuation.getContinuation());
            IRubyObject iRubyObject = rbContinuation.enter(context, block);
            Object var7_6 = null;
            context.popCatch();
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            context.popCatch();
            throw throwable;
        }
    }

    @JRubyMethod(name={"throw"}, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject rbThrow(ThreadContext context, IRubyObject recv2, IRubyObject tag, Block block) {
        return RubyKernel.rbThrowInternal(context, tag.asJavaString(), IRubyObject.NULL_ARRAY, block);
    }

    @JRubyMethod(name={"throw"}, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject rbThrow(ThreadContext context, IRubyObject recv2, IRubyObject tag, IRubyObject arg2, Block block) {
        return RubyKernel.rbThrowInternal(context, tag.asJavaString(), new IRubyObject[]{arg2}, block);
    }

    public static IRubyObject rbThrowInternal(ThreadContext context, String tag, IRubyObject[] args2, Block block) {
        Ruby runtime2 = context.getRuntime();
        RubyContinuation.Continuation continuation = context.getActiveCatch(tag.intern());
        if (continuation != null) {
            continuation.args = args2;
            throw continuation;
        }
        String message2 = "uncaught throw `" + tag + "'";
        RubyThread currentThread = context.getThread();
        if (currentThread == runtime2.getThreadService().getMainThread()) {
            throw runtime2.newNameError(message2, tag);
        }
        throw runtime2.newThreadError(message2 + " in thread 0x" + Integer.toHexString(RubyInteger.fix2int(currentThread.id())));
    }

    @JRubyMethod(name={"trap"}, required=1, frame=true, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject trap(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        context.getRuntime().getLoadService().require("jsignal_internal");
        return RuntimeHelpers.invoke(context, recv2, "__jtrap", args2, block);
    }

    @JRubyMethod(name={"warn"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject warn(ThreadContext context, IRubyObject recv2, IRubyObject message2) {
        Ruby runtime2 = context.getRuntime();
        if (runtime2.warningsEnabled()) {
            IRubyObject out = runtime2.getGlobalVariables().get("$stderr");
            RuntimeHelpers.invoke(context, out, "puts", message2);
        }
        return runtime2.getNil();
    }

    @JRubyMethod(name={"set_trace_func"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject set_trace_func(ThreadContext context, IRubyObject recv2, IRubyObject trace_func, Block block) {
        if (trace_func.isNil()) {
            context.getRuntime().setTraceFunction(null);
        } else {
            if (!(trace_func instanceof RubyProc)) {
                throw context.getRuntime().newTypeError("trace_func needs to be Proc.");
            }
            context.getRuntime().setTraceFunction((RubyProc)trace_func);
        }
        return trace_func;
    }

    @JRubyMethod(name={"trace_var"}, required=1, optional=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject trace_var(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        String var;
        if (args2.length == 0) {
            throw context.getRuntime().newArgumentError(0, 1);
        }
        RubyProc proc2 = null;
        String string2 = var = args2.length > 1 ? args2[0].toString() : null;
        if (var.charAt(0) != '$') {
            return context.getRuntime().getNil();
        }
        if (args2.length == 1) {
            proc2 = RubyProc.newProc(context.getRuntime(), block, Block.Type.PROC);
        }
        if (args2.length == 2) {
            proc2 = (RubyProc)TypeConverter.convertToType(args2[1], context.getRuntime().getProc(), "to_proc", true);
        }
        context.getRuntime().getGlobalVariables().setTraceVar(var, proc2);
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"untrace_var"}, required=1, optional=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject untrace_var(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        String var;
        if (args2.length == 0) {
            throw context.getRuntime().newArgumentError(0, 1);
        }
        String string2 = var = args2.length >= 1 ? args2[0].toString() : null;
        if (var.charAt(0) != '$') {
            return context.getRuntime().getNil();
        }
        if (args2.length > 1) {
            ArrayList<IRubyObject> success2 = new ArrayList<IRubyObject>();
            for (int i = 1; i < args2.length; ++i) {
                if (!context.getRuntime().getGlobalVariables().untraceVar(var, args2[i])) continue;
                success2.add(args2[i]);
            }
            return RubyArray.newArray(context.getRuntime(), success2);
        }
        context.getRuntime().getGlobalVariables().untraceVar(var);
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"singleton_method_added"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject singleton_method_added(ThreadContext context, IRubyObject recv2, IRubyObject symbolId, Block block) {
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"singleton_method_removed"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject singleton_method_removed(ThreadContext context, IRubyObject recv2, IRubyObject symbolId, Block block) {
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"singleton_method_undefined"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject singleton_method_undefined(ThreadContext context, IRubyObject recv2, IRubyObject symbolId, Block block) {
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"define_singleton_method"}, required=1, optional=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject define_singleton_method(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        if (args2.length == 0) {
            throw context.getRuntime().newArgumentError(0, 1);
        }
        RubyClass singleton_class2 = recv2.getSingletonClass();
        IRubyObject obj = args2.length > 1 ? singleton_class2.define_method(context, args2[0], args2[1], block) : singleton_class2.define_method(context, args2[0], block);
        return obj;
    }

    @JRubyMethod(name={"proc", "lambda"}, frame=true, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static RubyProc proc(ThreadContext context, IRubyObject recv2, Block block) {
        return context.getRuntime().newProc(Block.Type.LAMBDA, block);
    }

    @Deprecated
    public static RubyProc proc(IRubyObject recv2, Block block) {
        return recv2.getRuntime().newProc(Block.Type.LAMBDA, block);
    }

    @JRubyMethod(name={"lambda"}, frame=true, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyProc lambda(ThreadContext context, IRubyObject recv2, Block block) {
        return context.getRuntime().newProc(Block.Type.LAMBDA, block);
    }

    @JRubyMethod(name={"proc"}, frame=true, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyProc proc_1_9(ThreadContext context, IRubyObject recv2, Block block) {
        return context.getRuntime().newProc(Block.Type.PROC, block);
    }

    @JRubyMethod(name={"loop"}, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject loop_1_9(ThreadContext context, IRubyObject recv2, Block block) {
        IRubyObject nil = context.getRuntime().getNil();
        RubyClass stopIteration = context.getRuntime().getStopIteration();
        try {
            while (true) {
                block.yield(context, nil);
                context.pollThreadEvents();
            }
        }
        catch (RaiseException ex) {
            if (!stopIteration.op_eqq(context, ex.getException()).isTrue()) {
                throw ex;
            }
            return nil;
        }
    }

    @JRubyMethod(name={"test"}, required=2, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject test(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        if (args2.length == 0) {
            throw context.getRuntime().newArgumentError("wrong number of arguments");
        }
        int cmd = args2[0] instanceof RubyFixnum ? (int)((RubyFixnum)args2[0]).getLongValue() : (args2[0] instanceof RubyString && ((RubyString)args2[0]).getByteList().length() > 0 ? (int)((RubyString)args2[0]).getByteList().charAt(0) : (int)args2[0].convertToInteger().getLongValue());
        switch (cmd) {
            case 45: 
            case 60: 
            case 61: 
            case 62: 
            case 65: 
            case 67: 
            case 71: 
            case 77: 
            case 79: 
            case 82: 
            case 83: 
            case 87: 
            case 88: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 107: 
            case 108: 
            case 111: 
            case 112: 
            case 114: 
            case 115: 
            case 117: 
            case 119: 
            case 120: 
            case 122: {
                break;
            }
            default: {
                throw context.getRuntime().newArgumentError("unknown command ?" + (char)cmd);
            }
        }
        switch (cmd) {
            case 45: 
            case 60: 
            case 61: 
            case 62: {
                if (args2.length == 3) break;
                throw context.getRuntime().newArgumentError(args2.length, 3);
            }
            default: {
                if (args2.length == 2) break;
                throw context.getRuntime().newArgumentError(args2.length, 2);
            }
        }
        switch (cmd) {
            case 65: {
                return context.getRuntime().newFileStat(args2[1].convertToString().toString(), false).atime();
            }
            case 98: {
                return RubyFileTest.blockdev_p(recv2, args2[1]);
            }
            case 99: {
                return RubyFileTest.chardev_p(recv2, args2[1]);
            }
            case 67: {
                return context.getRuntime().newFileStat(args2[1].convertToString().toString(), false).ctime();
            }
            case 100: {
                return RubyFileTest.directory_p(recv2, args2[1]);
            }
            case 101: {
                return RubyFileTest.exist_p(recv2, args2[1]);
            }
            case 102: {
                return RubyFileTest.file_p(recv2, args2[1]);
            }
            case 103: {
                return RubyFileTest.setgid_p(recv2, args2[1]);
            }
            case 71: {
                return RubyFileTest.grpowned_p(recv2, args2[1]);
            }
            case 107: {
                return RubyFileTest.sticky_p(recv2, args2[1]);
            }
            case 77: {
                return context.getRuntime().newFileStat(args2[1].convertToString().toString(), false).mtime();
            }
            case 108: {
                return RubyFileTest.symlink_p(recv2, args2[1]);
            }
            case 111: {
                return RubyFileTest.owned_p(recv2, args2[1]);
            }
            case 79: {
                return RubyFileTest.rowned_p(recv2, args2[1]);
            }
            case 112: {
                return RubyFileTest.pipe_p(recv2, args2[1]);
            }
            case 114: {
                return RubyFileTest.readable_p(recv2, args2[1]);
            }
            case 82: {
                return RubyFileTest.readable_p(recv2, args2[1]);
            }
            case 115: {
                return RubyFileTest.size_p(recv2, args2[1]);
            }
            case 83: {
                return RubyFileTest.socket_p(recv2, args2[1]);
            }
            case 117: {
                return RubyFileTest.setuid_p(recv2, args2[1]);
            }
            case 119: {
                return RubyFileTest.writable_p(recv2, args2[1]);
            }
            case 87: {
                return RubyFileTest.writable_p(recv2, args2[1]);
            }
            case 120: {
                return RubyFileTest.executable_p(recv2, args2[1]);
            }
            case 88: {
                return RubyFileTest.executable_real_p(recv2, args2[1]);
            }
            case 122: {
                return RubyFileTest.zero_p(recv2, args2[1]);
            }
            case 61: {
                return context.getRuntime().newFileStat(args2[1].convertToString().toString(), false).mtimeEquals(args2[2]);
            }
            case 60: {
                return context.getRuntime().newFileStat(args2[1].convertToString().toString(), false).mtimeLessThan(args2[2]);
            }
            case 62: {
                return context.getRuntime().newFileStat(args2[1].convertToString().toString(), false).mtimeGreaterThan(args2[2]);
            }
            case 45: {
                return RubyFileTest.identical_p(recv2, args2[1], args2[2]);
            }
        }
        throw new InternalError("unreachable code reached!");
    }

    @JRubyMethod(name={"`"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject backquote(ThreadContext context, IRubyObject recv2, IRubyObject aString) {
        int resultCode;
        Ruby runtime2 = context.getRuntime();
        RubyString string2 = aString.convertToString();
        IRubyObject[] args2 = new IRubyObject[]{string2};
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            resultCode = ShellLauncher.runAndWait(runtime2, args2, output, false);
        }
        catch (Exception e) {
            resultCode = 127;
        }
        runtime2.getGlobalVariables().set("$?", RubyProcess.RubyStatus.newProcessStatus(runtime2, resultCode));
        byte[] out = output.toByteArray();
        int length2 = out.length;
        if (Platform.IS_WINDOWS) {
            int newPos = 0;
            for (int pos2 = 0; pos2 < length2; ++pos2) {
                byte curr = out[pos2];
                if (pos2 == length2 - 1) {
                    out[newPos++] = curr;
                    break;
                }
                byte next2 = out[pos2 + 1];
                if (curr == 13 && next2 == 10) continue;
                out[newPos++] = curr;
            }
            length2 = newPos;
        }
        return RubyString.newStringNoCopy(runtime2, out, 0, length2);
    }

    @JRubyMethod(name={"srand"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyInteger srand(ThreadContext context, IRubyObject recv2) {
        Ruby runtime2 = context.getRuntime();
        long oldRandomSeed = runtime2.getRandomSeed();
        runtime2.setRandomSeed(System.currentTimeMillis() ^ (long)recv2.hashCode() ^ runtime2.incrementRandomSeedSequence() ^ (long)runtime2.getRandom().nextInt(Math.max(1, Math.abs((int)runtime2.getRandomSeed()))));
        runtime2.getRandom().setSeed(runtime2.getRandomSeed());
        return runtime2.newFixnum(oldRandomSeed);
    }

    @JRubyMethod(name={"srand"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyInteger srand(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        RubyInteger integerSeed = arg2.convertToInteger("to_int");
        Ruby runtime2 = context.getRuntime();
        long oldRandomSeed = runtime2.getRandomSeed();
        runtime2.setRandomSeed(integerSeed.getLongValue());
        runtime2.getRandom().setSeed(runtime2.getRandomSeed());
        return runtime2.newFixnum(oldRandomSeed);
    }

    @JRubyMethod(name={"rand"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyNumeric rand(ThreadContext context, IRubyObject recv2) {
        Ruby runtime2 = context.getRuntime();
        return RubyFloat.newFloat(runtime2, runtime2.getRandom().nextDouble());
    }

    @JRubyMethod(name={"rand"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyNumeric rand(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        Ruby runtime2 = context.getRuntime();
        Random random = runtime2.getRandom();
        if (arg2 instanceof RubyBignum) {
            byte[] bigCeilBytes = ((RubyBignum)arg2).getValue().toByteArray();
            BigInteger bigCeil = new BigInteger(bigCeilBytes).abs();
            byte[] randBytes = new byte[bigCeilBytes.length];
            random.nextBytes(randBytes);
            BigInteger result = new BigInteger(randBytes).abs().mod(bigCeil);
            return new RubyBignum(runtime2, result);
        }
        RubyInteger integerCeil = (RubyInteger)RubyKernel.new_integer(context, recv2, arg2);
        long ceil2 = Math.abs(integerCeil.getLongValue());
        if (ceil2 == 0L) {
            return RubyFloat.newFloat(runtime2, random.nextDouble());
        }
        if (ceil2 > Integer.MAX_VALUE) {
            return runtime2.newFixnum(Math.abs(random.nextLong()) % ceil2);
        }
        return runtime2.newFixnum(random.nextInt((int)ceil2));
    }

    @JRubyMethod(name={"spawn"}, required=1, rest=true, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyFixnum spawn(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        long pid2 = ShellLauncher.runWithoutWait(runtime2, args2);
        return RubyFixnum.newFixnum(runtime2, pid2);
    }

    @JRubyMethod(name={"syscall"}, required=1, optional=9, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject syscall(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        throw context.getRuntime().newNotImplementedError("Kernel#syscall is not implemented in JRuby");
    }

    @JRubyMethod(name={"system"}, required=1, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static RubyBoolean system(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        int resultCode;
        Ruby runtime2 = context.getRuntime();
        try {
            resultCode = ShellLauncher.runAndWait(runtime2, args2);
        }
        catch (Exception e) {
            resultCode = 127;
        }
        runtime2.getGlobalVariables().set("$?", RubyProcess.RubyStatus.newProcessStatus(runtime2, resultCode));
        return runtime2.newBoolean(resultCode == 0);
    }

    @JRubyMethod(name={"exec"}, required=1, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject exec(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        int resultCode;
        Ruby runtime2 = context.getRuntime();
        if (args2.length == 1 && args2[0].convertToString().isEmpty()) {
            throw runtime2.newErrnoENOENTError(args2[0].convertToString().toString());
        }
        try {
            resultCode = ShellLauncher.execAndWait(runtime2, args2);
        }
        catch (RaiseException e) {
            throw e;
        }
        catch (Exception e) {
            throw runtime2.newErrnoENOENTError("cannot execute");
        }
        RubyKernel.exit(runtime2, new IRubyObject[]{runtime2.newFixnum(resultCode)}, true);
        return runtime2.getNil();
    }

    @JRubyMethod(name={"fork"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject fork(ThreadContext context, IRubyObject recv2, Block block) {
        Ruby runtime2 = context.getRuntime();
        if (!RubyInstanceConfig.FORK_ENABLED) {
            throw runtime2.newNotImplementedError("fork is unsafe and disabled by default on JRuby");
        }
        if (block.isGiven()) {
            int pid2 = runtime2.getPosix().fork();
            if (pid2 == 0) {
                try {
                    block.yield(context, runtime2.getNil());
                }
                catch (RaiseException re) {
                    if (re.getException() instanceof RubySystemExit) {
                        throw re;
                    }
                    return RubyKernel.exit_bang(recv2, new IRubyObject[]{RubyFixnum.minus_one(runtime2)});
                }
                catch (Throwable t) {
                    return RubyKernel.exit_bang(recv2, new IRubyObject[]{RubyFixnum.minus_one(runtime2)});
                }
                return RubyKernel.exit_bang(recv2, new IRubyObject[]{RubyFixnum.zero(runtime2)});
            }
            return runtime2.newFixnum(pid2);
        }
        int result = runtime2.getPosix().fork();
        if (result == -1) {
            return runtime2.getNil();
        }
        return runtime2.newFixnum(result);
    }

    @JRubyMethod(frame=true, module=true)
    public static IRubyObject tap(ThreadContext context, IRubyObject recv2, Block block) {
        block.yield(context, recv2);
        return recv2;
    }

    @JRubyMethod(name={"to_enum", "enum_for"}, rest=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject to_enum(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        switch (args2.length) {
            case 0: {
                return RubyEnumerator.enumeratorize(runtime2, recv2, "each");
            }
            case 1: {
                return RubyEnumerator.enumeratorize(runtime2, recv2, args2[0].asJavaString());
            }
            case 2: {
                return RubyEnumerator.enumeratorize(runtime2, recv2, args2[0].asJavaString(), args2[1]);
            }
        }
        IRubyObject[] enumArgs = new IRubyObject[args2.length - 1];
        System.arraycopy(args2, 1, enumArgs, 0, enumArgs.length);
        return RubyEnumerator.enumeratorize(runtime2, recv2, args2[0].asJavaString(), enumArgs);
    }

    @JRubyMethod(name={"__method__", "__callee__"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject __method__(ThreadContext context, IRubyObject recv2) {
        Frame f = context.getCurrentFrame();
        String name2 = f != null ? f.getName() : null;
        return name2 != null ? context.getRuntime().newSymbol(name2) : context.getRuntime().getNil();
    }

    @JRubyMethod(module=true, frame=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject singleton_class(IRubyObject recv2) {
        return recv2.getSingletonClass();
    }

    public static abstract class MethodMissingMethod
    extends JavaMethod.JavaMethodNBlock {
        public MethodMissingMethod(RubyModule implementationClass) {
            super(implementationClass, Visibility.PRIVATE, CallConfiguration.FrameFullScopeNone);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            IRubyObject iRubyObject;
            try {
                this.preFrameOnly(context, self, name2, block);
                iRubyObject = this.methodMissing(context, self, clazz, name2, args2, block);
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                MethodMissingMethod.postFrameOnly(context);
                throw throwable;
            }
            MethodMissingMethod.postFrameOnly(context);
            return iRubyObject;
        }

        public abstract IRubyObject methodMissing(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject[] var5, Block var6);
    }
}

