/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command;

import java.sql.SQLException;
import org.h2.command.CommandInterface;
import org.h2.command.Parser;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.message.TraceObject;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.util.ObjectArray;

public abstract class Command
implements CommandInterface {
    protected final Session session;
    protected final Trace trace;
    protected long startTime;
    private volatile boolean cancel;
    private final String sql;

    public Command(Parser parser, String string) {
        this.session = parser.getSession();
        this.sql = string;
        this.trace = this.session.getDatabase().getTrace("command");
    }

    public abstract boolean isTransactional();

    public abstract boolean isQuery();

    public abstract ObjectArray getParameters();

    public abstract boolean isReadOnly();

    public abstract LocalResult queryMeta() throws SQLException;

    public int update() throws SQLException {
        throw Message.getSQLException(90001);
    }

    public LocalResult query(int n) throws SQLException {
        throw Message.getSQLException(90002);
    }

    public final LocalResult getMetaDataLocal() throws SQLException {
        return this.queryMeta();
    }

    public final ResultInterface getMetaData() throws SQLException {
        return this.queryMeta();
    }

    public ResultInterface executeQuery(int n, boolean bl) throws SQLException {
        return this.executeQueryLocal(n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LocalResult executeQueryLocal(int n) throws SQLException {
        this.startTime = System.currentTimeMillis();
        Database database = this.session.getDatabase();
        Object object = database.isMultiThreaded() ? this.session : database;
        this.session.waitIfExclusiveModeEnabled();
        Object object2 = object;
        synchronized (object2) {
            try {
                database.checkPowerOff();
                this.session.setCurrentCommand(this, this.startTime);
                LocalResult localResult = this.query(n);
                return localResult;
            }
            catch (Exception exception) {
                SQLException sQLException = Message.convert(exception, this.sql);
                database.exceptionThrown(sQLException, this.sql);
                throw sQLException;
            }
            finally {
                this.stop();
            }
        }
    }

    void start() {
        this.startTime = System.currentTimeMillis();
    }

    public void checkCanceled() throws SQLException {
        if (this.cancel) {
            this.cancel = false;
            throw Message.getSQLException(90051);
        }
    }

    private void stop() throws SQLException {
        long l;
        Database database;
        this.session.closeTemporaryResults();
        this.session.setCurrentCommand(null, 0L);
        if (!this.isTransactional()) {
            this.session.commit(true);
        } else if (this.session.getAutoCommit()) {
            this.session.commit(false);
        } else if (this.session.getDatabase().isMultiThreaded() && (database = this.session.getDatabase()) != null && database.getLockMode() == 3) {
            this.session.unlockReadLocks();
        }
        if (this.trace.isInfoEnabled() && (l = System.currentTimeMillis() - this.startTime) > 100L) {
            this.trace.info("slow query: " + l);
        }
    }

    /*
     * Exception decompiling
     */
    public int executeUpdate() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void close() {
    }

    public void cancel() {
        this.cancel = true;
    }

    public String toString() {
        return TraceObject.toString(this.sql, this.getParameters());
    }
}

