/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.charset;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

final class UTF_16Encoder
extends CharsetEncoder {
    static final int BIG_ENDIAN = 0;
    static final int LITTLE_ENDIAN = 1;
    private static final char BYTE_ORDER_MARK = '\ufeff';
    private final ByteOrder byteOrder;
    private final boolean useByteOrderMark;
    private boolean needsByteOrderMark;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        CoderResult coderResult;
        int n;
        block12: {
            CoderResult coderResult2;
            block16: {
                CoderResult coderResult3;
                block15: {
                    CoderResult coderResult4;
                    block14: {
                        CoderResult coderResult5;
                        ByteOrder byteOrder = byteBuffer.order();
                        byteBuffer.order(this.byteOrder);
                        if (this.needsByteOrderMark) {
                            if (byteBuffer.remaining() < 2) {
                                byteBuffer.order(byteOrder);
                                return CoderResult.OVERFLOW;
                            }
                            byteBuffer.putChar('\ufeff');
                            this.needsByteOrderMark = false;
                        }
                        n = charBuffer.position();
                        try {
                            while (true) {
                                if (!charBuffer.hasRemaining()) {
                                    byteBuffer.order(byteOrder);
                                    coderResult = CoderResult.UNDERFLOW;
                                    break block12;
                                }
                                char c = charBuffer.get();
                                if ('\ud800' <= c && c <= '\udfff') {
                                    if (c > '\udbff') {
                                        coderResult5 = CoderResult.malformedForLength(1);
                                        Object var6_12 = null;
                                        break;
                                    }
                                    if (charBuffer.remaining() < 1) {
                                        coderResult4 = CoderResult.UNDERFLOW;
                                        break block14;
                                    }
                                    char c2 = charBuffer.get();
                                    if (c2 < '\udc00' || c2 > '\udfff') {
                                        coderResult3 = CoderResult.malformedForLength(1);
                                        break block15;
                                    } else {
                                        byteBuffer.putChar(c);
                                        byteBuffer.putChar(c2);
                                        n += 2;
                                        continue;
                                    }
                                }
                                if (byteBuffer.remaining() < 2) {
                                    byteBuffer.order(byteOrder);
                                    coderResult2 = CoderResult.OVERFLOW;
                                    break block16;
                                }
                                byteBuffer.putChar(c);
                                ++n;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var6_17 = null;
                            charBuffer.position(n);
                            throw throwable;
                        }
                        charBuffer.position(n);
                        return coderResult5;
                    }
                    Object var6_13 = null;
                    charBuffer.position(n);
                    return coderResult4;
                }
                Object var6_14 = null;
                charBuffer.position(n);
                return coderResult3;
            }
            Object var6_15 = null;
            charBuffer.position(n);
            return coderResult2;
        }
        Object var6_16 = null;
        charBuffer.position(n);
        return coderResult;
    }

    protected final void implReset() {
        this.needsByteOrderMark = this.useByteOrderMark;
    }

    UTF_16Encoder(Charset charset, int n, boolean bl) {
        byte[] byArray;
        float f = bl ? (float)4 : 2.0f;
        if (n == 0) {
            byte[] byArray2 = new byte[2];
            byArray2[0] = -1;
            byArray = byArray2;
            byArray2[1] = -3;
        } else {
            byte[] byArray3 = new byte[2];
            byArray3[0] = -3;
            byArray = byArray3;
            byArray3[1] = -1;
        }
        super(charset, 2.0f, f, byArray);
        this.byteOrder = n == 0 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        this.useByteOrderMark = bl;
        this.needsByteOrderMark = bl;
    }
}

