/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Integer
extends Number
implements Comparable {
    private static final long serialVersionUID = 1360826667806852920L;
    public static final int MIN_VALUE = -2147483648;
    public static final int MAX_VALUE = 0x7FFFFFFF;
    public static final Class TYPE = VMClassLoader.getPrimitiveClass('I');
    public static final int SIZE = 32;
    private static final int MIN_CACHE = -128;
    private static final int MAX_CACHE = 127;
    private static Integer[] intCache = new Integer[256];
    private final int value;

    public static final String toString(int n, int n2) {
        if (n2 < 2 || n2 > 36) {
            n2 = 10;
        }
        char[] cArray = new char[33];
        int n3 = 33;
        boolean bl = false;
        if (n < 0) {
            bl = true;
            if ((n = -n) < 0) {
                cArray[--n3] = digits[-(n + n2) % n2];
                n = -(n / n2);
            }
        }
        do {
            cArray[--n3] = digits[n % n2];
        } while ((n /= n2) > 0);
        if (bl) {
            cArray[--n3] = 45;
        }
        return new String(cArray, n3, 33 - n3, true);
    }

    public static final String toHexString(int n) {
        return Integer.toUnsignedString(n, 4);
    }

    public static final String toOctalString(int n) {
        return Integer.toUnsignedString(n, 3);
    }

    public static final String toBinaryString(int n) {
        return Integer.toUnsignedString(n, 1);
    }

    public static final String toString(int n) {
        return String.valueOf(n);
    }

    public static final int parseInt(String string, int n) {
        return Integer.parseInt(string, n, false);
    }

    public static final int parseInt(String string) {
        return Integer.parseInt(string, 10, false);
    }

    public static final Integer valueOf(String string, int n) {
        return new Integer(Integer.parseInt(string, n, false));
    }

    public static final Integer valueOf(String string) {
        return new Integer(Integer.parseInt(string, 10, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final Integer valueOf(int n) {
        if (n < -128 || n > 127) {
            return new Integer(n);
        }
        Integer[] integerArray = intCache;
        synchronized (intCache) {
            if (intCache[n - -128] == null) {
                Integer.intCache[n - -128] = new Integer(n);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return intCache[n - -128];
        }
    }

    public final byte byteValue() {
        return (byte)this.value;
    }

    public final short shortValue() {
        return (short)this.value;
    }

    public final int intValue() {
        return this.value;
    }

    public final long longValue() {
        return this.value;
    }

    public final float floatValue() {
        return this.value;
    }

    public final double doubleValue() {
        return this.value;
    }

    public final String toString() {
        return String.valueOf(this.value);
    }

    public final int hashCode() {
        return this.value;
    }

    public final boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Integer && this.value == ((Integer)object).value) {
            bl = true;
        }
        return bl;
    }

    public static final Integer getInteger(String string) {
        return Integer.getInteger(string, null);
    }

    public static final Integer getInteger(String string, int n) {
        Integer n2 = Integer.getInteger(string, null);
        return n2 == null ? new Integer(n) : n2;
    }

    public static final Integer getInteger(String string, Integer n) {
        if (string == null || "".equals(string)) {
            return n;
        }
        if ((string = System.getProperty(string)) == null) {
            return n;
        }
        try {
            return Integer.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static final Integer decode(String string) {
        return new Integer(Integer.parseInt(string, 10, true));
    }

    public final int compareTo(Integer n) {
        if (this.value == n.value) {
            return 0;
        }
        return this.value > n.value ? 1 : -1;
    }

    public final int compareTo(Object object) {
        return this.compareTo((Integer)object);
    }

    public static final int bitCount(int n) {
        n = (n >> 1 & 0x55555555) + (n & 0x55555555);
        n = (n >> 2 & 0x33333333) + (n & 0x33333333);
        n = (n >> 4 & 0xF0F0F0F) + (n & 0xF0F0F0F);
        n = (n >> 8 & 0xFF00FF) + (n & 0xFF00FF);
        return (n >> 16 & (char)-1) + (n & (char)-1);
    }

    public static final int rotateLeft(int n, int n2) {
        return n << n2 | n >>> -n2;
    }

    public static final int rotateRight(int n, int n2) {
        return n << -n2 | n >>> n2;
    }

    public static final int highestOneBit(int n) {
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        n |= n >>> 16;
        return n ^ n >>> 1;
    }

    public static final int numberOfLeadingZeros(int n) {
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        n |= n >>> 16;
        return Integer.bitCount(~n);
    }

    public static final int lowestOneBit(int n) {
        return n & -n;
    }

    public static final int numberOfTrailingZeros(int n) {
        return Integer.bitCount((n & -n) - 1);
    }

    public static final int signum(int n) {
        int n2;
        if (n < 0) {
            n2 = -1;
        } else {
            n2 = 0;
            if (n > 0) {
                n2 = 1;
            }
        }
        return n2;
    }

    public static final int reverseBytes(int n) {
        return n >> 24 & 0xFF | n >> 8 & 0xFF00 | n << 8 & 0xFF0000 | n << 24 & 0xFF000000;
    }

    public static final int reverse(int n) {
        n = (n >> 1 & 0x55555555) + (n << 1 & 0xAAAAAAAA);
        n = (n >> 2 & 0x33333333) + (n << 2 & 0xCCCCCCCC);
        n = (n >> 4 & 0xF0F0F0F) + (n << 4 & 0xF0F0F0F0);
        n = (n >> 8 & 0xFF00FF) + (n << 8 & 0xFF00FF00);
        return (n >> 16 & (char)-1) + (n << 16 & 0xFFFF0000);
    }

    static final String toUnsignedString(int n, int n2) {
        int n3 = (1 << n2) - 1;
        char[] cArray = new char[32];
        int n4 = 32;
        do {
            cArray[--n4] = digits[n & n3];
        } while ((n >>>= n2) != 0);
        return new String(cArray, n4, 32 - n4, true);
    }

    static final int parseInt(String string, int n, boolean bl) {
        if (!bl && string == null) {
            throw new NumberFormatException();
        }
        int n2 = 0;
        int n3 = string.length();
        boolean bl2 = false;
        if (n3 == 0) {
            throw new NumberFormatException("string length is null");
        }
        int n4 = string.charAt(n2);
        if (n4 == 45) {
            if (n3 == 1) {
                throw new NumberFormatException("pure '-'");
            }
            bl2 = true;
            n4 = string.charAt(++n2);
        }
        if (bl) {
            if (n4 == 48) {
                if (++n2 == n3) {
                    return 0;
                }
                if ((string.charAt(n2) & 0xFFFFFFDF) == 88) {
                    n = 16;
                    ++n2;
                } else {
                    n = 8;
                }
            } else if (n4 == 35) {
                n = 16;
                ++n2;
            }
        }
        if (n2 == n3) {
            throw new NumberFormatException("non terminated number: " + string);
        }
        int n5 = Integer.MAX_VALUE / n;
        if (bl2 && Integer.MAX_VALUE % n == n - 1) {
            ++n5;
        }
        int n6 = 0;
        while (n2 < n3) {
            if (n6 < 0 || n6 > n5) {
                throw new NumberFormatException("number overflow (pos=" + n2 + ") : " + string);
            }
            n4 = Character.digit(string.charAt(n2++), n);
            n6 = n6 * n + n4;
            if (n4 >= 0 && (n6 >= 0 || bl2 && n6 == Integer.MIN_VALUE)) continue;
            throw new NumberFormatException("invalid character at position " + n2 + " in " + string);
        }
        return bl2 ? -n6 : n6;
    }

    public Integer(int n) {
        this.value = n;
    }

    public Integer(String string) {
        this.value = Integer.parseInt(string, 10, false);
    }
}

