/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader;

import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public final class ResourceKey
implements Serializable {
    private static final Map EMPTY_MAP = Collections.unmodifiableMap(new HashMap());
    private Map factoryParameters;
    private Integer hashCode;
    private Object schema;
    private Object identifier;
    private ResourceKey parent;
    private static final long serialVersionUID = -7764107570068726772L;

    public ResourceKey(Object object, Object object2, Map map) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (object2 == null) {
            throw new NullPointerException();
        }
        this.schema = object;
        this.identifier = object2;
        this.factoryParameters = map != null ? Collections.unmodifiableMap(new HashMap(map)) : EMPTY_MAP;
    }

    public ResourceKey(ResourceKey resourceKey, Object object, Object object2, Map map) {
        this(object, object2, map);
        this.parent = resourceKey;
    }

    public ResourceKey getParent() {
        return this.parent;
    }

    public Map getFactoryParameters() {
        return Collections.unmodifiableMap(this.factoryParameters);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ResourceKey resourceKey = (ResourceKey)object;
        if (!ObjectUtilities.equal((Object)this.parent, (Object)resourceKey.parent)) {
            return false;
        }
        if (!this.schema.equals(resourceKey.schema)) {
            return false;
        }
        if (!((Object)this.factoryParameters).equals(resourceKey.factoryParameters)) {
            return false;
        }
        if (this.identifier instanceof URL) {
            if (!String.valueOf(this.identifier).equals(String.valueOf(resourceKey.identifier))) {
                return false;
            }
        } else if (!this.identifier.equals(resourceKey.identifier)) {
            if (this.identifier instanceof byte[] && resourceKey.identifier instanceof byte[]) {
                byte[] byArray = (byte[])this.identifier;
                byte[] byArray2 = (byte[])resourceKey.identifier;
                if (!Arrays.equals(byArray, byArray2)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        if (this.hashCode == null) {
            int n = ((Object)this.factoryParameters).hashCode();
            n = 29 * n + this.schema.hashCode();
            n = 29 * n + this.identifier.hashCode();
            if (this.parent != null) {
                n = 29 * n + this.parent.hashCode();
            }
            this.hashCode = new Integer(n);
        }
        return this.hashCode;
    }

    public Object getIdentifier() {
        return this.identifier;
    }

    public Object getSchema() {
        return this.schema;
    }

    public String toString() {
        return "ResourceKey{schema=" + this.schema + ", identifier=" + this.identifier + ", factoryParameters=" + this.factoryParameters + ", parent=" + this.parent + '}';
    }
}

